#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#include"project.h"

void initialize(struct ssim *);
void initsite(struct site *sp,int z, int x, int y);
void initatom(struct atom *,struct ssim *,int i);


/*#################################################################*/  
void initialize(struct ssim *sd){ 

int Lx,Ly,H;
int i,j,k;
int tempi;
double tempf,teta;
FILE *fp;

fp=fopen("in","r");
if(fp==NULL){printf("missing input file\n"); exit(1);}


/*-----------------------------------------------------------------*/  
/*-----------------------------------------------------------------*/  
 fscanf(fp,"%d",&tempi); Lx=tempi;
 fscanf(fp,"%d",&tempi); Ly=tempi;
 fscanf(fp,"%d",&tempi); H=tempi;


/*-----------------------------------------------------------------*/  
/*-----------------------------------------------------------------*/  
sd->commondata.Lx=Lx;
sd->commondata.Ly=Ly;
sd->commondata.H=H;

fscanf(fp,"%d",&tempi);   sd->commondata.nsample=tempi;
fscanf(fp,"%lf",&tempf); sd->commondata.Tfinal=tempf; /*secs*/

sd->commondata.maxatomnum=H*Lx*Ly;
fscanf(fp,"%lf",&tempf);sd->commondata.teta=tempf; sd->commondata.numatoms=(int)floor(Lx*Ly*sd->commondata.teta);

/*-----------------------------------------------------------------*/  
/*-----------------------------------------------------------------*/  
fscanf(fp,"%lf",&tempf);sd->simparam.Temp=tempf; /*Kelvins*/
fscanf(fp,"%lf",&tempf);sd->simparam.Rimp=tempf;   /*per sec per m^2*/
fscanf(fp,"%lf",&tempf);sd->simparam.Es=tempf;   /*eV*/
fscanf(fp,"%lf",&tempf);sd->simparam.Eb=tempf;   /*eV*/
fscanf(fp,"%lf",&tempf);sd->simparam.Ees=tempf;   /*eV*/
fscanf(fp,"%lf",&tempf);sd->simparam.Do=tempf;   /*per sec*/
fscanf(fp,"%lf",&tempf);sd->simparam.ao=tempf;  /*m*/
fscanf(fp,"%d",&tempi);   sd->printopt.printapos=tempi;
fscanf(fp,"%d",&tempi);   sd->printopt.starthist=tempi;
fscanf(fp,"%d",&tempi);   sd->printopt.iterprog=tempi;
fscanf(fp,"%lf",&tempf);sd->simparam.Timpstart=tempf;  /*m*/
fscanf(fp,"%lf",&tempf);sd->simparam.Timpfinish=tempf;  /*m*/
fclose(fp);

sd->simparam.Do=2* 1.38066e-23 *sd->simparam.Temp / 6.62617e-34;

sd->commondata.Tstep=0.25/(sd->simparam.Do*exp(-sd->simparam.Es/K_b/sd->simparam.Temp));
sd->commondata.niterpersample=(int)floor(sd->commondata.Tfinal/sd->commondata.Tstep/sd->commondata.nsample);
sd->commondata.Tpersample=sd->commondata.niterpersample*sd->commondata.Tstep;
sd->commondata.Area=sd->simparam.ao*sd->simparam.ao*sd->commondata.Lx*sd->commondata.Ly;


printf("par nsample  %d \n",sd->commondata.nsample);
printf("par Lx       %d \n",sd->commondata.Lx);
printf("par Ly       %d \n",sd->commondata.Ly);
printf("par H        %d \n",sd->commondata.H );
printf("par Tfinal   %f \n",sd->commondata.Tfinal);
printf("par teta     %f \n",sd->commondata.teta);
printf("par Temp     %f \n",sd->simparam.Temp);
printf("par Rimp     %f \n",sd->simparam.Rimp);
printf("par Es       %f \n",sd->simparam.Es);
printf("par Eb       %f \n",sd->simparam.Eb);
printf("par Ees      %f \n",sd->simparam.Ees);
printf("par Do       %f \n",sd->simparam.Do);
printf("par ao       %f \n",sd->simparam.ao);
printf("par printapos  %d \n",sd->printopt.printapos);
printf("par starthist  %d \n",sd->printopt.starthist);
printf("par iterprog   %d \n",sd->printopt.iterprog);
printf("par Timpstart  %f \n",sd->simparam.Timpstart);
printf("par Timpfinish %f \n",sd->simparam.Timpfinish);
 



/*-----------------------------------------------------------------*/  
/*-----------------------------------------------------------------*/  
sd->sitearray=(struct site ***)malloc(sizeof(struct site **)*H);
for(i=0;i<H;i++)
   {sd->sitearray[i]=(struct site **)malloc(sizeof(struct site *)*Lx);
    for(j=0;j<Lx;j++)
       {sd->sitearray[i][j]=(struct site *)malloc(sizeof(struct site)*Ly);
        for(k=0;k<Ly;k++)
           {initsite(&(sd->sitearray[i][j][k]),i,j,k); } } 
    }

for(i=0;i<H;i++)
   {sd->sitearray[i][0   ][0   ].type=CORNERSITE;
    sd->sitearray[i][0   ][Ly-1].type=CORNERSITE;
    sd->sitearray[i][Lx-1][0   ].type=CORNERSITE;
    sd->sitearray[i][Lx-1][Ly-1].type=CORNERSITE;
    for(j=1;j<Lx-1;j++)
       {sd->sitearray[i][j][0   ].type=EDGESITE;
        sd->sitearray[i][j][Ly-1].type=EDGESITE; }
    for(k=1;k<Ly-1;k++)
        {sd->sitearray[i][0   ][k].type=EDGESITE;
         sd->sitearray[i][Lx-1][k].type=EDGESITE; }
    }




/*-----------------------------------------------------------------*/  
sd->islandata=(struct islandhist *)malloc(sizeof(struct islandhist));

sd->islandata->maxislandsize=Lx*Ly;
sd->islandata->maxislandnum =Lx*Ly;
sd->islandata->sizehist=(int *)malloc(sizeof(int)*sd->islandata->maxislandsize);
for(i=0;i<sd->islandata->maxislandsize;i++)
     sd->islandata->sizehist[i]=0;
sd->islandata->samplenum=0;

sd->islandata->meansize  =(double *)malloc(sizeof(double)*sd->commondata.nsample);
sd->islandata->numislands=(int     *)malloc(sizeof(int  )*sd->commondata.nsample);
sd->islandata->sampleislandsize=(int     *)malloc(sizeof(int  )*sd->islandata->maxislandnum);


/*-----------------------------------------------------------------*/  
sd->atomarray=(struct atom *)malloc(sizeof(struct atom)*sd->commondata.maxatomnum);
for(i=0;i<sd->commondata.numatoms;i++)
   {initatom(sd->atomarray+i,sd,i);
   }




/*-----------------------------------------------------------------*/  
sd->commondata.substrate.ap=(struct atom *)12343454;
sd->commondata.substrate.type=-1;
sd->commondata.substrate.zxy[0]=-1;
sd->commondata.substrate.zxy[1]= 0;
sd->commondata.substrate.zxy[2]= 0;


return;
}


/*#################################################################*/  
void initsite(struct site *sp,int z, int x, int y){
sp->ap=I_P;
sp->type=INSITE;
sp->zxy[0]=z;
sp->zxy[1]=x;
sp->zxy[2]=y;
}

/*#################################################################*/  
void initatom(struct atom *ap,struct ssim *sd,int i){

int j,k;

int empty;
ap->id=i;
ap->type=ATYPE0;
ap->status=CANMOVEPARL;
ap->nhb=0;
do{ j=(int)floor(LRAND*sd->commondata.Lx);
    k=(int)floor(LRAND*sd->commondata.Ly);
    empty=sd->sitearray[0][j][k].ap==NULL;
  } while(!empty);
sd->sitearray[0][j][k].ap=ap;
ap->sp=(struct site *)&(sd->sitearray[0][j][k]);
ap->island=-1;    

return;
}
