#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#include"project.h"

#ifndef  ONSUN
#define CLK_TCK 60
#include <sys/times.h>
#endif

int  main();
void initialize(struct ssim *);
void doMCstep(struct atom *,struct ssim *);
void doMCstep2(struct atom *,struct ssim *);
void printhistog(struct ssim *);
void writeatomdata(struct ssim *sd,int sc);
void writeopdata(struct ssim *sd);
void impinge(struct ssim *sd);
void findislands(struct ssim *sd);
void setprobabilities(struct ssim *sd);
void  writestepdensity(struct ssim *sd);
void getstd(struct ssim *sd);

void initseedarray(int l);
void initseed(int n);
void initatom(struct atom *,struct ssim *,int i);

void calctime (void) ;

static struct ssim *sd;

/*------------------------------------------------------*/
int main() {


int sc,ic,ac;
int impcntr;
int itercntr;
int i,j,k;


sd=(struct ssim *)malloc(sizeof(struct ssim));
initialize(sd);
initseedarray(10);

for(itercntr=0;itercntr<sd->printopt.iterprog;itercntr++)
{

sd->islandata->samplenum=0;
for(i=0;i<sd->islandata->maxislandsize;i++)
     sd->islandata->sizehist[i]=0;
sd->commondata.Time=0;
for(i=0;i<sd->commondata.H;i++)
   { for(j=0;j<sd->commondata.Lx;j++)
       { for(k=0;k<sd->commondata.Ly;k++)
           {initsite(&(sd->sitearray[i][j][k]),i,j,k); } }
    }

sd->commondata.numatoms=(int)floor(sd->commondata.Lx*sd->commondata.Ly*sd->commondata.teta);
for(i=0;i<sd->commondata.numatoms;i++)
   {initatom(sd->atomarray+i,sd,i);
   }



sd->commondata.niterperimp=(int)rint((double)(sd->commondata.nsample*sd->commondata.niterpersample)/(sd->simparam.Rimp*sd->commondata.Area*sd->commondata.Tfinal));
setprobabilities(sd);
writeopdata(sd);
writeatomdata(sd,0);
impcntr=0;

/*.........................................................*/
for(sc=0;sc<sd->commondata.nsample;sc++)
   {printf("spl %d \n",sc);fflush(NULL);
    sd->commondata.totalnumberofsteps=0;
    for(ic=0;ic<sd->commondata.niterpersample;ic++)
       {impcntr++; if(impcntr==sd->commondata.niterperimp) { impinge(sd); impcntr=0; }
        for(ac=0;ac<sd->commondata.numatoms;ac++)
           { doMCstep(sd->atomarray+ac,sd); }
       }
    getstd(sd);
    writestepdensity(sd);
    findislands(sd);
    writeatomdata(sd,sc); 
   }
printhistog(sd);

}
calctime();
return(0);
}

/*------------------------------------------------------*/
void impinge(struct ssim *sd){

int xp,yp,zp;

xp=(int)floor(LRAND*sd->commondata.Lx);
yp=(int)floor(LRAND*sd->commondata.Ly);
zp=sd->commondata.H-1;

while(zp>0)
     {if(sd->sitearray[zp-1][xp][yp].ap==NULL)
         zp--;
      else
        break;
     }

sd->atomarray[sd->commondata.numatoms].sp=&(sd->sitearray[zp][xp][yp]);
sd->atomarray[sd->commondata.numatoms].id= sd->commondata.numatoms;
sd->sitearray[zp][xp][yp].ap=&(sd->atomarray[sd->commondata.numatoms]);
sd->commondata.numatoms++;

sd->sitearray[zp][xp][yp].ap->type=ATYPE0;
sd->sitearray[zp][xp][yp].ap->status=CANMOVEPARL;
sd->sitearray[zp][xp][yp].ap->nhb=0;
sd->sitearray[zp][xp][yp].ap->island=0;

}


/*------------------------------------------------------*/
void writeatomdata(struct ssim *sd,int sc){
int i;
printf("ooo %d \n",sd->commondata.numatoms);

if(sd->printopt.printapos) 
if(!div(sc+1,sd->printopt.printapos).rem)
for(i=0;i<sd->commondata.numatoms;i++) 
  {printf("ppp %8d %8d %8d %8d %8d \n",i,sd->atomarray[i].sp->zxy[1],sd->atomarray[i].sp->zxy[2],sd->atomarray[i].sp->zxy[0],sd->atomarray[i].island); }
return;
}

/*------------------------------------------------------*/
void writeopdata(struct ssim *sd){
printf("odt %e %d %d \n", sd->commondata.Tstep, sd->commondata.niterpersample,sd->commondata.niterperimp);
}

/*------------------------------------------------------*/
void printhistog(struct ssim *sd){
int i;

for(i=0;i<sd->islandata->samplenum;i++)
   {printf("nil %d \n",sd->islandata->numislands[i]);}


for(i=0;i<sd->islandata->samplenum;i++)
   {printf("msz %e \n",sd->islandata->meansize[i]);}


for(i=0;i<sd->islandata->maxislandsize;i++)
   {printf("hst %d \n",sd->islandata->sizehist[i]);}

printf("std %f\n",(double)sd->commondata.totalnumberofsteps/(double)sd->commondata.niterpersample/
                  (double)(sd->commondata.Lx*sd->commondata.Ly));

return;
}


void  writestepdensity(struct ssim *sd){

printf("std %f\n",(double)sd->commondata.totalnumberofsteps/(double)sd->commondata.niterpersample/
                  (double)(sd->commondata.Lx*sd->commondata.Ly));

return;
}


/********************************/
void calctime (void) {
  struct tms t;
  int sec;

  times (&t);
  sec = ((int)(t.tms_stime + t.tms_utime))/CLK_TCK;

  printf ("cpu time:  %d sec\n", sec);
}
