#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#if defined(ONPC)
#define CLK_TCK 60
#include <sys/times.h>
#endif

#if defined(ONSUN)
#include <sys/types.h>
#include <sys/times.h>
#endif

#if defined(ONALPHA)
#define CLK_TCK 60
#include <sys/time.h>
#include <sys/times.h>
#endif


#include"project.h"

int  main();
void initialize(struct ssim *);
void doMCstep2(struct ssim *);
void printhistog(struct ssim *);
void writeatomdata(struct ssim *sd,int sc);
void writeopdata(struct ssim *sd);
void impinge(struct ssim *sd);
void findislands(struct ssim *sd);
void setprobabilities2(struct ssim *sd);
void initlist(struct ssim *sd);
void getstd(struct ssim *sd);
void  writestepdensity2(struct ssim *sd);
void fixlist(struct ssim *sd);


void initseedarray(int l);
void initseed(int n);
void initatom(struct atom *,struct ssim *,int i);
void initsite(struct site *sp,int z, int x, int y);

void calctime (void) ;


static struct ssim *sd;

/*------------------------------------------------------*/
int main() {


int sc;
int impcntr;
int itercntr;
int i,j,k;
int scdiv,impdiv;
int iii;
int jjj;

jjj=-1;

sd=(struct ssim *)malloc(sizeof(struct ssim));
initialize(sd);
initlist(sd);
initseedarray(10);


for(itercntr=0;itercntr<sd->printopt.iterprog;itercntr++)
{
sd->islandata->samplenum=0;
for(i=0;i<sd->islandata->maxislandsize;i++)
     sd->islandata->sizehist[i]=0;
sd->commondata.Time=0;
for(i=0;i<sd->commondata.H;i++)
   { for(j=0;j<sd->commondata.Lx;j++)
       { for(k=0;k<sd->commondata.Ly;k++)
           {initsite(&(sd->sitearray[i][j][k]),i,j,k); } } 
    }



sd->commondata.numatoms=(int)floor(sd->commondata.Lx*sd->commondata.Ly*sd->commondata.teta);
for(i=0;i<sd->commondata.numatoms;i++)
   {initatom(sd->atomarray+i,sd,i);
   }

fixlist(sd);

setprobabilities2(sd);
writeopdata(sd);
writeatomdata(sd,0);
impcntr=0;


sd->commondata.Tpersample=sd->commondata.Tfinal/sd->commondata.nsample;
sd->commondata.Timeperimp=1/(sd->simparam.Rimp*sd->commondata.Area);

sc=0;
impcntr=0;
sd->commondata.Tstep=0;
jjj=-1;
iii=0;
/*.........................................................*/
while(sd->commondata.Time<=sd->commondata.Tfinal)
     {iii++;
      if(iii==jjj)
         printf("adsfasdfadsf\n");
      scdiv=(int)floor(sd->commondata.Time/sd->commondata.Tpersample);
      if(scdiv>sc) 
        {sc=scdiv;
         printf("spl %d %f \n",sc,sd->commondata.Time);fflush(NULL);
         findislands(sd);
         getstd(sd);
         writeatomdata(sd,sc); 
         writestepdensity2(sd);
         sd->commondata.totalnumberofsteps=0;
         }

      impdiv=(int)floor(sd->commondata.Time/sd->commondata.Timeperimp);
      if( impdiv >impcntr )
        {
      if( (sd->commondata.Time <sd->simparam.Timpstart  ) )
         {impcntr=impdiv;
         }
      else if (sd->commondata.Time < sd->simparam.Timpfinish    )
           {while(impcntr<impdiv)
                 {
                  impcntr++;
                  impinge(sd);
                 }
            fixlist(sd);
            }
         }

       doMCstep2(sd);
       sd->commondata.Time+=sd->commondata.Tstep;
     }

printhistog(sd);
}

calctime();
return(0);
}
/********************************/
void calctime (void) {
  struct tms t;
  int sec;

  times (&t);
  sec = ((int)(t.tms_stime + t.tms_utime))/CLK_TCK;

  printf ("cpu time:  %d sec\n", sec);
}


/*------------------------------------------------------*/
void impinge(struct ssim *sd){

int xp,yp,zp;

xp=(int)floor(LRAND*sd->commondata.Lx);
yp=(int)floor(LRAND*sd->commondata.Ly);
zp=sd->commondata.H-1;

while(zp>0)
     {if(sd->sitearray[zp-1][xp][yp].ap==NULL)
         zp--;
      else
        break;
     }

sd->atomarray[sd->commondata.numatoms].sp=&(sd->sitearray[zp][xp][yp]);
sd->atomarray[sd->commondata.numatoms].id= sd->commondata.numatoms;
sd->sitearray[zp][xp][yp].ap=&(sd->atomarray[sd->commondata.numatoms]);
sd->commondata.numatoms++;

sd->sitearray[zp][xp][yp].ap->type=ATYPE0;
sd->sitearray[zp][xp][yp].ap->status=CANMOVEPARL;
sd->sitearray[zp][xp][yp].ap->nhb=0;
sd->sitearray[zp][xp][yp].ap->island=0;

return;

}


/*------------------------------------------------------*/
void writeatomdata(struct ssim *sd,int sc){
int i;
printf("ooo %d \n",sd->commondata.numatoms);

if(sd->printopt.printapos) 
if(!div(sc+1,sd->printopt.printapos).rem){
printf("ooa %d \n",sd->commondata.numatoms);
for(i=0;i<sd->commondata.numatoms;i++) 
  {printf("ppp %8d %8d %8d %8d %8d \n",i,sd->atomarray[i].sp->zxy[1],sd->atomarray[i].sp->zxy[2],sd->atomarray[i].sp->zxy[0],sd->atomarray[i].island); }
}
return;
}

/*------------------------------------------------------*/
void writeatomdatautil(struct ssim *sd,int sc){
int i;

FILE *ofp;

ofp=fopen("out","w");
fprintf(ofp,"ooo %d \n",sd->commondata.numatoms);

if(sd->printopt.printapos) 
if(!div(sc+1,sd->printopt.printapos).rem)
for(i=0;i<sd->commondata.numatoms;i++) 
  {fprintf(ofp,"ppp %8d %8d %8d %8d %8d \n",i,sd->atomarray[i].sp->zxy[1],sd->atomarray[i].sp->zxy[2],sd->atomarray[i].sp->zxy[0],sd->atomarray[i].island); }
fclose(ofp);
return;
}
/*------------------------------------------------------*/
void writeopdata(struct ssim *sd){
printf("odt %e %d %d \n", sd->commondata.Tstep, sd->commondata.niterpersample,sd->commondata.niterperimp);
}

/*------------------------------------------------------*/
void printhistog(struct ssim *sd){
int i;

for(i=0;i<sd->islandata->samplenum;i++)
   {printf("nil %d \n",sd->islandata->numislands[i]);}


for(i=0;i<sd->islandata->samplenum;i++)
   {printf("msz %e \n",sd->islandata->meansize[i]);}


for(i=0;i<sd->islandata->maxislandsize;i++)
   {printf("hst %d \n",sd->islandata->sizehist[i]);}


return;
}
void  writestepdensity2(struct ssim *sd){

printf("std %f\n",(double)sd->commondata.totalnumberofsteps/ (double)(sd->commondata.Lx*sd->commondata.Ly));

return;
}
