#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#include"project.h"
#include"mc.h"

static double probs[5];
static double probErh;
void setprobabilities(struct ssim *sd);

/*+++++++++++++++++++++++++++++++++++++++++++++++++*/
void setprobabilities(struct ssim *sd){
int i;
probs[0]=sd->commondata.Tstep*sd->simparam.Do*exp(-(0.0*sd->simparam.Eb+sd->simparam.Es )/K_b/sd->simparam.Temp);
probs[1]=sd->commondata.Tstep*sd->simparam.Do*exp(-(1.0*sd->simparam.Eb+sd->simparam.Es )/K_b/sd->simparam.Temp);
probs[2]=sd->commondata.Tstep*sd->simparam.Do*exp(-(2.0*sd->simparam.Eb+sd->simparam.Es )/K_b/sd->simparam.Temp);
probs[3]=sd->commondata.Tstep*sd->simparam.Do*exp(-(3.0*sd->simparam.Eb+sd->simparam.Es )/K_b/sd->simparam.Temp);
probs[4]=sd->commondata.Tstep*sd->simparam.Do*exp(-(4.0*sd->simparam.Eb+sd->simparam.Es )/K_b/sd->simparam.Temp);

probErh=exp(-(sd->simparam.Ees)/K_b/sd->simparam.Temp);

for(i=0;i<=4;i++) 
   if (probs[i]>1)
      {printf("R>1. maybe Tstep too big\n");
       exit(1);}
return;
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++*/
void doMCstep(struct atom *ap,struct ssim *sd){

struct site *np,*dp;
int fa[4]; /*full   */
int ea[4]; /*empty  */
int nn,ne;
double R;
int i,ix;
int move;

dp=getNeighbourSite(ap->sp,5,&(sd->commondata),sd->sitearray);
if(dp->ap==NULL)
  {nn=0;
   ne=0;
    for(i=0;i<4;i++)
       {np=getNeighbourSite(ap->sp,i,&(sd->commondata),sd->sitearray);
        if(np->ap==NULL)
          {ea[ne]=i;
           ne++;
           fa[i]=0;
           dp=getNeighbourSite(np,4,&(sd->commondata),sd->sitearray);
           if(dp->ap==NULL)
              {fa[i]=2; }
          }
        else
          { fa[i]=1;
            nn++; }
        }


    if(nn<3)
      { R=probs[nn];
        if(LRAND<R)
          { ix=ea[(int)floor(LRAND*ne)];
            move=ACCEPTED;
            if(fa[ix]==2)
              {if(LRAND>probErh)
                 move=DECLINED;
              }
            if(move==ACCEPTED)
               {if(fa[ix]==0)
                  { np=getNeighbourSite(ap->sp,ix,&(sd->commondata),sd->sitearray);
                    np->ap=ap;
                    ap->sp->ap=NULL;
                    ap->sp=np;
                  }
                else 
                  { np=getNeighbourSite(ap->sp,ix,&(sd->commondata),sd->sitearray);
                    i=np->zxy[0];
                    while(i>0)
                         {if(sd->sitearray[i-1][np->zxy[1]][np->zxy[2]].ap==NULL)
                             i--;
                          else
                            break;
                         }
                    np=&(sd->sitearray[i][np->zxy[1]][np->zxy[2]]);
                    np->ap=ap;
                    ap->sp->ap=NULL;
                    ap->sp=np;
                  }
               }
           }
      }
    }                 
return;            
}


/*------------------------------------------------*/
/* for fa                                         */
/* 0 is empty                                     */
/* 1 is full                                      */
/* 2 is a fall                                    */

/* fa is ordered like         5    top            */
/*                             2                  */
/*                           3  1                 */
/*                            0                   */
/*                            4   bottom          */
/*------------------------------------------------*/

#define UP    5
#define DOWN  4
#define SOUTH 0
#define WEST  1 
#define NORTH 2
#define EAST  3



/*+++++++++++++++++++++++++++++++++++++++++++++++++*/
struct site *getNeighbourSite(struct site *sp, int direction,struct common *cd,struct site ***sa){


struct site *np;


switch(direction) {
     case  UP   :   if(sp->zxy[0]>=cd->H)
                      {printf("---Atom on top layer. Saving and Exiting\n ");
                       exit(1);}
                     else
                        np=&(sa[sp->zxy[0]+1][sp->zxy[1]][sp->zxy[2]]);
                     break;

     case  DOWN :   if(sp->zxy[0]<0)
                      {printf("---Error: z<0\n");
                       exit(2);}
                    if(sp->zxy[0]==0)
                      np=&(cd->substrate);
                    else
/*                    np=sp-cd->Lx*cd->Ly; */
                      np=&(sa[sp->zxy[0]-1][sp->zxy[1]][sp->zxy[2]]);
                    break;

      case SOUTH :  if(sp->zxy[1]>=cd->Lx  )
                       {printf("---Error: x>=Lx\n");
                        exit(2);}
                    if(sp->zxy[1]==cd->Lx-1)
/*                     np=sp-(cd->Lx-1)*cd->Ly;*/
                      np=&(sa[sp->zxy[0]][0][sp->zxy[2]]);
                    else
/*                     np=sp+cd->Ly; */
                      np=&(sa[sp->zxy[0]][sp->zxy[1]+1][sp->zxy[2]]);
                    break;
                      
                       
      case NORTH :  if(sp->zxy[1]<0  )
                       {printf("---Error: x<=0\n");
                        exit(2);}
                    if(sp->zxy[1]==0)
/*                     np=sp+(cd->Lx-1)*cd->Ly;*/
                      np=&(sa[sp->zxy[0]][cd->Lx-1][sp->zxy[2]]);
                    else
/*                     np=sp-cd->Ly;*/
                      np=&(sa[sp->zxy[0]][sp->zxy[1]-1][sp->zxy[2]]);
                    break;
                      
                        
      case WEST  :  if(sp->zxy[2]<0  )
                       {printf("---Error: y<0\n");
                        exit(2);}
                    if(sp->zxy[2]==0)
/*                     np=sp+cd->Lx-1;*/
                        np=&(sa[sp->zxy[0]][sp->zxy[1]][cd->Ly-1]);
                    else
/*                     np=sp-1;*/
                        np=&(sa[sp->zxy[0]][sp->zxy[1]][sp->zxy[2]-1]);
                    break;
                      
      case EAST  :  if(sp->zxy[2]>=cd->Ly  )
                       {printf("---Error: y>=Ly\n");
                        exit(2);}
                    if(sp->zxy[2]==cd->Ly-1)
/*                     np=sp-cd->Lx-1;*/
                        np=&(sa[sp->zxy[0]][sp->zxy[1]][0]);
                    else
/*                     np=sp+1;*/
                        np=&(sa[sp->zxy[0]][sp->zxy[1]][sp->zxy[2]+1]);
                    break;
                      
      default     : printf("---Invalid direction:\n");
                    exit(2);
                    break;
      }

return(np);
}







/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void getstd(struct ssim *sd){
int i;
int ac,ne,nn;
struct atom *ap;
struct site *np;

for(ac=0;ac<sd->commondata.numatoms;ac++)
   {ap=sd->atomarray+ac;
       ne=0;nn=0;
       for(i=0;i<4;i++)
           {np=getNeighbourSite(ap->sp,i,&(sd->commondata),sd->sitearray);
            if(np->ap==NULL)
              ne++;
            else
              nn++;
           }
        sd->commondata.totalnumberofsteps+=ne;
   }
return;
}
