#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#include"project.h"
#include"mc.h"

static double probs[5];
static double probErh;

static int  *list[5];
static int  nlist[5]; 
void setprobabilities2(struct ssim *sd);

void updateconfig(struct ssim *sd,struct atom *ap,int *fa,struct site *nsp,struct site *bottom);

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void setprobabilities2(struct ssim *sd){
int i;
probs[0]=exp(-(0.0*sd->simparam.Eb+sd->simparam.Es )/K_b/sd->simparam.Temp);
probs[1]=exp(-(1.0*sd->simparam.Eb+sd->simparam.Es )/K_b/sd->simparam.Temp);
probs[2]=exp(-(2.0*sd->simparam.Eb+sd->simparam.Es )/K_b/sd->simparam.Temp);
probs[3]=exp(-(3.0*sd->simparam.Eb+sd->simparam.Es )/K_b/sd->simparam.Temp);
probs[4]=0.0;
probErh=exp(-(sd->simparam.Ees)/K_b/sd->simparam.Temp);

for(i=0;i<=4;i++) 
   if (probs[i]>1)
      {printf("R>1. maybe Tstep too big\n");
       exit(1);}
return;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void initlist(struct ssim *sd){
int i,j;

for(i=0;i<5;i++)
   {nlist[i]=0;
    list[i]=(int *)malloc(sizeof(int)*sd->commondata.maxatomnum);
    for(j=0;j<sd->commondata.maxatomnum;j++)
       list[i][j]=-1; 
   }

return;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void fixlist(struct ssim *sd){
int i,j;
int ac,ne,nn;
struct atom *ap;
struct site *np;

for(i=0;i<5;i++)
   {nlist[i]=0;
    for(j=0;j<sd->commondata.maxatomnum;j++)
         list[i][j]=-1;

   }

for(ac=0;ac<sd->commondata.numatoms;ac++)
   {ap=sd->atomarray+ac;
      {
       ne=0;nn=0;
       for(i=0;i<4;i++)
           {np=getNeighbourSite(ap->sp,i,&(sd->commondata),sd->sitearray);
            if(np->ap==NULL)
              ne++;
            else
              nn++;
           }
       list[nn][nlist[nn]]=ac;
       ap->listgroup=nn;
       ap->listaddress=nlist[nn];
       nlist[nn]++;
       }
/*   else
       {nn=5;
        list[nn][nlist[nn]]=ac;
        ap->listgroup=nn;
        ap->listaddress=nlist[nn];
        nlist[nn]++;
       }*/
   }
return;
}
/*+++++++++++++++++++++++++++++++++++++++++++++++++*/
void doMCstep2(struct ssim *sd){

double w[5];
double s[5];
double r;
int i,nn,ne;
struct site *np,*dp;
int fa[4];
int ea[4];
int ix,move;
double rn;
struct atom *ap;


for(i=0;i<5;i++)
   s[i]=0.0;

   w[0]=nlist[0]*probs[0];
   s[0]=w[0];
for(i=1;i<5;i++)
   { w[i]=nlist[i]*probs[i];
     s[i]=s[i-1]+w[i];
   }


rn=LRAND;
r=rn*s[4];
for(i=0;i<5;i++)
   {if(r<s[i])
      break;
   }

if(i==5)
   { printf("rate is 0. use larger simulation. exiting...\n");
     exit(1);
     
   }


rn=LRAND;

ix=(int)floor(rn*nlist[i]);
ap=sd->atomarray+list[i][ix];

dp=getNeighbourSite(ap->sp,5,&(sd->commondata),sd->sitearray);
if(dp->ap==NULL) 
  {
    sd->commondata.Tstep=1/s[4]/sd->simparam.Do;
    nn=0;
    ne=0;
    for(i=0;i<4;i++)
       {np=getNeighbourSite(ap->sp,i,&(sd->commondata),sd->sitearray);
        if(np->ap==NULL)
          {ea[ne]=i;
           ne++;
           fa[i]=0;
           dp=getNeighbourSite(np,4,&(sd->commondata),sd->sitearray);
           if(dp->ap==NULL)
              {fa[i]=2; }
          }
        else
          { fa[i]=1;
            nn++; }
        }
/*------------------------------------------------------------------------*/
            ix=ea[(int)floor(LRAND*ne)];
            move=ACCEPTED;
            if(fa[ix]==2)
              {if(LRAND>probErh)
                 move=DECLINED; }
            if(move==ACCEPTED)
               {if(fa[ix]==0)
                 {  np=getNeighbourSite(ap->sp,ix,&(sd->commondata),sd->sitearray);
                  updateconfig(sd,ap,fa,np,NULL); 
                  }
                else
                  {
                    np=getNeighbourSite(ap->sp,ix,&(sd->commondata),sd->sitearray);
                    i=np->zxy[0];
                    while(i>0)
                         {if(sd->sitearray[i-1][np->zxy[1]][np->zxy[2]].ap==NULL)
                             i--;
                          else
                            break;
                         }
                    np=&(sd->sitearray[i][np->zxy[1]][np->zxy[2]]);
                    if(i==0) 
                      {updateconfig(sd,ap,fa,np,NULL); 
                      }
                    else
                       { updateconfig(sd,ap,fa,np,&(sd->sitearray[i-1][np->zxy[1]][np->zxy[2]])); 
                       }
                  }
               }
    }
else
   {
    sd->commondata.Tstep=0;
/*  printf("rejeeeec\n");*/
   }
return;
}





/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void updateconfig(struct ssim *sd,struct atom *ap,int *fa,struct site *nsp,struct site *bottom){
int i;
struct site *np;
int lfa[4];
int nn;
int ixlast;

for(i=0;i<4;i++)
   {if(fa[i]==1)
      {np=getNeighbourSite(ap->sp,i,&(sd->commondata),sd->sitearray);
       if(nlist[np->ap->listgroup]>=1)
         {
          ixlast=nlist[np->ap->listgroup]-1;
          if(ixlast!=np->ap->listaddress)
            {sd->atomarray[list[np->ap->listgroup][ixlast]].listaddress=np->ap->listaddress;
             list[np->ap->listgroup][np->ap->listaddress]= list[np->ap->listgroup][ixlast]; }
          nlist[np->ap->listgroup]--;
          np->ap->listgroup--;
          
          ixlast=nlist[np->ap->listgroup];
          list[np->ap->listgroup][ixlast]=np->ap->id;
          np->ap->listaddress=ixlast;
          nlist[np->ap->listgroup]++;
         }
       else 
         {printf("error in list management....");exit(1);
         }
      }
   }

nsp->ap=ap;
ap->sp->ap=NULL;
ap->sp=nsp;

nn=0;
for(i=0;i<4;i++)
   {np=getNeighbourSite(nsp,i,&(sd->commondata),sd->sitearray);
    if(np->ap!=NULL)
      { lfa[i]=1;
        nn++;
      }
    else lfa[i]=0;
    }

       if(nlist[ap->listgroup]>=1){
          ixlast=nlist[ap->listgroup]-1;
          if(ixlast!=ap->listaddress)
            { sd->atomarray[list[ap->listgroup][ixlast]].listaddress=ap->listaddress;
             list[ap->listgroup][ap->listaddress]= list[ap->listgroup][ixlast];
            }
          nlist[ap->listgroup]--;
          ap->listgroup=nn;

          ixlast=nlist[ap->listgroup];
          list[ap->listgroup][ixlast]=ap->id;
          ap->listaddress=ixlast;
          nlist[ap->listgroup]++;
         }
       else 
         {printf("error in list management....");exit(1);
         }
         

for(i=0;i<4;i++)
   {if(lfa[i]==1)
      {np=getNeighbourSite(nsp,i,&(sd->commondata),sd->sitearray);
       if(nlist[np->ap->listgroup]>=1)
         {ixlast=nlist[np->ap->listgroup]-1;
          if(ixlast!=np->ap->listaddress)
            {sd->atomarray[list[np->ap->listgroup][ixlast]].listaddress=np->ap->listaddress;
             list[np->ap->listgroup][np->ap->listaddress]= list[np->ap->listgroup][ixlast];}
          nlist[np->ap->listgroup]--;
          np->ap->listgroup++;

          list[np->ap->listgroup][nlist[np->ap->listgroup]]=np->ap->id;
          np->ap->listaddress=nlist[np->ap->listgroup];
          nlist[np->ap->listgroup]++;
         }
       else 
         {printf("error in list management....");exit(1);
         }
      }
  }
/*
if(bottom)
  {       ap=bottom->ap;

       if(nlist[ap->listgroup]>=1)
         {ixlast=nlist[ap->listgroup]-1;
          if(ixlast!=ap->listaddress)
            {sd->atomarray[list[ap->listgroup][ixlast]].listaddress=ap->listaddress;
             list[ap->listgroup][ap->listaddress]= list[ap->listgroup][ixlast];}

          nlist[np->ap->listgroup]--;
          ap->listgroup=4;

          list[ap->listgroup][nlist[ap->listgroup]]=ap->id;
          ap->listaddress=nlist[ap->listgroup];
          nlist[ap->listgroup]++;}
       else 
         {printf("error in list management....");exit(1);
         }
  

         }
*/
return;

}
