/* constant definitions*/
#define I_INT  -1000
#define I_P    NULL
#define K_b    8.6667e-05

#ifdef ONSUN
#define LRAND drand48()
#else
#define LRAND (((double)random())/(((double)RAND_MAX)+1.0))
#endif

#define NOMOVE      0
#define CANMOVEPARL 1
#define CANMOVEDOWN 2

#define ATYPE0 0

#define INSITE     0
#define EDGESITE   2
#define CORNERSITE 4
/* global functions */
void WrapUp();


/*type declerations*/

/*-------------------------------------------------------*/
struct site {
       struct atom *ap;
       int type;
       int zxy[3];
       };

/*-------------------------------------------------------*/
struct atom {
       int          id;
       int          type;
       int          status;      /*tell us whether this can move or not, etc*/
       int          nhb;         /*num horizontal bonds*/
       struct site *sp;
       int          island;
       int          listgroup;
       int          listaddress;
       };

/*-------------------------------------------------------*/
struct param {
       double Temp;
       double Es;  /*surface energy*/
       double Eb;  /*bond energy*/
       double Ees; /*Erlich barrier difference*/
       double Do;  /*oscillation rate*/
       double Rimp; /*impingement rate*/
       double ao;   /*lattice parameter*/
       double Timpstart;
       double Timpfinish;
       };

/*-------------------------------------------------------*/
struct common {
       int  Lx;      /*a layer is of size L*L*/
       int  Ly;      /*a layer is of size L*L*/
       double teta;
       int  H;
       double Area;
       int  nsample;
       int  niterpersample;
       int  numatoms;

       double  Tfinal;
       double  Tstep;
       double  Tpersample; 
       double  Time;
       
       int maxatomnum;
       struct site substrate;

       int niterperimp;
       double Timeperimp;
 
       int totalnumberofsteps;
       };


/*-------------------------------------------------------*/
struct islandhist {
       int  maxislandsize;
       int  maxislandnum;
       int *sizehist;     /*an array of size maxislandsize*/
       int  samplenum;

       double *meansize;
       int    *numislands;

       int *sampleislandsize;

       };

struct printopt {
       int  printapos;
       int  starthist;
       int  iterprog;
};
/*-------------------------------------------------------*/
struct ssim {
       struct site  ***sitearray;
       struct atom    *atomarray;  /*we will make this a fixed length array of size LLH */
       struct param    simparam;
       struct common   commondata;
       struct islandhist  *islandata;
       struct printopt  printopt;
       };



