      subroutine binsum(lx,vtotal)
      implicit real*8(a-h,o-z)
      include 'cbins.cm'
c clamps programmed by d. ceperley at nrcc, 1978.
      include 'syspec.cm'
      include 'blank.cm'
      dimension dx(3)

      lofset=lforce-lx
      call bining(cc(lx+1)) ! get occupation of bins and linked lst

      do ibin=1,nbins ! master loop over all bins
      i=icc(lbin+ibin) ! pull out a particle label from lst
      if(i.gt.0) then ! if empty go on to next bin

      npini=0     ! npini= number of particles in bin i
11    npini=npini+1
      if(i.gt.natoms) go to 300 !DEBUG
      if(npini.gt.natoms) go to 300 ! DEBUG

      indi=ndim*(i-1)+lx
      ki=icc(ltype+i)
c store away these indices for use later
      icc(lpsave+npini)=ntypes*(ki-1) !type index
      icc(lpsave2+npini)=indi        !position index

      do j=1,npini-1 ! sum over other particles in this bin
      k=icc(lpsave+j)+ki
      indj=icc(lpsave2+j)
         r2=0.d0
         do l=1,ndim
            r=cc(indi+l)-cc(indj+l)
c no periodic boundary conditions are necessary if ndiv.ge.2
            dx(l)=r
            r2=r2+r*r
         enddo
         lc=cc(lcsi+k)*r2
         if(lc.lt.lenpot-1) then
            include 'cal_f.h'
            i1=indi+lofset
            i2=indj+lofset
            do l=1,ndim
                  f=ff*dx(l)
                  cc(i1+l)=cc(i1+l)+f
                  cc(i2+l)=cc(i2+l)-f
            enddo
        endif
      enddo
      i=icc(linkps+i)
      if(i.gt.0) go to 11 ! consider next particle in ibin

      inn=lnnlst+nborsu*(ibin-1)
      do j1=1,nbors2 !  loop now over neighboring bins
      inn=inn+1
      jbin=icc(inn)

      if(jbin.gt.nbins.or.jbin.eq.ibin.or.jbin.le.0) go to 300 !DEBUG
      j=jbin+lbin

      j=icc(j) ! first particle in jbin
203   if(j.le.0) go to 400
      if(j.gt.natoms) go to 300 !DEBUG
      indj=ndim*(j-1)+lx
      kj=icc(ltype+j)

      do i=1,npini
      k=icc(lpsave+i)+kj
      indi=icc(lpsave2+i)

          r2=0.d0 ! compute distance between i and j
          do l=1,ndim
              r=cc(indi+l)-cc(indj+l)
              include 'pbc.h'
              dx(l)=r
              r2=r2+r*r
          enddo
          lc=cc(lcsi+k)*r2

          if(lc.lt.lenpot-1) then
             include 'cal_f.h'
             i1=indi+lofset
             i2=indj+lofset
             do l=1,ndim
                 f=ff*dx(l)
                 cc(i1+l)=cc(i1+l)+f
                 cc(i2+l)=cc(i2+l)-f
             enddo
          endif
      enddo

c now get next particle in jbin
      j=icc(linkps+j)
      go to 203
400    continue
      enddo ! end over neighboring bins

      endif ! end of loop over ibin
      enddo

      return

300   write (6,301) i,ibin
301   format('  trouble in binsum ',2i20)
      call ldump
      return
      end
