      program clamps
      implicit real*8(a-h,o-z) 
      parameter (mnprm=20,nbarriers=5)
      integer*4 iseed,ncell(3),nexthit(nbarriers),freq(nbarriers)
     &  ,restart
      character qid*8,fs*14,qtime*26,p(mnprm)*16
     .,name(100)*8,frestart*14,punits(14)*8
      logical ife
      include 'syscon.cm'
      include 'blank.cm'
      include 'cbins.cm'
      include 'cunits.cm'
      include 'syspec.cm'
      include 'cewald.cm'
      include 'caver.cm'
      external second
      real*8 mprob

      write (*,*) ' input run id (lt 8 characters)'
      read (*,'(a)') qid
      lpx=index(qid,' ')-1

      fs=qid(1:lpx)//'.in'
      open(1,file=fs,status='old',form='formatted',err=200)
      goto 201

200   print*,"*** Couldn't open ",fs
      stop

201   continue

      inquire(file=qid(1:lpx)//'.out',exist=ife)
      open(6,file=qid(1:lpx)//'.out',form='formatted',status='unknown')
      if(ife) then
         write (*,*)' output file already exists'
       endif
      write (6,*) 'Simulation of a classical systems'
      write (6,*) 'CLAMPS version  9/99'
      write (6,*) ' run id = ',qid
      call timedate(qtime)


      open(10,file=qid(1:lpx)//'.xml')
      write(10,'(''<?xml version="1.0"?>'')')
c      write(10,'("<!DOCTYPE simIndex SYSTEM ''simIndex.dtd''>")')
      write(10,'("<!DOCTYPE simIndex>")')
      write(10,'("")')
      write(10,'(''<simIndex name="CLAMPS Simulation">'')') 
      write(10,'(''<sim name="'',a,''">'')')  qid(1:lpx)


! DEFINE DEFAULTS HERE
      ifmd=0 !ifmd.ne.0 impiles molecular dynamics will be used
      ifmc=0 !fmc.ne.0 implies monte carlo will be used
      ifpch=0 !ifpch.ne.0 print out lots of diagnostic information
      couple=1.d0  ! default coupling to charges
      nkcut=0  ! default for small k cutoff
      nshllse=0 ! extra k-shells
      ifbd=0  !ifbd.ne.0 brownian dynamics will be used
      ifply=0 ! polymers?
      iseed=0! use random seed when needed.
      nunits=0 ! default is reduced units
      restart=0 ! restart?
      ntypes=0
      natoms=0
      ndim=3
      temp=1.d0
      lenpot=1000
      dxpot=0.d0
      ro=0.d0
      minbin=1
      maxbin=30
      vcurrent=0  ! this is just for md
      heatmass=0.d0 ! default is to turn off nose-hoover thermostat
      ifnose = 0 ! default is no thermostat

!  some local variables to tell us certain files are being written out or not
      iwrt_sca = 0   ! scalars
      iwrt_crd = 0   ! coordinates

!read input 3 times: to fix dimension, for system info and for running.
1     j=ipickoff(1,p,n,mnprm)
      if(j.ne.0) go to 11
      if(n.le.0) go to 1
       if(p(1).eq.'TYPE') then
           ntypes=ntypes+1
           ncomps=intread(p(3))
           natoms=natoms+ncomps
       elseif(p(1).eq.'DIMENSION') then
           ndim=intread(p(2))
           if(ndim.le.0.or.ndim.gt.3) then
              write (6,*)'DIMENSION bad',ndim
              stop
           endif
       elseif(p(1).eq.'BOXSIZE') then
            ell(1)=rlread(p(2))
            do l=2,ndim
              if(l+1.le.n) then
                 ell(l)=rlread(p(l+1))
              else
                  ell(l)=ell(l-1)
              endif
            enddo
       elseif(p(1).eq.'TEMPERATURE') then
           temp=rlread(p(2))
       elseif(p(1).eq.'TABLE_LENGTH') then
           lenpot=intread(p(2))
           if(n.gt.2) dxpot=rlread(p(3))
       elseif(p(1).eq.'UNITS') then
            nunits=n-1
            do i=1,nunits
              punits(i)=p(i+1)
            enddo
       elseif(p(1).eq.'DENSITY') then
            ro=rlread(p(2))
       elseif(p(1).eq.'RUN') then
            if(p(2).eq.'MD') ifmd=1
            if(p(2).eq.'MC') ifmc=1
            if(p(2).eq.'BD') ifbd=1
       elseif(p(1).eq.'DEBUG') then
            ifpch=1
       elseif(p(1).eq.'SEED') then
            iseed=intread(p(2))
       elseif(p(1).eq.'RESTART') then
            restart=2
            frestart=qid(1:lpx)//'.chk'
       elseif(p(1).eq.'READ_STATE') then
            restart=1
            if(n.gt.1) then
               ln=index(p(2),' ')-1
               frestart=p(2)(1:ln)//'.chk'
             else
               frestart=qid(1:lpx)//'.chk'
             endif
       elseif(p(1).eq.'SETBIN')then
            if(n.ge.2)minbin=intread(p(2))
            if(n.ge.3)maxbin=intread(p(3))
       elseif(p(1).eq.'EWALD')then
            nkcut=intread(p(2)) 
             if(n.gt.2) then
              couple=rlread(p(3))
             else
              couple=1.d0
             endif
             write (*,*)'nkcut couple ',nkcut,couple
       elseif(p(1).eq.'READ_K') then
            if(n.eq.1)stop
            ln=index(p(2),' ')-1
            open(80,file=p(2)(1:ln))
            read(80,*) nshllse,nkvectse
            write (6,*)'extra shells and kvectors ',nshllse,nkvectse
c jhc - read in the box size for the coords
       elseif(p(1).eq.'READ_COORD') then
         if(n.gt.1) then
             ln=index(p(2),' ')-1
             fs=p(2)(1:ln)//'.crd'
          else
              fs=qid(1:lpx)//'.crd'
          endif
         open(60,file=fs,form='formatted')
         read (60,*) (ell(l),l=1,ndim)
         close(60)
c jhc - offset the input dimensions to prevent problems in binvi
         do i=1,ndim
            ell(i) = ell(i) + 1e-5
         enddo

       endif

      go to 1
11    write (6,*)' finished first pass'
      rewind (1)

      call units(punits,nunits) ! check units and detemine beta and masses

c jhc - compute number density (if not given in input) from box_size.
c       If box_size also not given than you're in trouble.
      if(ro.le.0.d0) then
         ro = natoms
         do i=1,ndim
            ro = ro/ell(i)
         enddo
      else
         do l=1,ndim
          ell(l)=(natoms/ro)**(1.d0/ndim)
         enddo
      endif
      do l=1,ndim ! construct .5*ell
        el2(l)=ell(l)*.5
      enddo

c jhc - open output file for MC acceptance data
      if (ifmc.ne.0) open(17,file=qid(1:lpx)//'.ar')

      write (6,60) ntypes,ndim
60    format(/10x,'the number of different chemical types is',i20/
     +10x,'the spatial dimensionality is',i3)
      write (6,61) ro,uname(2),ndim,temp,uname(5)
61    format(10x,'the number density =',e12.5,2x,'particles per '
     +,a8,' ** ',i2/10x
     +,'the temperature is',e15.6,2x,a8)

      kx=ndim*natoms ! are is the total  number of x coordinates
       write (6,300) natoms
300   format(/' total number of particles',i10)
      call caches(ltype,natoms,'types',2)
      call caches(lxold,kx,'xold',1)
      if(ifmd.ne.0) then
        call caches(lforce,kx,'force',1)
        call caches(lvelo,kx,'velocity',1)
        call caches(lpsave,natoms,'psave',2)
        call caches(lpsave2,natoms,'psave2',2)
        call caches(lmassiv,natoms,'massiv',1)

      endif

      if(ntypes.eq.0) then
           write (*,*)' problem-no particle types'
           stop
      endif
c reserve space in cc for all arrays depending on ntypes
      call caches(lcomp,ntypes,'types',2)
      call caches(lchrg,ntypes,'charge',1)
      call caches(ldcnst,ntypes,'diff cons',1)
      call caches(lmass,ntypes,'mass',1)
      call caches(laname,ntypes,'names',1)
      nt2=ntypes**2
      call caches(lcsi,nt2,'csi',1)
      call caches(lepsf,nt2,'epsf',1)
      call caches(leps,nt2,'eps',1)
      call caches(lsigma,nt2,'sigma',1)
      call caches(lcutf,nt2,'cutf',1)
      call caches(lnfun,nt2,'nfun',2)
      call caches(ltab,nt2,'tab',2)


      itype=0
      ifchrg=0
2     j=ipickoff(1,p,n,mnprm)  !SECOND PASS
      if(j.ne.0) go to 22
      if(n.le.0) go to 2

        if(p(1).eq.'TYPE') then
           itype=itype+1
           name(itype)=p(2)
           write (6,*)' name ',name(itype)
           icc(lcomp+itype)=intread(p(3))
            write (*,*)'ncomps',icc(lcomp+itype)
           if(n.gt.3)then
              cc(lmass+itype)=rlread(p(4))
              if(cc(lmass+itype).le.0) cc(lmass+itype)=1.
c multiply masses by absmas to get real masses
              cc(lmass+itype)=cc(lmass+itype)*absmas
           endif
           if(n.gt.4) then
              cc(lchrg+itype)=rlread(p(5))
              if(cc(lchrg+itype).ne.0.0) ifchrg=1 !set flag to do ewald sums
           endif
           if(n.gt.5) then
              cc(ldcnst+itype)=rlread(p(6))
           endif
c default for friction coefficent is mass
           if(cc(ldcnst+itype).le.0.0) cc(ldcnst+itype)=cc(lmass+itype)
c now make a real diffusion constant
           cc(ldcnst+itype)=cc(ldcnst+itype)/(beta*cc(lmass+itype))

         elseif(p(1).eq.'POTENTIAL') then
         if(n.ne.7) then
             write (*,*)' wrong arguments for POT'
             stop
          endif
           it=ifind(p(2),name,ntypes)
           jt=ifind(p(3),name,ntypes)
           if(it.le.0.or.jt.le.0) then
             write(*,*) ' no match of type in POT'
             stop
           endif
           ii=jt+(it-1)*ntypes
           icc(lnfun+ii)=intread(p(4))
           cc(lsigma+ii)=rlread(p(5))
           cc(leps+ii)  =rlread(p(6))
           cc(lcutf+ii) =rlread(p(7))
           ij=it+(jt-1)*ntypes !  make symmetric matrices
           icc(lnfun+ij)=icc(lnfun+ii)
           cc(lsigma+ij)=cc(lsigma+ii)
           cc(leps+ij)=cc(leps+ii)
           cc(lcutf+ij)=cc(lcutf+ii)
         elseif(p(1).eq.'LATTICE') then
            if(n.ge.2) then
               nxtal=intread(p(2))
             else
               nxtal=0
             endif
             if(2+ndim.le.n) then
                do l=1,ndim
                  ncell(l)=intread(p(2+l))
                enddo
              else
                  do l=1,ndim
                   ncell(l)=0
                  enddo
              endif
              call  sites(cc(lxold+1),natoms,ndim,nxtal,ro,ncell,ell)
          elseif(p(1).eq.'POLYMER') then
           it=ifind(p(2),name,ntypes)
           if(ifply.ne.0) call setply

         endif        


      go to 2
22    write (6,*)' finished second pass'

      rewind (1)
c chemical types are grouped together icc(ltype+i) gives the type
c  of particle i

      ind=ltype
      do i=1,ntypes
         nci=icc(lcomp+i)
         do j=1,nci
            ind=ind+1
            icc(ind)=i
         enddo
      enddo
        if(ifmd.eq.1) then
        do i=1,natoms
         cc(lmassiv+i)=1.d0/cc(lmass+icc(ltype+i))
        enddo
        endif


c if charges are present initialize fourier space ewald sums
      write (*,*)' ifchrg= ',ifchrg
      if(ifchrg.ne.0) call setchg(nkcut,nshllse,nkvectse)

      if(ifmd.ne.0.or.ifbd.ne.0) then ! initialize table of forces and potentials
         iffor=0
      else
         iffor=-1
      endif
      call calpo(iffor,cutmx)
c print out information about the potential and system
      call prtpot(iffor,cutmx,dxpot)
c intialize arrays for monte carlo,molecular dynamics or polymers
c intialize the binsorting package
      call setbin(cutmx,ifpch,minbin,maxbin)


      isets=0   ! counts number of different sets finished
      nsets=0   ! set number to begin on
      ndone=0   ! block number to begin on
      if(restart.gt.0) then
           open(65,file=frestart,form='unformatted')
           call pickup(restart,qid,65)
           close(65)
      else ! set seed if it will not be set below.
           call easy_init_rng(iseed)
           write (6,*)' SEED ',iseed
           call easy_print_rng()
      endif
      open(53,file=qid(1:lpx)//'.chk',form='unformatted') ! checkpoint file


!THIRD PASS = run the simulation
      do i=1,nbarriers ! Default is no data writes
      freq(i)=0   !
      enddo
       
      ifzero=0   !zero averages
      ifran=0    !randomize velocities

      call setav(jtime,'time','secs.',1)

3     j=ipickoff(1,p,n,mnprm)
      if(j.ne.0) go to 33
      if(n.le.0) go to 3


      if(p(1).eq.'RUN') then ! beginning of third pass
         isets=isets+1
         if(isets.lt.nsets) go to 3 ! no execution if a restart
           nsets=max(nsets,isets)
           if(restart.le.1) ndone=0
         nsteps=intread(p(3))  ! read input
         mpsteps=intread(p(4))  ! moves per step
         mprob=rlread(p(5))   ! probability of moving single atom
         if(n.ge.6)tau=rlread(p(6))
         if(n.ge.7) then
             tbath=rlread(p(7))
         else
             tbath=0.d0
         endif

         do i=1,nbarriers
            if(freq(i).le.0) then
               nexthit(i)=0
             else
               nexthit(i)=freq(i)*(ndone/freq(i)+1)
             endif
         enddo
          call second(tlast)
!        write (*,*)' start ',(freq(i),i=1,nbarriers)
!        write (*,*)' start ',(nexthit(i),i=1,nbarriers)
600      continue                            !LOOP OVER NUMBER OF STEPS

         nextstop=nsteps ! find next stopping time
         do i=1,nbarriers
            if(nexthit(i).gt.ndone)nextstop=min(nextstop,nexthit(i))
         enddo

         isteps=nextstop-ndone                !CALL METHOD DRIVERS
         if(p(2).eq.'MD') call moldy(isteps,tbath)
         if(p(2).eq.'MC') call monte(isteps,mpsteps,mprob)
         if(p(2).eq.'BD') call brown(isteps)
         if(p(2).eq.'PR') call snake(isteps)

         ndone=nextstop
         call second(tnow)                   !MONITOR EXECUTION TIME
         deltat=tnow-tlast
         tlast=tnow
         avtemp(jtime)=avtemp(jtime)+deltat
         anorm(jtime)=anorm(jtime)+isteps

         if(ndone.eq.nexthit(1)) call sumav !CALL OUTPUT DRIVERS
         if(ndone.eq.nexthit(2)) call wconf
         if(ndone.eq.nexthit(3)) call spill(qid)
         if(ndone.eq.nexthit(4)) call wsofk
         if(ndone.eq.nexthit(5)) call quench
     .    (qrate,cc(lvelo+1),ndim,natoms,beta,temp,cc(lmassiv+1))

         do i=1,nbarriers
             if(ndone.eq.nexthit(i))nexthit(i)=nexthit(i)+freq(i)
         enddo
         if(ndone.lt.nsteps)go to 600         !FINISHED WITH THIS COMMAND?
601      continue
         call zeroav
         call spill(qid) ! always write checkpoint file at last step
      elseif(p(1).eq.'WRITE_SCALARS') then
         freq(1)=intread(p(2))
         call openunit(51,qid(1:lpx)//'.sca',restart,freq(1),'steps')
         iwrt_sca = 1

      elseif(p(1).eq.'WRITE_COORD') then
         freq(2)=intread(p(2))
         call openunit(52,qid(1:lpx)//'.crd',restart,freq(2),'steps')
         if (restart.eq.0) then
            write(52,'(''#boxlen '',3e12.3)')  (ell(l),l=1,ndim)
            write(52,'(''#corner '',3e12.3)')  (-el2(l),l=1,ndim)
         endif
         iwrt_crd = 1

      elseif(p(1).eq.'CHECKPOINT') then
         freq(3)=intread(p(2))

      elseif(p(1).eq.'WRITE_SOFK')then
         freq(4)=intread(p(2))
         call openunit(54,qid(1:lpx)//'.sk',restart,freq(4),'steps')
         if(restart.eq.0)  
     &   write (54,'(a7,20e10.3)')'#VALUE ',(cc(lknorm+k),k=1,nshlls)
         call caches(lsofk,nshlls,'sofk',1)
         nsofk=0
         do k=1,nshlls
           cc(lsofk+k)=0.d0
         enddo
      elseif(p(1).eq.'QUENCH') then
        freq(5) = intread(p(2))
        if(n.gt.2) then
          qrate=rlread(p(3))
         else
            qrate=1.d0
         endif
      elseif(p(1).eq.'NOSE') then
       heatmass=rlread(p(2))
       ifnose = 1

       elseif(p(1).eq.'READ_COORD') then
         if(n.gt.1) then
             ln=index(p(2),' ')-1
             fs=p(2)(1:ln)//'.crd'
          else
              fs=qid(1:lpx)//'.crd'
          endif
         open(60,file=fs,form='formatted')
c jhc - first skip over box size values
         read (60,*) (cc(lxold+l),l=1,ndim)
         do i=1,natoms
c jhc - need to offset position in cc by the atom number
          read (60,*) itype,(cc(lxold+ndim*(i-1)+l),l=1,ndim)
c          read (60,*) itype,(cc(lxold+l),l=1,ndim)
         enddo
         close(60)

      endif

      go to 3
33    continue

c write out the XML file 

c  for MD
      if ((iwrt_sca.ne.0).and.(ifmd.ne.0)) then
         write(10,'(''  <dataGroup name="Scalar Observables, MD">'')')

c  Total Energy
         write(10,'(''    <tensor name="Total Energy">'')')
         write(10,'(''     <asciiData file="'',a,''" col="2"/>'')') 
     >            qid(1:lpx)//'.sca'
         write(10,
     >'(''     <interpreter class="analyzer.interp.ScalarDataset"/>'')')
         write(10,'(''    </tensor>'')')

c  Kinetic Energy
         write(10,'(''    <tensor name="Kinetic Energy">'')')
         write(10,'(''     <asciiData file="'',a,''" col="3"/>'')') 
     >            qid(1:lpx)//'.sca'
         write(10,
     >'(''     <interpreter class="analyzer.interp.ScalarDataset"/>'')')
         write(10,'(''    </tensor>'')')

c Potential Energy
         write(10,'(''    <tensor name="Potential Energy">'')')
         write(10,'(''     <asciiData file="'',a,''" col="4"/>'')') 
     >            qid(1:lpx)//'.sca'
         write(10,
     >'(''     <interpreter class="analyzer.interp.ScalarDataset"/>'')')
         write(10,'(''    </tensor>'')')

c Extended System Total Energy 
         if (ifnose.ne.0) then
            write(10,
     >'(''    <tensor name="Extended System Total Energy">'')')
            write(10,'(''     <asciiData file="'',a,''" col="6"/>'')') 
     >            qid(1:lpx)//'.sca'
            write(10,
     >'(''     <interpreter class="analyzer.interp.ScalarDataset"/>'')')
            write(10,'(''    </tensor>'')')
         endif

         write(10,'(''  </dataGroup>'')')
      endif

      if ((iwrt_sca.ne.0).and.(ifmc.ne.0)) then
         write(10,'(''  <dataGroup name="Scalar Observables, MC">'')')
c Potential Energy
         write(10,'(''    <tensor name="Potential Energy">'')')
         write(10,'(''     <asciiData file="'',a,''" col="5"/>'')') 
     >            qid(1:lpx)//'.sca'
         write(10,
     >'(''     <interpreter class="analyzer.interp.ScalarDataset"/>'')')
         write(10,'(''    </tensor>'')')
c jhc - Acceptance Ratios
         write(10,'(''  <dataGroup name="Acceptance Ratios">'')')
c Acceptance Ratio for type 1
         write(10,'(''    <tensor name="Atom A Moves">'')')
         write(10,'(''     <asciiData file="'',a,''" col="2"/>'')') 
     >            qid(1:lpx)//'.sca'
         write(10,
     >'(''     <interpreter class="analyzer.interp.ScalarDataset"/>'')')
         write(10,'(''    </tensor>'')')
c Acceptance Ratio for type 2
         write(10,'(''    <tensor name="Atom B Moves">'')')
         write(10,'(''     <asciiData file="'',a,''" col="3"/>'')') 
     >            qid(1:lpx)//'.sca'
         write(10,
     >'(''     <interpreter class="analyzer.interp.ScalarDataset"/>'')')
         write(10,'(''    </tensor>'')')
c Acceptance Ratio for type 3
         write(10,'(''    <tensor name="A,B Atom Swaps">'')')
         write(10,'(''     <asciiData file="'',a,''" col="4"/>'')') 
     >            qid(1:lpx)//'.sca'
         write(10,
     >'(''     <interpreter class="analyzer.interp.ScalarDataset"/>'')')
         write(10,'(''    </tensor>'')')
         write(10,'(''  </dataGroup>'')')
         write(10,'(''  </dataGroup>'')')
      endif

      if ((iwrt_sca.ne.0).and.(ifbd.ne.0)) then
         write(10,'(''  <dataGroup name="Scalar Observables, BD">'')')
c Potential Energy
         write(10,'(''    <tensor name="Potential Energy">'')')
         write(10,'(''     <asciiData file="'',a,''" col="4"/>'')') 
     >            qid(1:lpx)//'.sca'
         write(10,
     >'(''     <interpreter class="analyzer.interp.ScalarDataset"/>'')')
         write(10,'(''    </tensor>'')')
c Acceptance Ratio
         write(10,'(''    <tensor name="Acceptance Ratio">'')')
         write(10,'(''     <asciiData file="'',a,''" col="3"/>'')') 
     >            qid(1:lpx)//'.sca'
         write(10,
     >'(''     <interpreter class="analyzer.interp.ScalarDataset"/>'')')
         write(10,'(''    </tensor>'')')
         write(10,'(''  </dataGroup>'')')
      endif
     
c  Configuration based quantites  (g(r),S(k))
      if (iwrt_crd.ne.0) then
         write(10,'(''  <dataGroup name="Correlation Functions">'')')
      write(10,'(''    <tensor name="Configurations">'')')
         write(10,'(''     <configData file="'',a,''"/>'')') 
     >            qid(1:lpx)//'.crd'
         write(10,
     >'(''     <interpreter class="analyzer.interp.grFromConfig"/>'')')
         write(10,
     >'(''     <interpreter class="analyzer.interp.skFromConfig"/>'')')
         write(10,'(''    </tensor>'')')
         write(10,'(''  </dataGroup>'')')
      endif

       
      write(10,'(''</sim>'')')
      write(10,'(''</simIndex>'')')
c print out some diagnostics
      do itype=1,2
      call caches(mxword,0,nm1,itype)
      write (6,400) mxword
400   format('  maximum number of words used in caches ',i12)
      enddo
      write (6,402)
402   format(' end of simulation')
      stop
      end
