        program genshells
c generates shells of k-vectors
        implicit real*8 (a-h,o-z)
        parameter (mnsh=2000,ndim=3,mnkv=100000,pi=3.14159265,mnp=864
     + ,mdim=3)
        real*8 rknorm(mnsh), rkcomp(ndim,mnkv),tpiell(ndim),ell(ndim)
     + ,rsites(ndim,mnp),pwmt(mnkv*2),rhok(2*mnkv)
        integer kmult(0:mnsh),iflag(mnsh),mult(mnsh),kcomp(ndim),idim(2)
     + ,ncell(3)
        character*16 name,p(13)
        character*5 filen

      write (*,*) 'input: nparts '
      read (*,*) nparts
      if(nparts.gt.mnp) stop
      rho=1.
      vol=nparts/rho
c read input crystal structure
      write (*,*) 'input crystal number of unit cells in each direction'
      write (*,*) 'crystal:1=sc,2=bcc,3=hcp,4=fcc(3d),3=triangular(2d)'
      read (*,*) nxtalp,(ncell(l),l=1,ndim)
      call sites(1,rsites,nparts,ndim,nxtalp,vol,ncell,ell,rnn,ndim)


        do l=1,ndim
        tpiell(l)=2*pi/ell(l)
        enddo
        write (*,*)' tpiel = ',tpiell(1),' cutk?'
        read (*,*) cutk

        call shells(ndim,tpiell,cutk,nshlls,rkcomp,rknorm,kmult,nvects
     +  ,mnkv,mnsh,ndim)
        write (6,25) nshlls,mnsh,nvects,mnkv
25      format(' nshlls ',2i8,' nvects ',2i8)

        write (*,*)' output file name'
        read (*,55) name
55      format(a)
        ln=index(name,' ')-1
        open(1,file=name(1:ln))

        do k=1,2*nvects
        rhok(k)=0.d0
        enddo

        do i=1,nparts
          call cossin(rsites(1,i),pwmt,2,nvects,ndim,rkcomp)
          do k=1,2*nvects
          rhok(k)=rhok(k)+pwmt(k)
          enddo
        enddo

        do  ks=1,nshlls
        iflag(ks)=0
        mult(ks)=kmult(ks)-kmult(ks-1)

          sksum=0.d0
          do kp=2*kmult(ks-1)+1,2*kmult(ks)
          sksum=sksum+rhok(kp)**2
          enddo

         if(sksum.gt.0.1)  then
          nc=nc+1
         write (6,31) ks,mult(ks),rknorm(ks),sksum/(mult(ks)*nparts)
          do kp=kmult(ks-1)+1,kmult(ks)
            sks= (rhok(2*kp-1)**2+rhok(2*kp)**2)
            if(sks.gt.0.1) then
            write (*,'(5f12.3)') (rkcomp(l,kp)/tpiell(l),l=1,ndim),
     &      sks/(nparts)
            nv=nv+1
            iflag(ks)=iflag(ks)+1
            endif
          enddo
            
         endif
        enddo
31      format(' rknorm and mult',2i5,2f14.4)


2       write (*,*)' number of vectors and ks chosen',nc,nv

        write (1,12) nc,nv

        do ks=1,nshlls
        if(iflag(ks).gt.0)then
         write (1,12) iflag(ks)
         do kp=kmult(ks-1)+1,kmult(ks)
            sks= (rhok(2*kp-1)**2+rhok(2*kp)**2)
              if(sks.gt.0.1) then

                do l=1,ndim
                n=rkcomp(l,kp)/tpiell(l) +100.01
                kcomp(l)=n-100
                enddo
              write (1,12) (kcomp(l),l=1,ndim),ifix(.01+sks/nparts)
              endif
         enddo
        endif
        enddo
12      format(4i5)

        end
