      subroutine ftpot(label,x,v,ifnew)
c computes potential in fourier space due to interaction of particle
c label at position x with other charges. ifnew equals zero, it uses
c cc(lrok+) for the collective coordinates and sets cc(lronew)=
c  cc(lrok)-cc(lplane) so that the next time if ifnew is nonzero
c cc(lronew)=cc(lronew)+cc(lplane) will be the collective coordinates
c  at the new position of x. the interaction energy is added to v.
c clamps programmed by d. ceperley at nrcc, 1978.
      implicit real*8 (a-h,o-z)
      include 'syspec.cm'
      include 'blank.cm'
      include 'cewald.cm'

      it=icc(ltype+label)
      charge=cc(lchrg+it)
c determine if charged
      if(charge.eq.0.0) return
c add portion of self interaction
      v=v+charge**2*selfen
c get plane waves at this point
      call plane(x,cc(lplane+1),charge)

      if(ifnew.eq.0) then
c old point rok is correct
          do k=1,nkvect
            cc(lronew+k)=cc(lrok+k)-cc(lplane+k)
          enddo
          lro=lrok
      else
          lro=lronew
          do  k=1,nkvect
            cc(lro+k)=cc(lro+k)+cc(lplane+k)
          enddo
      endif

      kup=0
c compute potential now by summing over shells
      do  ks=1,nshlls
           kdn=kup+1
           kup=icc(lkmult+ks)
           vs=0.0d0
           do  k=kdn,kup
              vs=vs+cc(lro+k)*cc(lplane+k)
           enddo
         v=v+cc(lftpot+ks)*vs
      enddo
      return
      end
