      subroutine monte(isteps,mpstep,mprob)
c performs isteps/particle metropolis monte carlo steps
      implicit real*8 (a-h,o-z)
      include 'syscon.cm'
      include 'caver.cm'
      include 'cunits.cm'
c clamps programmed by d. ceperley at nrcc, 1978.
      include 'syspec.cm'
      include 'blank.cm'
      include 'cewald.cm'
      dimension xnew(3),counters(3)
      character*8 qn2,qn4,qn7,qn8,qn9
      real*8 mprob

      if(jmcara.eq.0) then ! intialize bins for averages
        data jmcara,jmcarb,jmcsar,qn2/0,0,0,'mc.pe.'/
        data qn7,qn8,qn9/'A ar','B ar','A<->B ar'/
        call setav(jmcara,qn7,ratio,1)
        call setav(jmcarb,qn8,ratio,1)
        call setav(jmcsar,qn9,ratio,1)
        call setav(jmcpe,qn2,uname(1),1)
        if(ifply.ne.0) call setav(jmcvbd,qn4,uname(1),1)
        data qn4/'vbondm'/
      endif

c jhc - initialize move type counters 
c       1-> A move 2-> B move 3-> AB swap
      do i=1,3
         counters(i) = 0
      enddo

      if(ifbins.ne.0)call bining(cc(lxold+1))
c for charged systems intialize collective coordinates
      if(ifchrg.ne.0) call rok(cc(lxold+1),cc(lrok+1))

      do  ipass=1,isteps
      lx=lxold
      do  imoved=1,mpstep
c jhc - macc.eq.1 -> move accepted
         macc = 0

         
c jhc - choose move type (0->Single atom move,1->double atom switch)
         if (rng().gt.mprob) then 
            mtype = 1
         else 
            mtype = 0
         endif

c jhc - single atom move
         if (mtype.eq.0) then
c jhc - randomly choose atom to move
            labelA = 1 + int(natoms*rng())
            labelA = min(natoms,labelA)

c jhc - increment move type counter
            curtype = icc(ltype+labelA)
            counters(curtype) = counters(curtype)+1
            
c jhc - compute initial potential
            ibold = 0
            lx = lxold + (labelA-1)*ndim
            call potofp(cc(lx+1),labelA,vold,ibold,ipold,ifply,vbold)

c randomly dispace particles inside a cube
            do  l=1,ndim
               r=cc(lx+l)+tau*(rng()-.5)
c     enforce periodic boundary conditions on new point
               include 'pbc.h'
               xnew(l)=r
            enddo

c get potential energy at this new point
            ibnew=1
            call potofp(xnew,labelA,vnew,ibnew,ipnew,ifply,vbnew)

c compute acceptance probability
            pexp=beta*(vold-vnew)
            prob=exp(min(0.0d0,max(-200.d0,pexp)))
            if(prob.gt.rng()) then
c     accept move
               macc = 1
               call accept(xnew,labelA,ibold,ibnew,ipold)
               if (ifbins.eq.1) call bining(cc(lxold))
c jhc - increment acceptance counter
               if (curtype.eq.1) then
                  avtemp(jmcara)=avtemp(jmcara)+1.
               else
                  avtemp(jmcarb)=avtemp(jmcarb)+1.
               endif
            endif

c jhc - switch two atoms
         else
c jhc - increment move type counter
            counters(3) = counters(3)+1
         
c jhc - choose two atoms at random, one from each type (this only valid for ntype=2)
c       This ensures that we at least try a swap.
c labelA -> type 1
            labelA = 1 + int(icc(lcomp+1)*rng())
            labelA = min(icc(lcomp+1),labelA)
c labelB -> type 2         
            labelB = 1 + int(icc(lcomp+2)*rng())
            labelB = icc(lcomp+1) + min(icc(lcomp+2),labelB)

c            write(17,*) 'AtomA: ', labelA,' labelA: ', icc(ltype+labelA)
c            write(17,*) 'AtomB: ', labelB,' labelB: ', icc(ltype+labelB)
c            call flush(17)

c jhc - compute intial potential energy
            lxA=lxold+(labelA-1)*ndim
            iboldA=0
            call potofp(cc(lxA+1),labelA,voldA,iboldA,ipold,ifply,vbold)
            lxB=lxold+(labelB-1)*ndim
            iboldB=0
            call potofp(cc(lxB+1),labelB,voldB,iboldB,ipold,ifply,vbold)
            vold = voldA + voldB

c jhc - now switch atom types
            idummy = icc(ltype+labelA)
            icc(ltype+labelA) = icc(ltype+labelB)
            icc(ltype+labelB) = idummy

c jhc - get potential energy with atoms exchanged
            ibnewA=0
            ibnewB=0
            call potofp(cc(lxA+1),labelA,vnewA,ibnewA,ipold,ifply,vbold)
            call potofp(cc(lxB+1),labelB,vnewB,ibnewB,ipold,ifply,vbold)
            vnew = vnewA + vnewB

c jhc - now return atoms to original types
            idummy = icc(ltype+labelA)
            icc(ltype+labelA) = icc(ltype+labelB)
            icc(ltype+labelB) = idummy

c jhc - compute acceptance probability 
            pexp=beta*(vold-vnew)

c            write(17,*) ' vold: ',vold,'  vnew: ',vnew 
c            write(17,*) ' pexp: ', pexp
c            call  flush(17)

            prob=exp(min(0.0d0,max(-200.d0,pexp)))
            if(prob.gt.rng()) then
c     accept move
               macc = 1

               call accept2(labelA,labelB)

c jhc - increment acceptance counter
               avtemp(jmcsar)=avtemp(jmcsar)+1.
            endif

c jhc now do average pe
            avtemp(jmcpe)=avtemp(jmcpe)+prob*(vnew-vold)+
     +                     (vold/(mtype+1))
            if(ifply.ne.0)avtemp(jmcvbd)=avtemp(jmcvbd)+
     +         prob*(vbnew-vbold)+vbold

         endif
      enddo
      call averages
      enddo

c  add to normalization of averages
      ant=float(isteps*mpstep)
      anorm(jmcpe)=anorm(jmcpe)+2*ant
      anorm(jmcara)=anorm(jmcara)+counters(1)
      anorm(jmcarb)=anorm(jmcarb)+counters(2)
      anorm(jmcsar)=anorm(jmcsar)+counters(3)
      if(ifply.ne.0) anorm(jmcvbd)=anorm(jmcvbd)+isteps*2


c jhc - print out averages to read without analyzer program
 90   format(6x,a,7x,i8,2x,i8,4x,f7.5)
      write(17,*) '     Current Averages: '
      write(17,*) '     Event:  Total:    Accepted:   Ratio: '
      write(17,90) '1',int(anorm(jmcara)),int(avtemp(jmcara)),
     .     avtemp(jmcara)/anorm(jmcara)
      write(17,90) '2',int(anorm(jmcarb)),int(avtemp(jmcarb)),
     .     avtemp(jmcarb)/anorm(jmcarb)
      write(17,90) '3',int(anorm(jmcsar)),int(avtemp(jmcsar)),
     .     avtemp(jmcsar)/anorm(jmcsar)
      call flush(17)

      return
      end
