      subroutine plane(x,sincos,charge)
c computes the set of orthogonal plane waves for a particle at
c position x and puts them in sincos
      implicit real*8 (a-h,o-z)
      include 'cewald.cm'
      include 'syspec.cm'
      dimension x(3),sincos(3)
      include 'blank.cm'

      do 1 l=1,ndim
      index=lscos(l)
      n=nkspan(l)
c store in cc(lscos+j) sines and cosines. j=0 contains 1.0. j.gt.0
c contains sq2*cos(j*tpiell(l)), j.lt.0 contains -sq2*sin(j*tpiell(l)).
      cc(index)=1.0
      if(n.le.0) go to 1
      arg=tpiell(l)*x(l)
      s=sin(arg)
      c=cos(arg)
      data sqtwo/1.4142135623731/
      s0=sqtwo*s
      c0=sqtwo*c
      j=0
c for j.gt.1 compute sines and cosines by recursion.
2     j=j+1
      cc(index+j)=c0
      cc(index-j)=s0
      if(j.eq.n) go to 1
      sn=s0*c+c0*s
      c0=c0*c-s0*s
      s0=sn
      go to 2
1     continue

      n=nkspan(1) ! multiply table in x-direction by charge
      index=lscos(1)
      cc(index)=charge
      if(n.gt.0) then
      do j=1,n
         cc(index+j)=charge*cc(index+j)
         cc(index-j)=charge*cc(index-j)
      enddo
      endif

c construct vector of plane waves from pointers in icc(lkcomp+)
      j=lkcomp+1
      do 3 k=1,nkvect
      l=1
      jj=icc(j)
      sorc=cc(jj)
5      j=j+1
      if(l.eq.ndim) go to 3
      jj=icc(j)
      sorc=sorc*cc(jj)
      l=l+1
      go to 5
3     sincos(k)=sorc

      return
      end
