
c compile with f77 -o gofr gofr.f
c  (for IBM, may need to use xlf)
c For this assignment, you will need to fill in these subroutines 
c  cgofr  - accumulate the a histogram
c  wgofr - normalize and write out output
c
c
c  The main program reads the .chk file to get essential system
c  information.  Then it asks for some user input.  It opens
c  the  .crd file (has the actual configurations) and calls
c   cgofr after each configuration has been read.
c  Finally it calls wgofr to normalize the histogram and write out g(r).


      program gofr
      implicit real*8 (a-h,o-z)
      parameter (nx=10000,mtypes=10)
      parameter (mt2=mtypes**2)
      character qid*8,fs*14,uname(5)*8,name(mtypes)*8,tag*32
      character qdt*8,qdat*26
      real *8 x(3,nx),velo(nx),beta,ro,temp,chrg(mtypes),mass(mtypes)
     .  ,dcnst(mtypes),ell(3),eps(mt2),sigma(mt2),cutf(mt2)
      real*8 el2(3)
      integer ndim,natoms,ntypes,nunits,comp(mtypes),nfun(mt2)
     .,type(nx),g(10000)

!First we open the checkpoint file
      write (*,*) ' gofr : input run id (lt 8 characters)'
      read (*,'(a)') qid
      lpx=index(qid,' ')-1
      fs=qid(1:lpx)//'.chk'
      write (*,*) ' trying to open file ',fs
      open(1,file=fs,status='old',form='unformatted')

      read (1) qdt,qdat,ifply,kx,(x(l,1),l=1,kx)
      write (6,10) qdt,qdat
10    format(' reading  for coordinates'/
     +' identification of pickup ',3a8)
      write (6,11) kx,ifply
11    format(' number of coordinates and ifply',2i10)

      if(ifply.ne.0) then
          stop
!         read (1) nchain,(icc(lhead+l),icc(lchnad+l)
!    .      ,icc(lenchn+l),l=1,nchain),spring,rzero
!          write (6,13) nchain
!3    format(' polymer descriptors also found for ',i10,'chains')
      endif

      read (1) nsets,ndone,ifmd,nblock
      print*,'nsets',nsets,'ndone',ndone

      if(ifmd.ne.0) read (1) (velo(l),l=1,kx)


      read (1)
     1 ndim,natoms,ntypes,beta,ro,temp,nunits,(uname(l),l=1,nunits)
     2,(comp(l),chrg(l),mass(l),dcnst(l)
     3,name(l),l=1,ntypes),nt2,(ell(l),l=1,ndim),(eps(l)
     4,sigma(l),cutf(l),nfun(l),l=1,nt2)

       write (*,*)' ndim',ndim,'natoms=',natoms

       do i=1,10000
        g(i)=0
       enddo
       write (*,*)' input number to skip in beginning'
       read (*,*)nskip
       write (*,*)'input table spacing '
       read (*,*)dr

      cutr=ell(1)
      do l=1,ndim
       el2(l)=0.5d0*ell(l)
       cutr=min(cutr,el2(l))
      enddo
      cutr2=cutr**2
      if(dr.le.0.d0) dr=0.01d0*cutr
      csi=1.d0/dr
      nbins = csi*cutr
      if(csi*cutr.gt.10000) then
          write (*,*)' memory in cgofr too small '
          stop
      endif

!Now open .crd and read and analyze configurations
      fs=qid(1:lpx)//'.crd'
      write (*,*) ' trying to open file ',fs
      open(2,file=fs,status='old',form='formatted')
      read (2,'(a32)') tag
c      write (*,'(a32)') tag
      read (2,'(a32)') tag
c      write (*,'(a32)') tag
      nconfig=0
      do isteps=1,9999999
        do i=1,natoms
         read (2,'(i1,3e13.5)',END=100) type(i),(x(l,i),l=1,ndim)
        enddo
         read (2,'(a32)',END=100) tag

        if(isteps.gt.nskip) then
         nconfig=nconfig+1
         call cgofr(x,ndim,natoms,ell,dr,g,nbins) !ADD CONTRIBUTION to g(r)
        endif

      enddo
100   write (*,*)' number of configurations =',nconfig

         call wgofr(ndim,natoms,ell,dr,g,nconfig,qid,nbins) !  WRITE FILE

      end

c-----------------------------------------------------------------------

      subroutine cgofr(x,ndim,natoms,ell,dr,gofr,nbins)
      implicit real*8 (a-h,o-z)
      real*8 x(3,natoms),ell(3),el2(3)
      integer gofr(10000),nbins

c  x - contains the coordinates of the atoms
c  ndim - number of dimensions
c  ell - the size of the box
c  dr - the size of each bin
c  gofr - the histogram for g(r)
c  nbins - the number of bins in gofr. Note the this is determined by 
c           the minimum box length / 2.

c  You will need to calculate distances from the coordinates in  x 
c  (don't forget periodic boundary conditions), and bin them, 
c  and accumulate the results in gofr.

      end

c-----------------------------------------------------------------------
      subroutine wgofr(ndim,natoms,ell,dr,gofr,nconfig,qid,nbins)
      implicit real*8 (a-h,o-z)
      real*8 ell(3),dr,sa(3),v,vlast,deltav,pi,constant
      character qid*(*)
      integer gofr(10000),ndim,natoms,nconfig,nbins

c  ndim - number of dimensions
c  natoms - number of atoms
c  ell - size of box
c  dr - bin size
c  gofr - histogram for g(r)
c  nconfig - the number of configurations used in computing gofr
c             this will be the # of configurations in the .crd file minus
c              the number skipped at the beginning.
c  qid - the run id, used for openin the runid.gr file
c  nbins - the size of gofr


      if(nconfig.le.0) return

      lpx=index(qid,' ')-1
      open(3,file=qid(1:lpx)//'.gr',status='unknown',form='formatted')
         

         do i=1,nbins

c you will need to calculate the normalization 

           write (3,' (2e12.5,i10)') dr*(i-.5),norm*gofr(i),gofr(i)
         enddo
       end
