      subroutine rnbond(dx)
c clamps programmed by d. ceperley at nrcc, 1978.
      implicit real*8 (a-h,o-z)
      include 'syspec.cm'
      include 'cpoly.cm'
      dimension dx(3)
c this computes a random vector dx(ndim) from the probability
c  distribution exp(-beta*vbond) by a rejection technique
1     call gauran(bndsig,dx,ndim)
      r2=0.0
      do 2 l=1,ndim
2     r2=r2+dx(l)**2
c get bond potential
      call vchain(r2,v,f)
c calculate log of acceptance ratio
      alnar=.5*r2/bndsig-beta*v+bndnrm
c  note bndnrm must be chosen so that alnar.le.0
      if(alnar.gt.0.0) go to 5
      alnar=max(alnar,-100.d0)
      if(exp(alnar).lt.rng()) go to 1
c accept this displacement
      return
5     write (6,6) alnar,r2,bndsig,beta,bndnrm
6     format('  bndnrm was chosen too small in rnbond ',5e10.4)
      stop
      end
