      subroutine shells(ndim,a,cut,nshlls,lkcomp,lknorm,lkmult,nkspan
     . , nshllse, nkvectse)
      implicit real*8 (a-h,o-z)
      include 'blank.cm'
      real*8 a(ndim),x(3)
      integer ndim,nshlls,lkcomp,lknorm,lkmult,nkspan(3),nshllse
     .  ,nkvectse,icount(3)
c computes the vectors x(ndim)=(a(1)*n(1),..,a(ndim)*n(ndim))
c where n(i) are integers and x(1)**2+..+x(ndim)**2.le.cut**2
c the vectors n(i) are stored in icc(lkcomp+l+ndim+(i-)) in
c the order given by the values of their norms. the first
c vector is always (0,0,0). also nshlls gives the number of
c different values of the norms ( the relative square norms
c differ by less than 1.e-5) and cc(lknorm+i) gives
c these nshlls norms and icc(lkmult+i) is the last vector
c whose norm is given by cc(lknorm+i). hence the total
c number of vectors of magnitude less than cut is icc(lkmult+nshlls).
      c2=cut**2

      do ipass=1,2
c first time thru count number of vectors (nvects) and reserve space.
c second time store vectors and order them.
      npts=1
      do l=1,ndim
         nkspan(l)=int(0.00001d0+abs(cut/a(l)))
c range of search is (-nkspan(l),+nkspan(l))
         icount(l)=-nkspan(l)
         npts=(2*nkspan(l)+1)*npts
      enddo

      nvects=0
      do 3 i=1,npts
         rsq=0.0d0
         do l=1,ndim
            x(l)=icount(l)*a(l)
            rsq=rsq+x(l)**2
            if(rsq.gt.c2) go to 30
         enddo
         nvects=nvects+1 ! we have found a vector

      if(ipass.eq.2) then
        krsq=lknorm+nvects
        n1=nvects-1
        kvects=lkcomp+ndim*n1

c go thru previous vectors. if they have a greater norm move them up one slot
         do  j=1,n1
           if(cc(krsq-1).le.rsq) go to 8
           cc(krsq)=cc(krsq-1)
           do l=1,ndim
             icc(kvects+l)=icc(kvects+l-ndim)
           enddo
           krsq=krsq-1
           kvects=kvects-ndim
         enddo

c store the present vector and norm**2 
8       cc(krsq)=rsq
        do l=1,ndim
           icc(kvects+l)=icount(l)
        enddo
      endif

30    continue
       do l=1,ndim !increase counters with carries for the next vector
         icount(l)=icount(l)+1
         if(icount(l).le.nkspan(l)) go to 3
         icount(l)=-nkspan(l)
      enddo
3     continue

      if(ipass.eq.1) then ! reserve space for nvect vectors and norms
         call caches(lkcomp,ndim*(nvects+nkvectse),'kcomp',2)
         call caches(lknorm,nvects,'knorm',1)
      endif
      enddo

c reclaim space from that used by norms
      call caches(lknorm,-nvects,'knorm',1)

      do ipass=1,2
c first time thru count number of different norms (nshlls)  second time store them
      nshlls=0
      rmax=-1.0
      kvects=lkcomp

      do i=1,nvects
        rsq=0.0d0
        do l=1,ndim
           kvects=kvects+1
           rsq=rsq+(icc(kvects)*a(l))**2
        enddo

      if(abs(rsq-rmax).gt.1.e-5*rmax) then ! we have found a larger magnitude
         nshlls=nshlls+1
         rmax=rsq
      endif

      if(ipass.eq.2) then
         cc(lknorm+nshlls)=sqrt(rmax)
         icc(lkmult+nshlls)=i
      endif
      enddo

      if(ipass.eq.1) then ! reserve space for norms and cumlative multiplicities
         call caches(lknorm,nshlls+nshllse,'knorm',1)
         call caches(lkmult,nshlls+1+nshllse,'kmult',2)
         lkmult=lkmult+1 ! extra space for zero word
         icc(lkmult)=0
      endif
      enddo

! now read in "extra k-vectors"
      if(nshllse.le.0)return
      nvects=nvects+nkvectse ! add extra ones.
      nshlls=nshlls+nshllse

      do ks=nshlls-nshllse+1,nshlls
        read(80,*) mult
        icc(lkmult+ks)=icc(lkmult+ks-1)+mult
        do i=1,mult
         read(80,*)(icc(kvects+l),l=1,ndim)
         rsq=0.d0
         do l=1,ndim
            nkspan(l)=max(nkspan(l),abs(icc(kvects+l)))
            rsq=rsq+(icc(kvects+l)*a(l))**2
         enddo
         kvects=kvects+ndim
        enddo
        cc(lknorm+ks)=sqrt(rsq)
      enddo
      close(80)

      return
      end
