
c*****************************************************************
c
c    This subroutine select hydrogens, namely atom type 2, from 
c    the lattice and create and array of hydrogens, ihydtyp. 
c    Also, calculate the total number of hydrogen atoms, nhyd.  
c
      subroutine atom1
      include 'param.h'   
      include 'implicit.h'
      include 'common.h'
c
c     Identify atom type 1.
c
      nty1=0

      do 187 i=1,natoms
      if (itype(i).eq.1) then
        nty1 = nty1+1
        ity1(nty1) = i
         else
          go to 187
      end if
187   continue
c
      write(*,*) 'nty1: ', nty1

      return
      end


c*****************************************************************
c
c    This subroutine select hydrogens, namely atom type 2, from 
c    the lattice and create and array of hydrogens, ihydtyp. 
c    Also, calculate the total number of hydrogen atoms, nhyd.  
c
      subroutine atom2
      include 'param.h'   
      include 'implicit.h'
      include 'common.h'
c
c     Identify atom type 1.
c
      nty2=0

      do 187 i=1,natoms
      if (itype(i).eq.2) then
        nty2 = nty2+1
        ity2(nty2) = i
         else
          go to 187
      end if
187   continue
c
      write(*,*) 'ntyr2: ', nty2
 
      return
      end

c***************************************************************
c
c  this subroutine picks a particle and a corresponding displacement
c
c  this program is designed so that different applications requiring different
c  types of fundamental monte carlo steps can be accomodated by simply
c  replacing the routines getjmp, initjmp, advjmp, and modde.  The routine
c  getjmp returns a description of the atom, atoms, or periodic lengths that
c  are to be moved, changed, created or destroyed.
c
c  nmoved  the number of atoms to be changed (the set of periodic lengths
c          counts as one)
c  imoved  the array of numbers designating the atoms to be changed
c          if imoved(i) = 0, then either the i'th atom to be changed is to
c          be created or the change refers to the periodic length depending
c          on the value of itynew.
c  itynew  the array of new element types for the changed atoms
c          if itynew(i)=0, the i'th atoms is to be destroyed unless imoved(i)=0
c          in which case rvnew is to be treated as the new set of periodic
c          lengths
c  rvnew   the array of new position for the atoms (or the new set of periodic
c          lengths)
c  jmptyp  designates the type of move performed.  It is used only for keeping
c          track of the number of each type of move attempted and the sucess
c          rate for each type
      subroutine getjmp(imoved,rvnew,itynew,nmoved,jmptyp)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /jumpcomi/ ifixvl,ictype(natmax),jmpflg,nblck1(2),
     1                  nblck2(2),nfree(2),nchoice,ityp2,ntyp2,
     2                  imovbl(natmax),nmovbl
      common /jumpcomr/ prctst,delpos,dellen(3),delblk(3),fraccd,
     2                  sepmin,xmin,xmax,ymin,ymax,zmin,zmax,
     3                  xminc,xmaxc,yminc,ymaxc,zminc,zmaxc
      dimension imoved(nmovmx),rvnew(3,nmovmx),itynew(nmovmx)
      dimension dx(natmax),dy(natmax),dz(natmax)
c
c  branch to the type of moves as specified by jmpflg
c
      goto (1000,2000,3000,4000,5000) jmpflg
1000  continue
c
c  segregation version
c    pick atom, new type and displacement at random
c    and also change volume
c

cac
c   Decide which type of jump..
c   For this case we start with a fixed composition
c   and we try to observe segregation for this composition.
c   So, we interchange two atoms of each type simultaneously.
c
cac
  
c
      nx = 1 + int(3*ranl())
      nx = min(3,nx)

c TEST CASE: Allow only nx=3, which, means
c            interchange types of two atoms.

       nx=3

c END TEST

      go to (233,233,234) nx

233   continue
c     
c  Moving one atom at a time..
c
      nmoved = 1
      imoved(1) = ifixvl + int(float(nmovbl+1-ifixvl)*ranl())
      imoved(1) = min(imoved(1),nmovbl)
      imoved(1) = max(imoved(1),ifixvl)
      if (imoved(1).eq.0) goto 200
      imoved(1) = imovbl(imoved(1))

         itynew(1) = itype(imoved(1))

      rvnew(1,1) = rv(1,imoved(1)) + delpos*(ranl()-0.5)
      rvnew(2,1) = rv(2,imoved(1)) + delpos*(ranl()-0.5)
      rvnew(3,1) = rv(3,imoved(1)) + delpos*(ranl()-0.5)

      if (itynew(1).eq.1) jmptyp = 1
      if (itynew(1).eq.2) jmptyp = 3
      
100   continue

      return

234   continue

c
c  Work on nty1 and nty2...
c  where nty1: number of first kind of atoms
c  nty2: number of second kind of atoms
c

      nmoved = 2      
      imoved(1) = 1 + int(nty1*ranl())
      imoved(1) = min(nty1,imoved(1))
      nn=ity1(imoved(1))
      imoved(1) = nn
      itynew(1) = itype(imoved(1))  
 
      imoved(2) = 1 + int(nty2*ranl())
      imoved(2) = min(nty2,imoved(2))
      nn=ity2(imoved(2))
      imoved(2) = nn
      itynew(2) = itype(imoved(2))  

c   interchange types...
       
      im = itynew(1)
      itynew(1) = itynew(2)
      itynew(2) = im

      jmptyp = 2
  
c     update positions of the two
c     chosen atoms, namely, move them using Metropolis Algorithm.

       rvnew(1,1) = rv(1,imoved(1)) + delpos*(ranl()-0.5)
       rvnew(2,1) = rv(2,imoved(1)) + delpos*(ranl()-0.5)        
       rvnew(3,1) = rv(3,imoved(1)) + delpos*(ranl()-0.5)
       
       rvnew(1,2) = rv(1,imoved(2)) + delpos*(ranl()-0.5)
       rvnew(2,2) = rv(2,imoved(2)) + delpos*(ranl()-0.5)         
       rvnew(3,2) = rv(3,imoved(2)) + delpos*(ranl()-0.5)
   
      return

200   continue
c
c  change the volume
c
      jmptyp = 5
      itynew(1) = 0
      rvnew(1,1) = perlen(1)*(1.0 + dellen(1)*(ranl()-0.5))
      rvnew(2,1) = perlen(2)*(1.0 + dellen(2)*(ranl()-0.5))
      rvnew(3,1) = perlen(3)*(1.0 + dellen(3)*(ranl()-0.5))
      return
2000  continue
c
c  segregation by atom type interchange
c    pick 2 atoms interchange types and move both
c    and also change volume
c
      imoved(1) = ifixvl + int(float(natoms+1-ifixvl)*ranl())
      imoved(1) = min(imoved(1),natoms)
      imoved(1) = max(ifixvl,imoved(1))
      if (imoved(1).eq.0) goto 2200
      nmoved = 2
      imoved(2) = 1 + int(float(natoms)*ranl())
      itynew(1) = itype(imoved(2))
      itynew(2) = itype(imoved(1))
      rvnew(1,1) = rv(1,imoved(1)) + delpos*(ranl()-0.5)
      rvnew(2,1) = rv(2,imoved(1)) + delpos*(ranl()-0.5)
      rvnew(3,1) = rv(3,imoved(1)) + delpos*(ranl()-0.5)
      rvnew(1,2) = rv(1,imoved(2)) + delpos*(ranl()-0.5)
      rvnew(2,2) = rv(2,imoved(2)) + delpos*(ranl()-0.5)
      rvnew(3,2) = rv(3,imoved(2)) + delpos*(ranl()-0.5)
      jmptyp = itynew(1) + itynew(2) - 1
      return
c
2200  continue
c
c  change the volume
c
      nmoved = 1
      jmptyp = 4
      itynew(1) = 0
      rvnew(1,1) = perlen(1)*(1.0 + dellen(1)*(ranl()-0.5))
      rvnew(2,1) = perlen(2)*(1.0 + dellen(2)*(ranl()-0.5))
      rvnew(3,1) = perlen(3)*(1.0 + dellen(3)*(ranl()-0.5))
      return
3000  continue
c
c  block end version
c
      imoved(1) = nblck1(2) + int(float(nchoice)*ranl())
      if (imoved(1).eq.nblck1(2)) then
         nmoved = nblck1(2) - nblck1(1) + 1
         delx = delblk(1)*(ranl()-0.5)
         dely = delblk(2)*(ranl()-0.5)
         delz = delblk(3)*(ranl()-0.5)
         do 3100 i = 1,nmoved
         imoved(i) = nblck1(1) + i - 1
         itynew(i) = itype(imoved(i))
         rvnew(1,i) = rv(1,imoved(i)) + delx
         rvnew(2,i) = rv(2,imoved(i)) + dely
         rvnew(3,i) = rv(3,imoved(i)) + delz
3100     continue
         jmptyp = 1
         return
       endif
      if (imoved(1).eq.nblck2(1)) then
         nmoved = nblck2(2) - nblck2(1) + 1
         delx = delblk(1)*(ranl()-0.5)
         dely = delblk(2)*(ranl()-0.5)
         delz = delblk(3)*(ranl()-0.5)
         do 3200 i = 1,nmoved
         imoved(i) = nblck2(1) + i - 1
         itynew(i) = itype(imoved(i))
         rvnew(1,i) = rv(1,imoved(i)) + delx
         rvnew(2,i) = rv(2,imoved(i)) + dely
         rvnew(3,i) = rv(3,imoved(i)) + delz
3200     continue
         jmptyp = 2
         return
       endif
      nmoved = 1
      if (ranl().le.prctst) then
         itynew(1) = itype(imoved(1))
        else
         itynew(1) = 1 + mod(itype(imoved(1)),2)
        endif
      rvnew(1,1) = rv(1,imoved(1)) + delpos*(ranl()-0.5)
      rvnew(2,1) = rv(2,imoved(1)) + delpos*(ranl()-0.5)
      rvnew(3,1) = rv(3,imoved(1)) + delpos*(ranl()-0.5)
      jmptyp = 2*itynew(1) + itype(imoved(1))
      return
4000  continue
c
c  create and destroy type 2 section
c
c
c  determine if just moving atoms or if creating or destrrying type 2
c
      if (ranl().lt.fraccd) goto 4200
c
c    pick atom and displacement at random
c    or change volume
c
 4010 continue
      nmoved = 1
      imoved(1) = ifixvl + int(float(natoms+1-ifixvl)*ranl())
      if (imoved(1).eq.0) goto 4120
      x = rv(1,imoved(1))
      y = rv(2,imoved(1))
      z = rv(3,imoved(1))
      if (x.gt.xmax.or.x.lt.xmin) goto 4010
      if (y.gt.ymax.or.y.lt.ymin) goto 4010
      if (z.gt.zmax.or.z.lt.zmin) goto 4010
      itynew(1) = itype(imoved(1))
      rvnew(1,1) = rv(1,imoved(1)) + delpos*(ranl()-0.5)
      rvnew(2,1) = rv(2,imoved(1)) + delpos*(ranl()-0.5)
      rvnew(3,1) = rv(3,imoved(1)) + delpos*(ranl()-0.5)
      jmptyp = itynew(1)
      return
c
4120  continue
c
c  change the volume
c
      jmptyp = 3
      nmoved = 1
      itynew(1) = 0
      rvnew(1,1) = perlen(1)*(1.0 + dellen(1)*(ranl()-0.5))
      rvnew(2,1) = perlen(2)*(1.0 + dellen(2)*(ranl()-0.5))
      rvnew(3,1) = perlen(3)*(1.0 + dellen(3)*(ranl()-0.5))
      return
4200  continue
c
c  determine if creating or destroying a type 2
c
      volume = (xmax-xmin)*(ymax-ymin)*(zmax-zmin)/dbrog3(2)
      tst = pdestry(ntyp2,volume)
      if (ranl().lt.tst) goto 4300
c  create
      nmoved = 1
      imoved(1) = 0
      itynew(1) = 2
      per12x = 0.5*perlen(1)
      per12y = 0.5*perlen(2)
      per12z = 0.5*perlen(3)
      ntry = 1
4210  continue
      rvnew(1,1) = xmin + ranl()*(xmax-xmin)
      rvnew(2,1) = ymin + ranl()*(ymax-ymin)
      rvnew(3,1) = zmin + ranl()*(zmax-zmin)
      do 4220 i = 1,natoms
      dx(i) = rvnew(1,1) - rv(1,i)
      dx(i) = dx(i) - perlen(1)*nint(dx(i)/perlen(1))
      dy(i) = rvnew(2,1) - rv(2,i)
      dy(i) = dy(i) - perlen(2)*nint(dy(i)/perlen(2))
      dz(i) = rvnew(3,1) - rv(3,i)
      dz(i) = dz(i) - perlen(3)*nint(dz(i)/perlen(3))
      dx(i) = dx(i)**2 + dy(i)**2 + dz(i)**2
4220  continue
      rmin = 1.e6
      do 4230 i = 1,natoms
4230  rmin = min(rmin,dx(i))
      if (rmin.le.sepmin) goto 4000
      jmptyp = 4
      return
c
4300  continue
c
c  destroy
c
      if (ntyp2.le.0) goto 4000
      nmoved = 1
      jmptyp = 5
      itynew(1) = 0
      imoved(1) = ityp2 + int(ntyp2*ranl())
      return
5000  continue
c
c  create/destroy atoms in the region and in addition
c  displace and change volume
c
5100  continue
c
c  determine if creating or destroying an atom
c
      if (ranl().lt.fraccd) goto 5200
c
c    pick atom and displacement at random
c    or change volume
c
      nmoved = 1
      imoved(1) = ifixvl + int(float(natoms+1-ifixvl)*ranl())
      if (imoved(1).eq.0) goto 5120
      itynew(1) = itype(imoved(1))
      rvnew(1,1) = rv(1,imoved(1)) + delpos*(ranl()-0.5)
      rvnew(2,1) = rv(2,imoved(1)) + delpos*(ranl()-0.5)
      rvnew(3,1) = rv(3,imoved(1)) + delpos*(ranl()-0.5)
      jmptyp = 1
      return
c
5120  continue
c
c  change the volume
c
      jmptyp = 2
      nmoved = 1
      itynew(1) = 0
      rvnew(1,1) = perlen(1)*(1.0 + dellen(1)*(ranl()-0.5))
      rvnew(2,1) = perlen(2)*(1.0 + dellen(2)*(ranl()-0.5))
      rvnew(3,1) = perlen(3)*(1.0 + dellen(3)*(ranl()-0.5))
      return
5200  continue
c
c  determine if creating or destroying
c
      if (ranl().gt.0.5) goto 5300
c
c  destroying
c
      imoved(1) = 1 + int(natoms*ranl())
      nmoved = 1
      jmptyp = 3
      itynew(1) = 0
      return
5300  continue
c
c  create an atom
c
      jmptyp = 4
      nmoved = 1
      imoved(1) = 0
      itynew(1) = 1
      per12x = 0.5*perlen(1)
      per12y = 0.5*perlen(2)
      per12z = 0.5*perlen(3)
      ntry = 1
5310  continue
      xub = min(perub(1),xmax)
      xlb = max(perlb(1),xmin)
      yub = min(perub(2),ymax)
      ylb = max(perlb(2),ymin)
      zub = min(perub(3),zmax)
      zlb = max(perlb(3),zmin)
      rvnew(1,1) = xlb + ranl()*(xub-xlb)
      rvnew(2,1) = ylb + ranl()*(yub-ylb)
      rvnew(3,1) = zlb + ranl()*(zub-zlb)
      do 5320 i = 1,natoms
      dx(i) = rvnew(1,1) - rv(1,i)
      dx(i) = dx(i) - perlen(1)*nint(dx(i)/perlen(1))
      dy(i) = rvnew(2,1) - rv(2,i)
      dy(i) = dy(i) - perlen(2)*nint(dy(i)/perlen(2))
      dz(i) = rvnew(3,1) - rv(3,i)
      dz(i) = dz(i) - perlen(3)*nint(dz(i)/perlen(3))
      dx(i) = dx(i)**2 + dy(i)**2 + dz(i)**2
5320  continue
      rmin = 1.e6
      do 5330 i = 1,natoms
5330  rmin = min(rmin,dx(i))
      if (rmin.gt.sepmin) goto 5340
c      ntry = ntry + 1
c      if (ntry.gt.100) goto 5100
c      goto 5310
      goto 5000
5340  continue
      return
      end

CAC      function pdestry(n,v)
      function pdestry(n,v)

      pd = 0
      pc = 1.
      do 100 i = 1,n
         pd = (i/v)*pc
         pc = 1. - pd
  100    continue
      pdestry = pd
      return
      end

c**********************************************************************
c
c  initialize the getjump parameters
c
c  called once to perform any initialization needed by the getjmp and related
c  routines
c
      subroutine initjmp
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /jumpcomi/ ifixvl,ictype(natmax),jmpflg,nblck1(2),
     1                  nblck2(2),nfree(2),nchoice,ityp2,ntyp2,
     2                  imovbl(natmax),nmovbl
      common /jumpcomr/ prctst,delpos,dellen(3),delblk(3),fraccd,
     2                  sepmin,xmin,xmax,ymin,ymax,zmin,zmax,
     3                  xminc,xmaxc,yminc,ymaxc,zminc,zmaxc
c  prctst is the percent of jumps that keep the same type
c
      call rdjmp
c
      if (prctst.gt.1.0) prctst = 0.01*prctst
      if (prctst.gt.0.999) prctst = 1.0
      if (fraccd.gt.1.0) fraccd = 0.01*fraccd
      if (fraccd.gt.0.999) fraccd = 1.0
      if (fraccd.lt.0.0001) fraccd = 0.0
c
c  double delpos and dellen so that the input value is the maximum
c  displacement from the current value
c
      delpos = 2.0*delpos
      if (dellen(2).lt.-998.) dellen(2) = dellen(1)
      if (dellen(3).lt.-998.) dellen(3) = dellen(1)
      dellen(1) = 2.0*dellen(1)
      dellen(2) = 2.0*dellen(2)
      dellen(3) = 2.0*dellen(3)
      delblk(1) = 2.0*delblk(1)
      if (delblk(2).le.-998) then
         delblk(2) = delblk(1)
       else
         delblk(2) = 2.*delblk(2)
       endif
      if (delblk(3).le.-998) then
         delblk(3) = delblk(1)
       else
         delblk(3) = 2.*delblk(3)
       endif
c
c  branch to the type of jumps as determined by jmpflg
c
      goto (1000,2000,3000,4000,5000) jmpflg
      write(6,*)'invalid jmpflg',jmpflg
      call mcabort
1000  continue
      write(6,9001)
9001  format(1x,'type 1: 1 to 1',/,1x,'type 2: 2 to 2',/,
     1       1x,'type 3: Atom interchange',/,
     2       1x,'type 4: change periodic lengths')
      write(6,9002) prctst
9002  format(1x,'fraction of jumps which preserve particle type:',f8.4)
      write(6,9003) delpos
9003  format(1x,'maximum displacement in a given direction:',g12.5)
      write(6,9004) dellen
9004  format(1x,'maximum fractional change in a periodic length:',
     1       3g12.4)
c
c  determine which atoms are in the region for which changes are allowed
c  and those that are in the region where the composition can be changed
c
      nmovbl = 0
      do 100 i = 1,natoms
      if (rv(1,i).le.xmax.and.rv(1,i).ge.xmin.and.rv(2,i).le.ymax
     1    .and.rv(2,i).ge.ymin.and.rv(3,i).le.zmax
     2    .and.rv(3,i).ge.zmin) then
         nmovbl = nmovbl + 1
         imovbl(nmovbl) = i
       endif
      if(rv(1,i).le.xmaxc.and.rv(1,i).ge.xminc.and.rv(2,i).le.ymaxc
     1    .and.rv(2,i).ge.yminc.and.rv(3,i).le.zmaxc
     2    .and.rv(3,i).ge.zminc) then
         ictype(i) = 1
       else
         ictype(i) = 0
       endif
100   continue
      write(6,9111) nmovbl
9111  format(1x,'number of movable atoms:',i6)
      write(6,9112) xmin,xmax,ymin,ymax,zmin,zmax
9112  format(1x,'region in which movement is allowed',/,
     1 3(3x,2f12.4,/))
      write(6,9113) xminc,xmaxc,yminc,ymaxc,zminc,zmaxc
9113  format(1x,'region in which composition change is allowed',/,
     1 3(3x,2f12.4,/))
c
c  determine if the volume is going to be changed
c
      if (max(dellen(1),dellen(2),dellen(3)).le.0.0) then
         ifixvl = 1
       else
         ifixvl = 0
       endif
      return
2000  continue
c
c  this is the particle type interchange version
c
      write(6,9201)
9201  format(1x,'type 1: move 2 type 1 atoms',/,
     1       1x,'type 2: move and interchange a type 1 and 2',/,
     2       1x,'type 3: move 2 type 2 atoms',/,
     3       1x,'type 4: change periodic lengths')
      write(6,9203) delpos
9203  format(1x,'maximum displacement in a given direction:',g12.5)
      write(6,9204) dellen
9204  format(1x,'maximum fractional change in a periodic length:',
     1       3g12.4)
c
c  determine if the volume is going to be changed
c
      if (max(dellen(1),dellen(2),dellen(3)).le.0.0) then
         ifixvl = 1
       else
         ifixvl = 0
       endif
      return
3000  continue
c
c  have two blocks of atoms at each end of the list which move as
c  units and the rest move freely.  no change in type
c  or periodic lengths
c
      nfree(1) = nblck1(2) + 1
      nfree(2) = nblck2(1) - 1
      nchoice = 2 + (nfree(2)-nfree(1)+1)
      return
4000  continue
c
c  the creation and destructin of type 2 atoms that are assumed at the
c  end of the list
c
      if (xmin.le.-9999.) xmin = perlb(1)
      if (ymin.le.-9999.) ymin = perlb(2)
      if (zmin.le.-9999.) zmin = perlb(3)
      if (xmax.ge.9999.) xmax = perub(1)
      if (ymax.ge.9999.) ymax = perub(2)
      if (zmax.ge.9999.) zmax = perub(3)
      write(6,9401)
9401  format(1x,'type 1: move Ni',/,1x,'type 2: move He',/,
     1       1x,'type 3: change V',/,1x,'type 4: create He',/,
     2       1x,'type 5: destroy He')
      write(6,9402) fraccd
9402  format(1x,'fraction of jumps which create/destroy He:',f8.4)
      write(6,9403) delpos
9403  format(1x,'maximum displacement in a given direction:',g12.5)
      write(6,9404) dellen
9404  format(1x,'maximum fractional change in a periodic length:',
     1       3g12.4)
      write(6,9405) xmin,xmax,ymin,ymax,zmin,zmax
9405  format(1x,'bounds for creation of type 2 atoms',/,
     1  '   x:',2f10.5,/,
     1  '   y:',2f10.5,/,
     1  '   z:',2f10.5)
      write(6,9406) sepmin
9406  format(1x,'minimum separation for inserting an atom:',f10.5)
      sepmin = sepmin**2
      if (max(dellen(1),dellen(2),dellen(3)).le.0.0) then
         ifixvl = 1
       else
         ifixvl = 0
       endif
c
c  determine the number of He atoms (assumed at the end of the list)
c  and the index of the first He atom
c
      ntyp2 = 0
      ityp2 = natoms + 1
      do 4100 i = natoms,1,-1
      if (itype(i).eq.2) then
         ntyp2 = ntyp2 + 1
         ityp2 = i
       endif
4100  continue
      write(6,9101) ntyp2,ityp2
9101  format(1x,'initial number of He:',i5,/,
     1       ' starting at atom number:',i5)
      return
5000  continue
c
c  this section creates and destroys atoms in a specified region
c  as well as moving atoms and/or changing volume
c
      write(6,9501)
9501  format(1x,'type 1: move atom',/,' type 2: change V',/,
     1 ' type 3: detroy an atom',/,' type 4: create an atom')
      write(6,9502) fraccd
9502  format(1x,'fraction of jumps which create/destroy',g11.4)
      write(6,9503) delpos
9503  format(1x,'maximum displacement in a given direction',g11.4)
      write(6,9504) dellen
9504  format(1x,'maximum fractional change in a periodic length:',
     1  3g12.4)
      write(6,9505) xmin,xmax,ymin,ymax,zmin,zmax
9505  format(1x,'bounds for create',/,
     1  '   x:',2f10.5,/,
     1  '   y:',2f10.5,/,
     1  '   z:',2f10.5)
      write(6,9506) sepmin
9506  format(1x,'minimum separation for inserting an atom:',f10.5)
      sepmin = sepmin**2
      if (max(dellen(1),dellen(2),dellen(3)).le.0.0) then
         ifixvl = 1
       else
         ifixvl = 0
       endif
      return
      end
      subroutine rdjmp()
      include 'param.h'
      include 'implicit.h'
      common /jumpcomi/ ifixvl,ictype(natmax),jmpflg,nblck1(2),
     1                  nblck2(2),nfree(2),nchoice,ityp2,ntyp2,
     2                  imovbl(natmax),nmovbl
      common /jumpcomr/ prctst,delpos,dellen(3),delblk(3),fraccd,
     2                  sepmin,xmin,xmax,ymin,ymax,zmin,zmax,
     3                  xminc,xmaxc,yminc,ymaxc,zminc,zmaxc
      namelist /jumpcard/ prctst,delpos,dellen,xmin,xmax,ymin,ymax,
     1                    zmin,zmax,jmpflg,nblck1,nblck2,delblk,
     2                    fraccd,sepmin,xminc,xmaxc,yminc,ymaxc,
     3                    zminc,zmaxc
      prctst = 0.50
      delpos = 0.20
      dellen(1) = 0.0
      dellen(2) = -999.
      dellen(3) = -999.
      delblk(1) = 0.
      delblk(2) = -999.
      delblk(3) = -999.
      fraccd = 0.10
      xmax = 9999.
      ymax = 9999.
      zmax = 9999.
      xmin = -9999.
      ymin = -9999.
      zmin = -9999.
      xmaxc = 9999.
      ymaxc = 9999.
      zmaxc = 9999.
      xminc = -9999.
      yminc = -9999.
      zminc = -9999.
      jmpflg = 1
      read(5,jumpcard)
c      write(6,jumpcard)
c
      return
      end
c********************************************************************
c
c  this routine is called after each monte carlo step with the outcome of
c  the step in the logical variable accept.  This routine can be used to
c  update any internal data used by the getjmp and related routines.
c
c  for this application, advjmp is used only by jmpflg 4
c
      subroutine advjmp(accept,imoved,rvnew,itynew,nmoved,jmptyp)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      logical accept
      common /jumpcomi/ ifixvl,ictype(natmax),jmpflg,nblck1(2),
     1                  nblck2(2),nfree(2),nchoice,ityp2,ntyp2,
     2                  imovbl(natmax),nmovbl
      common /jumpcomr/ prctst,delpos,dellen(3),delblk(3),fraccd,
     2                  sepmin,xmin,xmax,ymin,ymax,zmin,zmax,
     3                  xminc,xmaxc,yminc,ymaxc,zminc,zmaxc
      dimension imoved(nmovmx),rvnew(3,nmovmx),itynew(nmovmx)
      goto (1000,2000,3000,4000) jmpflg
1000  return
2000  return
3000  return
4000  continue
      if (jmptyp.eq.4.and.accept) ntyp2 = ntyp2 + 1
      if (jmptyp.eq.5.and.accept) ntyp2 = ntyp2 - 1
      return
      end
c********************************************************************
c
c  this routine allows for the inclusion of any additional (non-EAM) energy
c  contributions.  It is called at each monte carlo step and the value of de
c  is added to the change in energy computed from the EAM before the decision
c  to accept or reject the move is made.
c
c  modde is not required in this application
c
      subroutine modde(de,imoved,rvnew,itynew,nmoved,jmptyp)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /jumpcomi/ ifixvl,ictype(natmax),jmpflg,nblck1(2),
     1                  nblck2(2),nfree(2),nchoice,ityp2,ntyp2,
     2                  imovbl(natmax),nmovbl
      common /jumpcomr/ prctst,delpos,dellen(3),delblk(3),fraccd,
     2                  sepmin,xmin,xmax,ymin,ymax,zmin,zmax,
     3                  xminc,xmaxc,yminc,ymaxc,zminc,zmaxc
      dimension imoved(nmovmx),rvnew(3,nmovmx),itynew(nmovmx)
      return
      end
c***************************************************************************
c
c  logical function decide determines whether to accept or reject
c  the mc step.  This routine is included with the user routines since
c  in the general case the probabilities to accept or reject depends on 
c  the algorithm for choosing the jumps
c
      function decide(de,dchmpot,dpv,prefac,tempin)
      include 'param.h'
      include 'implicit.h'
      logical accept,decide
      common /jumpcomi/ ifixvl,ictype(natmax),jmpflg,nblck1(2),
     1                  nblck2(2),nfree(2),nchoice,ityp2,ntyp2,
     2                  imovbl(natmax),nmovbl
      common /jumpcomr/ prctst,delpos,dellen(3),delblk(3),fraccd,
     2                  sepmin,xmin,xmax,ymin,ymax,zmin,zmax,
     3                  xminc,xmaxc,yminc,ymaxc,zminc,zmaxc
      data tmpmax/5000./
c
c  add the pv and dchmpot terms to the energy change
c
      detot = de - dchmpot + dpv
      tmp = min(tmpmax,-detot/tempin)
c
c  if jmpflg=4, then ignore the prefactor since the factors of N
c  are accounted for in the algorithm for choosing jump types
c
      if (jmpflg.ne.4) then
         tst = prefac*exp(tmp)
       else
         tst = exp(tmp)
       endif
      if (tst.ge.1.0) then
         accept = .true.
       else
         rnd = ranl()
         if (rnd.lt.tst) then
            accept = .true.
          else
            accept = .false.
          end if
       end if
      decide = accept
      return
      end
