      subroutine m01aaf(a,ii,jj,ip,ia,ifail)
c*****************************************************************
c
c  subroutine qsort is a quick sort algorithm designed to look
c  like the nag routine m01aaf
c
c  a is the input array to be sorted
c   (a is unchanged after the sort)
c  ii,jj are the bounds of the part of the array to be sorted
c  ip(i) = position of a(i) in the sorted list
c  ia(i) = index of the ith element in the sorted list
c    (i.e. the elements in order are a(ia(i))
c  ifail is a error message
c
c  the algorithm is taken from  Richard C. Singleton
c   Communications of the ACM, vol. 12 Number 3, March 1969, p. 185
c   (Algorithm 347)
c
      include 'implicit.h'
      dimension a(jj),ia(jj),ip(jj),iu(16),il(16)
      ifail = 0
      if (ii.gt.jj) ifail = 1
      if (ii.lt.1) ifail = 2
      if (jj.lt.1) ifail = 3
      if (ifail.ne.0) return
      do 2 i = ii,jj
2     ia(i) = i
      m = 1
      i = ii
      j = jj
5     if (i.ge.j) goto 70
10    k = i
      ij = (i+j)/2
      t = a(ij)
      it = ia(ij)
      if (a(i).le.t) goto 20
      a(ij) = a(i)
      a(i) = t
      t = a(ij)
      ia(ij) = ia(i)
      ia(i) = it
      it = ia(ij)
20    l = j
      if (a(j) .ge. t) goto 40
      a(ij) = a(j)
      a(j) = t
      t = a(ij)
      ia(ij) = ia(j)
      ia(j) = it
      it = ia(ij)
      if (a(i) .le. t) goto 40
      a(ij) = a(i)
      a(i) = t
      t = a(ij)
      ia(ij) = ia(i)
      ia(i) = it
      it = ia(ij)
      goto 40
30    a(l) = a(k)
      a(k) = tt
      ia(l) = ia(k)
      ia(k) = itt
40    l = l - 1
      if (a(l) .gt. t) goto 40
      tt = a(l)
      itt = ia(l)
50    k = k + 1
      if (a(k) .lt. t) goto 50
      if (k .le. l) goto 30
      if (l-i .le. j-k) goto 60
      il(m) = i
      iu(m) = l
      i = k
      m = m + 1
      goto 80
60    il(m) = k
      iu(m) = j
      j = l
      m = m + 1
      goto 80
70    m = m - 1
      if (m .eq. 0) goto 1000
      i = il(m)
      j = iu(m)
80    if (j-i .ge. ii) goto 10
      if (i .eq. ii) goto 5
      i = i - 1
90    i = i + 1
      if (i .eq. j) goto 70
      t = a(i+1)
      it = ia(i+1)
      if (a(i) .le. t) goto 90
      k = i
100   a(k+1) = a(k)
      ia(k+1) = ia(k)
      k = k - 1
      if (t .lt. a(k)) goto 100
      a(k+1) = t
      ia(k+1) = it
      goto 90
1000  continue
      do 1100 i = ii,jj
1100  ip(ia(i)) = i
c
c  now return the data to the original order
c
      do 2000 k = ii,jj
      if (ia(k).lt.0) goto 2000
      k1 = k
      ik1 = ia(k1)
      temp = a(k1)
2100  continue
      ia(k1) = -ia(k1)
      store = a(ik1)
      a(ik1) = temp
      temp = store
      k1 = ik1
      ik1 = ia(k1)
      if (ik1.gt.0) goto 2100
2000  continue
      do 2200 k = ii,jj
2200  ia(k) = -ia(k)
      return
      end
      subroutine ltimdat(string,n)
c**************************************************************************
c
c  this routine prints the time of day, date
c
c*************************************************************************
      include 'implicit.h'
      character*80 string
      character*24 ctime
      integer*4 time
      write(6,*)string(1:n)
      write(6,9001) ctime(time())
9001  format(2x,a24,/)
      return
      end
c**************************************************************************
c
c  returns the total time left on the time limit for the job
c
c**************************************************************************
      subroutine trmain(time)
      include 'implicit.h'
      time=1.e6
      return
      end
c***********************************************************************
c
c  vector manipulation routines
c
      function sdot(n,x,incx,y,incy)
      include 'implicit.h'
      dimension x(1),y(1)
      tot = 0.0
      do 100 i = 1,n
      ix = 1 + (i-1)*incx
      iy = 1 + (i-1)*incy
      tot = tot + x(ix)*y(iy)
100   continue
      sdot = tot
      return
      end
      subroutine acopy(n,x,incx,y,incy)
      include 'implicit.h'
      dimension x(n),y(n)
      do 100 i = 1,n
      ix = 1 + (i-1)*incx
      iy = 1 + (i-1)*incy
      y(iy) = x(ix)
100   continue
      return
      end
      subroutine saxpy(n,a,x,incx,y,incy)
      include 'implicit.h'
      dimension x(n),y(n)
      do 100 i = 1,n
      ix = 1 + (i-1)*incx
      iy = 1 + (i-1)*incy
      y(iy) = a*x(ix) + y(iy)
100   continue
      return
      end
      function anrm2(n,x,incx)
      include 'implicit.h'
      dimension x(n)
      tot = 0.0
      do 100 i = 1,n
      ix = 1 + (i-1)*incx
      tot = tot + x(ix)**2
100   continue
      anrm2 = sqrt(tot)
      return
      end
      subroutine cross(z,x,y)
      include 'implicit.h'
      dimension z(3),x(3),y(3)
      z(1) = x(2)*y(3) - x(3)*y(2)
      z(2) = x(3)*y(1) - x(1)*y(3)
      z(3) = x(1)*y(2) - x(2)*y(1)
      return
      end
c**********************************************************************
c
c  timing routines
c
      subroutine initsec()
      include 'implicit.h'
      real*4 tarray(2),start,etime
      common /seccom/ start
      start = etime(tarray)
      return
      end
      function seconds()
      include 'implicit.h'
      real*4 tarray(2),start,etime
      common /seccom/ start
      t = etime(tarray) - start
      seconds = t
      return
      end
c
      subroutine mytime(timestr)
      character*24 timestr,ctime
      integer*4 time
      timestr = ctime(time())
      return
      end
c
c***********************************************************************
c
c  random number functions
c
c**********************************************************************
      subroutine lranst(iseed)
      include 'implicit.h'
      real*4 rand
      integer*4 time
      if (iseed.le.0) then
         x = rand(time())
      else
         x = rand(iseed)
      endif
      return
      end
      function ranl()
      include 'implicit.h'
      real*4 rand
      ranl = rand(0)
      return
      end
      function rgauss()
      include 'implicit.h'
      data twopi/6.283185308/
   10 continue
      a1 = ranl()
      if (a1.le.0.) goto 10
      a2 = ranl()
      rgauss = sqrt(-2.*log(a1))*cos(twopi*a2)
      return
      end
