#include "PairAction.h"
#include "jastrow.h"
#include "chain.h"




scalar TotalAction (chain polymer, PairAction Paction, jastrow WF)
{
  static int count = 0;
  scalar TotAction = 0.0;
  scalar Uaction = 0.0;
  scalar Uprimitive = 0.0;
  scalar Taction = 0.0;
  scalar Naction = 0.0;
  scalar WFaction = 0.0;
  int NumLinks = polymer.NumBeads - 1;

  count++;
  for (int link=0; link < NumLinks; link++)
    {
      // DEBUG: using primitive action for now...
      Uaction += Paction.PotentialLinkAction(polymer[link],
					     polymer[link+1]);
      Uprimitive += Paction.PrimitivePotentialLinkAction(polymer[link],
							 polymer[link+1]);
      Taction += Paction.KineticLinkAction(polymer[link],
					   polymer[link+1]);
      Naction += WF.NodalLinkAction(polymer[link],
				    polymer[link+1],
				    Paction.tau);
      
    }
  
  WFaction= - (log(fabs(WF.value(polymer.beads[0])))
    + log(fabs(WF.value(polymer[polymer.NumBeads - 1]))));

  // DEBUG
  if ((count % 1000) == 999)
    printf ("\nUaction: %1.5f Uprimitive: %1.5f Taction: %1.5f Naction: %1.5e WFaction: %1.5f.\n"
	    ,Uaction, Uprimitive, Taction, Naction, WFaction);


  TotAction = Uaction + Taction + Naction + WFaction;
  
  return (TotAction);
}


chain DisplaceMove (chain polymer, scalar delta)
{
  chain newpoly;

  newpoly.init(polymer.NumBeads, polymer.NumElecs);

  for (int bead=0; bead<polymer.NumBeads; bead++)
    for (int elec=0; elec<polymer.NumElecs; elec++)
      for (int comp=0; comp < 3; comp++)
	newpoly[bead][elec][comp] = polymer[bead][elec][comp]
	  + delta * (drand48() - 0.5);
  return (newpoly);
}






inline scalar min (scalar a, scalar b)
{
  if (a<b) return (a);  else return(b);
}


// Function sample is presently the simplest possible Metropolis
// sampling of the polymer chain action.  Currently, it only uses
// displace-type moves in which each bead is moved by a random amount
// in a random directly.  It moves through phase space VERY SLOWLY.
void sample (chain &poly, PairAction Paction, jastrow WF, int
	     NumSamples, scalar delta, char *OutFileName)
{
  FILE *fout;

  if((fout = fopen(OutFileName, "w")) == NULL)
    die ("Cannot write output file %s in sample.\n", OutFileName);
  
  chain  CurrentChain,  TrialChain;
  scalar CurrentAction, TrialAction;  
  Vector<scalar> CurrentLocalE(2), CurrentLocalEsq(2);
  Vector<scalar> SumLocalE(2), SumLocalEsq(2);
  int NumAccepted = 0;

  CurrentChain.init(poly.NumBeads, poly.NumElecs);
  CurrentChain = poly;
  TrialChain.init(poly.NumBeads, poly.NumElecs);

  CurrentAction = TotalAction (CurrentChain, Paction, WF);
  CurrentLocalE[0] = WF.LocalEnergy(CurrentChain[0]);
  CurrentLocalE[1]=WF.LocalEnergy(CurrentChain[CurrentChain.NumBeads-1]);


  SumLocalE[0] = SumLocalE[1] = 0.0;
  SumLocalEsq[1] = SumLocalEsq[1] = 0.0;

  for (int SampleNum=0; SampleNum<NumSamples; SampleNum++)
    {
      TrialChain = DisplaceMove (CurrentChain, delta);
      
      TrialAction = TotalAction (TrialChain, Paction, WF);
      

      scalar DeltaAction = TrialAction - CurrentAction;
      
	  
      if (DeltaAction < - log (drand48())) // Then accept
	{
	  CurrentChain = TrialChain;
	  CurrentAction = TrialAction;
	  CurrentLocalE[0] = WF.LocalEnergy(CurrentChain[0]);
	  CurrentLocalE[1]=WF.LocalEnergy(CurrentChain
					  [CurrentChain.NumBeads-1]);
	  NumAccepted++;
	}
      SumLocalE[0] += CurrentLocalE[0];
      SumLocalEsq[0] += CurrentLocalE[0] * CurrentLocalE[0];
      SumLocalE[1] += CurrentLocalE[1];
      SumLocalEsq[1] += CurrentLocalE[1] * CurrentLocalE[1];
      
      if ((SampleNum % 1000)== 0)
	{
	  printf ("Trial Action = %1.10f.\n", TrialAction);
	  printf ("DeltaAction = %1.8e\n", DeltaAction);
	  printf ("Sample = %d.\n", SampleNum);
	  printf ("E1avg = %13.10f  E2avg = %13.10f  Acc. Ratio = %1.6f\n",
		  SumLocalE[0] / (SampleNum+1),
		  SumLocalE[1] / (SampleNum+1),
		  (double) NumAccepted / (SampleNum+1));
	  fprintf (fout, "%d %1.14f %1.14f %1.14f %1.14f\n", SampleNum,
		   SumLocalE[0] /(SampleNum+1),
		   SumLocalE[1] /(SampleNum+1),
		   SumLocalEsq[0] /(SampleNum+1),
		   SumLocalEsq[1] /(SampleNum+1));
	  fflush (fout);
	}
     
    }
  poly = CurrentChain;
}


void initchain (chain &poly, PairAction Paction)
{
  const scalar epsilon = 0.04;
  
  for (int bead=0; bead < poly.NumBeads; bead++)
    for (int elec=0; elec < poly.NumElecs; elec++)
      for (int comp=0; comp < 3; comp++)
	{
	  poly.beads[bead][elec][comp] = Paction.Rions
	    [(elec % Paction.NumIons)][comp] + epsilon * (drand48() -
							  0.5);
	  if ((comp == 0) && (elec > 0))
	    if (poly.beads[bead][elec-1][comp] <
		poly.beads[bead][elec][comp])
	      poly.beads[bead][elec][comp] =
		2.0 * poly.beads[bead][elec-1][comp] -
		poly.beads[bead][elec][comp];
	}
		  
	  
}

main()
{
  PairAction MyAction;
  chain MyChain;
  jastrow WF;

  srand48(234234240);
  
  MyChain.init(5, 3);

  MyAction.read("H3I.act");
  
  
  // MyChain[0].print();
  // MyChain[1].print();
  // MyChain[2].print();
  // MyChain[3].print();
  // MyChain[4].print();
  
  WF.read("H3I.dat");

  initchain (MyChain, MyAction);
 
  //  while (TotalAction (MyChain, MyAction, WF) > 10000.0) 
  //  sample (MyChain, MyAction, WF, 1000, 1e-1);

  sample (MyChain, MyAction, WF, 10000000, 0.08, "S5tau.025.dat");
}








