#include "tnt.h"
#include "vec.h"

namespace TNT
{
  template <class T>
    T abs(Vector<T> A);
  
  template <class T>
    Vector<T> operator*(T c, const Vector<T> &A);
  template <class T>
    Vector<T> operator*(const Vector<T> &A, T c);

}



namespace TNT
{
  
  class Nvector
  {
  public:
    int nvecs;
    int vecsize;
    Vector< Vector<scalar> > data;
    
    void init(int numvecs, int length);
    Nvector();
    Nvector(int numvecs, int length);
    void freemem();
    //    void ~Nvector();

    inline Vector<scalar> & operator()(int i)
      {
	return (data[i-1]);
      }
    inline scalar & operator()(int i, int j)
      {
	return (data[i-1][j-1]);
      }
    inline Vector<scalar> & operator[](int i)
      {
	return (data[i]);
      }
    void print();
  };
  

  Nvector multiply (Nvector &A, Nvector &B);
  
  inline Nvector operator* (Nvector &A, Nvector &B)
    {
      return(multiply(A,B));
    }
  
 
}








