#include "jastrow.h"
#include <math.h>

namespace TNT
{
  template <class T>
    T abs(Vector<T> A)
    {
      return (sqrt(dot_prod(A,A)));
    }
  
  
  template <class T>
    Vector<T> operator*(T c, const Vector<T> &A)
    {
        Subscript N = A.dim();
	
        Vector<T> tmp(N);
        Subscript i;
	
        for (i=0; i<N; i++)
	  tmp[i] = c * A[i];
	
        return tmp;
    }
  
  template <class T>
    Vector<T> operator*(const Vector<T> &A, T c)
    {
      return(c * A);
    }
  
}


scalar junk (Vector<scalar> sh)
{
  Vector<scalar> temp;
  scalar x = 3.0;

  temp = 3.0 * temp;
  temp = temp * 3.0;
  
  return (abs(sh));
}


