// ex01.cc : demonstate matrix/vector declarations, and element access.

#include <iostream>
#include "tnt.h"
#include "vecadaptor.h"

/* ANSI C++ valarray class */
#include <valarray>      

using namespace std;

typedef TNT::Vector_Adaptor< valarray<double> >   Vec;

int main()
{
    const int N=6;
    Vec x(N, "1.0 2.0 3.0 4.0 5.0 6.0");
    Vec y(N, 1.0);

    Vec z(0);

    cout << x << "\n";
    cout << y << "\n";

    
    TNT::Index1D I(2,4);

    // illustrate Fortran-like 1-based indexing

    x(2) = 1.1;
    y(3) = 3.2;

    x(I) = y(I+1);


    cout << "x: " << x << "\n";
    cout << "y: " << y << "\n";

    // illustrate operartions only meaningful on valarray<>
    // by operating directly on the adapted container

    x.getVector() *= 2.0;       // double each element
    cout << "x: " << x << "\n";

    Vec c(x.getVector().cshift(-3));   // circular shift 3 times to the left
    cout << "c (x << 3): " << c << "\n";

	return 0;
}

