#include "jastrow.h"
#include <iostream.h>

inline scalar sqr(scalar x) {return (x*x);}
inline scalar minval(scalar a, scalar b)
{
  if (a<b) return(a);
  else return(b);
}

scalar VariationalMC (jastrow wf, char *outfname, int NumSamples)
{
  scalar TotalE = 0.0;
  int Samples = 0;
  int NumElecs = wf.NumUpElecs + wf.NumDownElecs;  
  scalar currentnorm, trynorm;
  scalar currentE, tryE;
  Nvector tryR (NumElecs,3), currentR(NumElecs,3);
  int numaccepted = 0;
  FILE *fout;

  if ((fout = fopen(outfname, "w")) == NULL)
    die("Can't open file for output.\n");
  
  const scalar delta = 0.7;


  srand48((long) 92038442);  
  for (int m=0; m<NumElecs; m++)
    for (int comp=0; comp < 3; comp++)
      currentR[m][comp] = -3.0 + 6.0 * drand48();

  currentnorm = sqr(wf.value(currentR));  
  currentE = wf.LocalEnergy(currentR);



  while (Samples < NumSamples)
    {
      for (int m=0; m<NumElecs; m++)
	for (int comp=0; comp < 3; comp++)
	  {
	    tryR = currentR;
	    tryR[m][comp] += delta * (-1.0 + 2.0 * drand48());
	    trynorm = sqr(wf.value(tryR));
	    scalar accprob = minval(trynorm/currentnorm, (scalar) 1.0);
	    if (accprob >= drand48())
	      {
		numaccepted++;
		currentR = tryR;
		currentE = wf.LocalEnergy(currentR);
		currentnorm = trynorm;
	      }
	    TotalE += currentE;
	    fprintf(fout, "%1.18f\n", currentE); 
	    Samples++;
	    if ((Samples%100) == 0)
	      {
		printf ("Average Energy = %1.8f\n", TotalE / Samples);
		printf ("Acceptance Ratio = %1.8f\n", 
			(scalar) numaccepted / Samples);
		// fprintf (fout, "%1.18f %1.18f\n", TotalE / Samples, 
		//	 (scalar) numaccepted / Samples);
		// fflush(fout);
	      }
	  }
    }
  printf ("Average Energy = %1.8f\n", TotalE / Samples);
  printf ("Acceptance Ratio = %1.8f\n", (scalar) numaccepted / Samples);
  fclose (fout);
}


scalar VariationalMC2 (jastrow wf, char *outfname, int NumSamples)
{
  scalar TotalE = 0.0;
  int Samples = 0;
  int NumElecs = wf.NumUpElecs + wf.NumDownElecs;  
  scalar currentnorm, trynorm;
  scalar currentE, tryE;
  Nvector tryR (NumElecs,3), currentR(NumElecs,3);
  scalar numaccepted = 0.0;
  FILE *fout;

  if ((fout = fopen(outfname, "w")) == NULL)
    die("Can't open file for output.\n");
  
  const scalar delta = 1.2;
  const int EqbrmPeriod = 50000;


  srand48((long) 92038442);  
  for (int m=0; m<NumElecs; m++)
    for (int comp=0; comp < 3; comp++)
      currentR[m][comp] = -3.0 + 6.0 * drand48();

  currentnorm = sqr(wf.value(currentR));  
  currentE = wf.LocalEnergy(currentR);



  while (Samples < NumSamples)
    {
      for (int m=0; m<NumElecs; m++)
	{
	  tryR = currentR;	  
	  for (int comp=0; comp < 3; comp++)
	    tryR[m][comp] += delta * (-1.0 + 2.0 *drand48());
	  trynorm = sqr (wf.value(tryR));
	  scalar accprob = minval((trynorm/currentnorm), (scalar) 1.0);
	   
	  if (accprob > drand48())
	    {
	      currentR = tryR;
	      currentnorm = trynorm;
	      numaccepted += 1.0 / NumElecs;	      
	    }
	}
      Samples++;
      currentE = wf.LocalEnergy(currentR);
      fprintf(fout, "%1.18f\n", currentE); 
      
      
      if (Samples >= EqbrmPeriod)
	TotalE += currentE;
      if (((Samples%100) == 0) && (Samples >= EqbrmPeriod))
	{
	  printf ("Average Energy = %1.8f\n",
		  TotalE / (Samples - EqbrmPeriod + 1));
	  printf ("Acceptance Ratio = %1.8f\n", 
		  (scalar) numaccepted / Samples);
	  //fprintf (fout, "%1.18f %1.18f\n", TotalE / (Samples-EqbrmPeriod+1), 
	  //		   (scalar) numaccepted / Samples);
	  //fflush(fout);
	}
    }
  
  printf ("Average Energy = %1.8f\n", TotalE/(Samples - EqbrmPeriod+1));
  printf ("Acceptance Ratio = %1.8f\n", (scalar) numaccepted / Samples);
  fclose (fout);
}

		


main()
{
  jastrow mywf;
  char wfname[200];
  char outfile[200];
  int numsamples;
  
//    mywf.NumUpElecs = 2;
//    mywf.NumDownElecs = 1;
  


//    mywf.NumIons = 3;
//    mywf.Rions.init(3,3);
//    mywf.Rions[0][0] = -1.757;
//    mywf.Rions[0][1] = 0.0;
//    mywf.Rions[0][2] = 0.0;
//    mywf.Rions[1][0] = 0.0;
//    mywf.Rions[1][1] = 0.0;
//    mywf.Rions[1][2] = 0.0;
//    mywf.Rions[2][0] = 1.757;
//    mywf.Rions[2][1] = 0.0;
//    mywf.Rions[2][2] = 0.0;

//    mywf.Zions.newsize(3);
//    mywf.Zions[0] = 1.0;
//    mywf.Zions[1] = 1.0;
//    mywf.Zions[2] = 1.0;
  

//    mywf.Betanu = 10.12;
  
//    mywf.Ck.init(3,3);
//    mywf.Ck[0][0] = 2.03;
//    mywf.Ck[0][1] = 0.0;  
//    mywf.Ck[0][2] = 0.0;
//    mywf.Ck[1][0] = -2.03;
//    mywf.Ck[1][1] = 0.0;
//    mywf.Ck[1][2] = 0.0;
//    mywf.Ck[2][0] = 0.0;
//    mywf.Ck[2][1] = 0.0;
//    mywf.Ck[2][2] = 0.0;

//    mywf.wk.newsize(3);
//    mywf.wk[0] = 2.91;
//    mywf.wk[1] = 2.91;
//    mywf.wk[2] = 3.18;
  
//    mywf.nuk.newsize(3);
//    mywf.nuk[0]=0.0;
//    mywf.nuk[1]=0.0;
//    mywf.nuk[2]=0.0;

  printf ("Enter the name of the Jastow WF filename:  ");
  fgets(wfname, 200, stdin);
  for (int i=0; i<200; i++)
    if (wfname[i] == '\n')
      wfname[i] = '\0';

  printf ("Enter name of the output file:  ");
  fgets (outfile, 200, stdin);
  for (int i=0; i<200; i++)
    if (outfile[i] == '\n')
      outfile[i] = '\0';
  printf ("Enter number of samples:  ");



  cin >> numsamples;

  printf ("wfname = %s\n", wfname);

  mywf.read(wfname);
  
  VariationalMC2 (mywf, outfile, numsamples);

}



