#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#define DEBUG 1
#define PI 3.14159265358979323846E0
#define MAX_N 1000
#define KMAX 20
#define FILE_ERR 201
#define INPUT_ERR 202
#define ALLOC_ERR 203
#define INIT_ERR 204
#define NO_ERR 0

#define FILE_OPEN_ERR(a) printf("Cannot open the file: %s\t\tExiting.\n",a);exit(FILE_ERR)
#define INPUT_ERROR(a) printf("Cannot read the %s from the input file.\tExiting.\n",a);exit(INPUT_ERR)
#define ALLOC_ERROR(a) printf("Cannot allocate memory for the %s.\tExiting.\n",a);exit(ALLOC_ERR)
#define MIN(a,b) (a<b?a:b)
#define MAX(a,b) (a>b?a:b)


typedef struct vector3d
{
    double x;
    double y;
    double z;
}  Vector3D_t;

typedef struct averaged_vector
{
    double x;
    double y;
    double z;
    int    n;
}  Vector_Avg_t;

typedef struct averaged_scalar
{
    double val;
    int n;
}  Scalar_Avg_t;

typedef struct atom3d
{
  Vector3D_t U;
  Vector3D_t R;
  Vector3D_t v;
  Vector3D_t a;
  Vector3D_t b;
  Vector3D_t c;
  Vector3D_t F;
  double sigma;
  double mass;
}  Atom3D_t;

/*  Functions in calc.c */
void Calc_Vz(double,double,int,Atom3D_t*,Scalar_Avg_t*,double,int);
void Calc_Sk(double,double,Scalar_Avg_t*,int,double,int,Atom3D_t*);
void Calc_Rho(Atom3D_t*,double*,int,int,double,double,double); 
void Calc_Vac(Vector3D_t**,double*,int,int,int,int);

/* Functions in force.c */
double Wall_Perturb(double,double,double,double,double,double,double);
double Wall_Force(double,double,double,double,double,double,double,double,double,double,double,double,double);
double dFdx(double,double,double,double,double,double,double);
double dFdy(double,double,double,double,double,double,double);
void Calc_Forces(Atom3D_t*,double,double,double,double,double,double,int,double,double,double);

/* Functions in init.c */
int Initialize_Program(int*,double,double,double,double,Atom3D_t**,Scalar_Avg_t**,double**,Scalar_Avg_t**,Vector3D_t***,double**,int,int,double,int*, Vector3D_t**, int);
void normalvar(double*,double*);
void* matrix_alloc(int,int,size_t,size_t);
void Cleanup(Atom3D_t*, Scalar_Avg_t*,double*,Scalar_Avg_t*,Vector3D_t**,double*,int);
void Initialize_System(double,double,double,double,double,int,double,Atom3D_t*);

/* Functions in io.c */
int Read_Input(char*,double*,double*,double*,double*,double*,double*,double*,double*,double*,double*,double*,double*,int*,int*,int*);
int Write_Continue(Atom3D_t*,int,char*,Vector3D_t**,int,int);
int Read_Continue(Atom3D_t*,int,char*,Vector3D_t**,int*,int*);
int Write_Output(Scalar_Avg_t*,double*,Scalar_Avg_t*,int,int,int,double,double,int,char*);
int Write_Energy(Vector3D_t*, int,char*);

/* Functions in MD.c */
void usage(char*);
void Predict_System(Atom3D_t*,double,int,double,double,double);
Vector3D_t Correct_System(Atom3D_t*,double,int,double,double,double);

/* Functions in string.c */
void itoa(int,char*);
void reverse(char*);
char* strpaste(char*,char*);





















