#include "md.h"

/*  String manipulation functions. */
void reverse(char s[])
{
  int c, i, j;
  for (i=0, j=strlen(s)-1;i<j;i++,j--){
    c=s[i];
    s[i]=s[j];
    s[j]=c;
  }
}

void itoa(int n, char* s)
{
  int i, sign;
  if ((sign=n)<0)
    n=-n;
  i=0;
  do {
    s[i++]=n%10+'0';
  } while ((n /=10)>0);
  if (sign<0)
    s[i++]='-';
  s[i]='\0';
  reverse(s);
}

char* strpaste(char* front, char* rear)
{
  int i, j;
  char* filename;

  if((filename=(char *)malloc((FILENAME_MAX*sizeof(char))))==NULL)
    {
      printf("Could not allocate space for output filename.\n");
      exit(0);
    }

  i=j=0;
  
  while ((front[i]!='\0')&&((i+j-2)<=FILENAME_MAX))
    {
      filename[i+j]=front[i];
      i++;
    }
  filename[i+j]='.';
  i++;
  while ((rear[j]!='\0')&&((i+j-2)<=FILENAME_MAX))
    {
      filename[i+j]=rear[j];
      j++;
    }
  filename[i+j]='\0';
  return(filename);
}
