/*Created by Yan Li, 2002.12  Copy right reserved.*/

/*  This program calculates:
 (1) fractal dimension of bacterial colonies 
  by  the mass distribution relations:  N(R)~const*R^d   ;  N is the number of
  lattices occupied by walkers enclosed by a circle of radius R and d is the 
fractal dimension. 
   
 (2) Angular fourier transform of mass distribution at different radius range

input files:
   X1  Y1 energy1
   X2  Y2 energy2
.....
  

output files:

dim1.dat,dim2.dat: fractal dimension data(log-log)

polar_dis.dat: Mass distribution (angular) with overlapping (theta, r, mass)
polar_fft.dat: Fourier transform of angular mass distribution (omega, r,mass
*/

#include "parameter.h"

main()
{  
 float dim1,dim2; 
 void ini();                                  /*Initialize walker positions*/
 float fdim_mass(),fdim_box(); /*Mass distribution calculation*/
 float fit();                                /*Least square fitting*/      


 /*Initialize the bin and grid for dimension calculation*/
 ini();

 /*Mass distribution method, with overlapping*/
 dim1=fdim_mass();

 /*Box counting method*/
 dim2=fdim_box(); 
 printf("__________________________________________________________\n");
 printf("The fractal dimension by two methods are respectively:\n");
 printf("dim1=%.5f,  dim2=%.5f\n\n",dim1,dim2);   
 polar();
  
}




/*Read in the Walker_Position_File and assign the walkers to bins and grids */
 void ini()
{FILE *fp;
 char fwp[15];
 int i,j,ix,iy,index,Nw;
 float Rmax,Rav,Rav2,Rw,Rw2;

 printf("\n\nEnter the filename of the Walker Position:\n"); 
 scanf("%s",fwp);
 if((fp=fopen(fwp,"r"))==NULL)
   {printf("Cannot open input file\n");
   exit(0);};


 for(i=0;i<SIZE*sub;i++)
   for(j=0;j<SIZE*sub;j++)Grid[i][j]=EMPTY;
     
 Nw=0;
 Rav2=0.0;Rmax=0.0;
 while(!feof(fp))
   {fscanf(fp,"%f %f %f",&w.x,&w.y,&w.e);
   Rw2=(w.x-x00)*(w.x-x00)+(w.y-y00)*(w.y-y00); 
   Rav2+=Rw2;
   Rw=sqrt(Rw2);
   if(Rw>Rmax) Rmax=Rw;
   ix=floor(w.x*sub+.5);iy=floor(w.y*sub+.5);
   Grid[ix][iy]=OCCUPY;              /*label occupied lattice on the grid*/
   Nw++; 
   }
 
 Nw--;
 Rav2/=Nw;
 Rav=sqrt(Rav2);
 printf("_____________________________________________________");
 printf("\n1. Information about the walkers:\n");
 printf("Size of the simulation box R0=%d\n",x00);
 printf("Total number of walkers     Nw= %d\n",Nw);
 printf("Squared average Rav= %.3f, Rmax=%.3f \n\n",Rav,Rmax);
 fclose(fp);

 Rcut0=floor(Rav);
 Rmax0=floor(Rmax);

}



float fit(B,L,fpdis)
     int B[][2],L;
     FILE *fpdis;
{int i,i0,n;
 float x,y,sx,sy,sxx,sxy,a,b,div;
 FILE *fp1;

 i0=0;n=0;
 while(B[i0][2]==EMPTY)i0++;
 x=sx=y=sy=sxx=sxy=0;
 printf("First occupied bin r<%d\n",i0);

for(i=i0;i<L;i++)
  { 
    x=log(B[i][1]);
    y=log(B[i][2]);
    sx+=x;
    sy+=y;
    sxx+=x*x;
    sxy+=x*y;
    n++;
   fprintf(fpdis,"%.5f %.5f\n",x,y);
   };
 div=n*sxx-sx*sx;
 a=(sy*sxx-sx*sxy)/div;
 b=(n*sxy-sx*sy)/div;

 printf("log(y)=%.5f+(%.5f)*log(x)\n\n",a,b); 
 return(b);
}


float fdim_mass()
{float dim1;
 int index,Rc2,Rg,R2,i,j,BinGrid[50][2];
 FILE *fp;

 if((fp=fopen("dim1.dat","wb"))==NULL)
   {printf("Cannot open file\n");
    exit(0);}
 
 Rg=Rcut0*sub;Rc2=Rg*Rg;
 for(i=0;i<Rg;i++)
   {BinGrid[i][2]=EMPTY;
   BinGrid[i][1]=2<<i;
   }

 for(i=-Rg;i<Rg;i++)
   for(j=-Rg;j<Rg;j++)
     if (Grid[i+x00*sub][j+y00*sub]==OCCUPY)
       {R2=i*i+j*j;
       if(R2<Rc2)
         {index=floor(log(sqrt(R2))/log(2));
	 if(index<0)index=0;
          BinGrid[index][2]++;
	 }       
        }
 printf("_____________________________________________");
 printf("\n2.1 Mass Distrubtion Method, with overlapping:\n");

 index=floor(log(Rg)/log(2));
 dim1=fit(BinGrid[1],index-1,fp); fclose(fp);
 return(dim1);
}

float fdim_box()
{int step,m,i,j,i0,j0,dL,BinBox[20][2];
 int Rg;
 float dim2;
 FILE *fp;
 
 if((fp=fopen("dim2.dat","wb"))==NULL)
   {printf("Cannot open file\n");
    exit(0);}
 
 Rg=Rmax0*sub;
 m=floor(log(Rg)/log(2));
 Rg=1<<m;step=Rg;

 for(dL=2;dL<=m+1;dL++)
   {step>>=1; 
   BinBox[dL-2][1]=step;BinBox[dL-2][2]=0;
   for(i0=-Rg;i0<Rg;i0+=step)
     for(j0=-Rg;j0<Rg;j0+=step)
       for(j=j0;j<j0+step;j++)    
	 for(i=i0;i<i0+step;i++)
	   {if (Grid[i+x00*sub][j+y00*sub]==OCCUPY)
	     {BinBox[dL-2][2]++;
	     i=i0+step;j=j0+step;
	     }
	   }
   }
 printf("_____________________________________________");
 printf("\n2.2 Box Counting Method:\n");
 dim2=-fit(BinBox,m,fp);fclose(fp);
 return(dim2);

}


















