/*
 *  ADI_Solver.h
 *  Active Walkers
 *
 *  Created by Shane Stafford on Tue Nov 26 2002.
 *  Copyright (c) 2002. All rights reserved.
 *
 *  Description:  Implementation of the Alternating Direction Implicit (ADI) solver
 *                for 2-D parabolic PDE's with zero derivative (no flux) boundary
 *                conditions and square grids (dX = dY).
 */

#ifndef _ADI_Solver_H
#define _ADI_Solver_H

#include "array2d.h"

void SolvePDE(  array2d< double >& T, 	//initialized dependent variable 2-D matrix
                double lambda, 		//lambda = k * dT/ (dX)^2 where dX = dY
                int size,		//NxN matrix, size = N
                int steps );		//iterations

#endif


