/*
 *  ThomasAlg.h
 *  Diffusion
 *
 *  Created by Shane Stafford on Tue Nov 19 2002.
 *  Copyright (c) 2002. All rights reserved.
 * 
 *  Description:  Solves tridiagonal matrices using the Thomas algorithm
 *                r = right hand side matrix
 *                efg = compressed tridiagonal (3 elements per row)
 *                x is filled with result
 */

#ifndef _ThomasAlg_H
#define _ThomasAlg_H

#include "array2d.h"

void tridiagSolve(array2d< double >& efg, double *r, double *x, int begin, int end);

#endif
