      subroutine binfi(x,grad,label,vtotal,ibin,ipoint)
c clamps programmed by d. ceperley at nrcc, 1978.
c binvi computes the potential energy of particle label at positon x
c  the binlist in icc(lbin+..) and linked list in icc(linkps+..)
c   give all of the particles in any bin
c  on return binvi sets ibin=address in cache of the bin for postion x
c  and sets ipoint to the particle which points to label
      implicit real*8(a-h,o-z)
      include 'syspec.cm'
      include 'blank.cm'
      include 'cbins.cm'
      real*8 grad(3),dx(3),x(3)

      ibin=1 ! compute bin of position x
      do l=1,ndim
        j=mvects(l)*int(rbsize(l)*(x(l)+el2(l)))
        ibin=ibin+j
      enddo
      if(ibin.le.0.or.ibin.gt.nbins) print*,'ibin',ibin,nbins
      if(ibin.le.0.or.ibin.gt.nbins) go to 200
c inn is zero word of nearest neighbor list for ibin
      ibin=ibin+lbin
      ki=ntypes*(icc(ltype+label)-1)
      ipoint=0

c find potential energy within ibin
      jold=0
      j=icc(ibin)
      if(j.le.0) go to 6
2     if(j.eq.label) go to 3
      k=icc(ltype+j)+ki
      indj=ndim*(j-1)+lxold
      r2=0.d0
      do 4 l=1,ndim
      indj=indj+1
      r=x(l)-cc(indj)
      dx(l)=r
4     r2=r2+r*r
      lc=int(cc(lcsi+k)*r2)
      if(lc.lt.lenpot-1) then
        include 'cal_f.h'
      do  l=1,ndim
         grad(l)=grad(l)+ff*dx(l)
      enddo
      endif

      jold=j
5     j=icc(linkps+j)
      if(j) 200,6,2
3     ipoint=jold
      go to 5
c now loop over all neighboring bins
6     continue
       inn=lnnlst+nborsu*(ibin-1-lbin)
      do 10 j1=1,nbors
      inn=inn+1
      jbin=icc(inn)
      if(jbin.gt.nbins.or.jbin.le.0) print*,'jbin',jbin,nbins
      if(jbin.gt.nbins.or.jbin.le.0) go to 200 ! for debugging purposes

      j=icc(jbin+lbin)
12    if(j.le.0) go to 110 ! check for empty neighboring bin
      if(j.ne.label) then
      k=ki+icc(ltype+j)
      indj=ndim*(j-1)+lxold
      r2=0.d0
      do l=1,ndim
        indj=indj+1
        r=x(l)-cc(indj)
c fast periodic boundary conditions for cdc
        include 'pbc.h'
        dx(l)=r
        r2=r2+r*r
      enddo
      lc=cc(lcsi+k)*r2
      if(lc.lt.lenpot-1) then
        include 'cal_f.h'
        do l=1,ndim
         grad(l)=grad(l)+ff*dx(l)
        enddo
      endif
      endif
       j=icc(linkps+j) ! consider next particle in jbin
      go to 12
110    continue
10    continue
      return

200   write (6,201) label,ibin,(x(l),l=1,ndim)
201   format('  trouble in binfi ',2i20,3e12.4)
      call ldump
      return
      end
