      subroutine binlst(cut,ifpch)
c clamps programmed by d. ceperley at nrcc, 1978.
      implicit real*8(a-h,o-z)
      include 'cbins.cm'
      include 'syspec.cm'
      include 'blank.cm'
      integer icount(3),nd2(3),ic2(3)
      real*8 bsize(3)
c
c binlst intializes the binsorting package
c binlst locates all bins within cut of a central bin and stores the
c   integer vector displacements in icc(lvcbin+...)
c it also reserves cache for the bin lst and linked lst
      cut2=cut**2
      nbins=1
      do l=1,ndim
        if(ndiv(l).le.0.and.l.gt.1) ndiv(l)=ndiv(l-1)
        ndiv(l)=max(ndiv(l),2)
c we need ndiv.ge.2 becuase pbc are not applied between atoms in the same bin
        mvects(l)=nbins
        nd2(l)=ndiv(l)/2
        nbins=nbins*ndiv(l)
        bsize(l)=ell(l)/ndiv(l)
        rbsize(l)=1.d0/bsize(l)
        icount(l)=0
      enddo
      mvects(ndim+1)=nbins

c reserve memory for bins and pointers
      call caches(lbin,nbins,'bins',2)
      call caches(linkps,natoms,'linkbn',2)

c scan neighboring bins and make up lst
      do iflag=1,2

      nbors=0
c neighboring bins are stored in two blocks depending on sign of isym
      data lvcbin/0/
      data nbors2/0/
      is1=lvcbin
      is2=lvcbin+nbors2*ndim

      nbors2=0
c note that the zeroth box is not included
      icount(1)=1
      do 2 kk=2,nbins
         r2=0.0d0
         isym=0

         do k=1,ndim
            ic2(k)=icount(k)
            if(icount(k).gt.nd2(k)) ic2(k)=icount(k)-ndiv(k)
            r=abs(bsize(k)*ic2(k))
            if(isym.eq.0)isym=ic2(k)
            if(r.gt.bsize(k)) r2=r2+(r-bsize(k))**2
         enddo

c  r2 is minimum distance between bin kk and one at the origin
c  ic2 is the integer displacement to bin kk
c  isym is the first nonzero element of ic2(3)

      if(r2.le.cut2) then ! we have found a neighbor
      nbors=nbors+1
      if(isym.lt.0) nbors2=nbors2+1

      if(iflag.eq.2) then ! do not store vector in cache until memory is reserved
      if(ifpch.ne.0) write (6,44) r2,(ic2(k),k=1,ndim)
 44   format(' bin separation ',e12.5,' vector dispacement ',3i5)

      if(isym.le.0) then
         do l=1,ndim
            is1=is1+1
            icc(is1)=icount(l)*mvects(l)
         enddo
      else
         do l=1,ndim
            is2=is2+1
            icc(is2)=icount(l)*mvects(l)
         enddo
      endif
      endif
      endif

      do k=1,ndim
        icount(k)=icount(k)+1
        if(icount(k).lt.ndiv(k)) go to 2
        icount(k)=0
      enddo

2     continue
c now reserve memory for displacement vectors
      if(iflag.eq.1)call caches(lvcbin,ndim*nbors,'binvec',2)
      enddo

      if(ifpch.ne.0) write (6,121) (k,ndiv(k),bsize(k),ell(k),k=1,ndim)
121   format(' dimension ',i5,' number of bins ',i5,' size ',e13.5
     +,'  ell(k)  ',e13.5)
c now set up list of neighbors
      call nnlst(ifpch)
      return
      end
