      subroutine binvi(x,label,v,ibin,ipoint)
c clamps programmed by d. ceperley at nrcc, 1978.
c binvi computes the potential energy of particle label at positon x
c  the binlist in icc(lbin+..) and linked list in icc(linkps+..)
c   give all of the particles in any bin
c  on return binvi sets ibin=address in cache of the bin for postion x
c  and sets ipoint to the particle which points to label
      implicit real*8(a-h,o-z)
      dimension x(3)
      include 'cbins.cm'
      include 'syspec.cm'
      include 'blank.cm'

         ibin=1 ! compute bin of position x
         do l=1,ndim
            ibin=ibin+mvects(l)*int(rbsize(l)*(x(l)+el2(l)))
         enddo
         if(ibin.le.0.or.ibin.gt.nbins) go to 200
         ibin=ibin+lbin !Note that we have already offset position

      ki=ntypes*(icc(ltype+label)-1)
      ipoint=0
c find potential energy within ibin
      jold=0
      j=icc(ibin) ! first particle in ibin
      if(j.le.0) go to 6
2     if(j.eq.label) go to 3

         k=icc(ltype+j)+ki  ! type of particle j
         indj=ndim*(j-1)+lxold
         r2=0.d0
         do l=1,ndim
            indj=indj+1
            r2=r2+(x(l)-cc(indj))**2
         enddo
c      include cal_v.h
!input r2 k ! output v
      lc=cc(lcsi+k)*r2
      if(lc.lt.lenpot-1)then
         p=cc(lcsi+k)*r2-lc
         index=lc+icc(ltab+k)
         v=v+cc(leps+k)*(cc(index)+p*(cc(index+1)-cc(index)))
       endif


        jold=j
5       j=icc(linkps+j) ! pull off next particle
        if(j) 200,6,2
3       ipoint=jold
        go to 5

6     continue ! now loop over all neighboring bins

      inn=lnnlst+nborsu*(ibin-1-lbin) ! nearest neighbor list for ibin
      do 10 j1=1,nbors
      inn=inn+1
      jbin=icc(inn)
      if(jbin.gt.nbins.or.jbin.le.0) go to 200 ! for debugging purposes

      j=icc(jbin+lbin)  ! pull out particles from this list
12    if(j.le.0) go to 110 ! check for empty neighboring bin
      if(j.ne.label) then

         k=ki+icc(ltype+j) ! type of this particle
         indj=ndim*(j-1)+lxold
         r2=0.d0
         do l=1,ndim
            indj=indj+1
            r=x(l)-cc(indj)
            r=abs(abs(r)-el2(l))-el2(l)
            r2=r2+r*r
         enddo
c          include 'cal_v.h'
!input r2 k ! output v
      lc=cc(lcsi+k)*r2
      if(lc.lt.lenpot-1)then
         p=cc(lcsi+k)*r2-lc
         index=lc+icc(ltab+k)
         v=v+cc(leps+k)*(cc(index)+p*(cc(index+1)-cc(index)))
       endif

      endif
      j=icc(linkps+j) ! consider next particle in jbin
      go to 12
110   continue  !NEW LIST

10    continue
      return
200   write (6,201) label,ibin,(x(l),l=1,ndim)
201   format('  trouble in binvi ',2i20,3e12.4)
      call ldump
      return
      end
