      subroutine calpo(iffor,cutmx)
      implicit real*8(a-h,o-z)
      include 'blank.cm'
      include 'syspec.cm'
      include 'cewald.cm'
c   compute the pair potentials and forces
c cc(icc(ltab+ntypes*(i-1)+j)+csi*r2) will contain potentials and forces
c for particles of types i and j separated by r2
c   lenpot (input) is the size of each table for forces or potential
c iffor.ge.0 compute force tables  .le.0 compute potential tables
c cutmx is set to the maximum cutoff for any pair potential
c gel2 will be the largest seperation in the box el2m will
c  be the minimum value of el2

      small=1.d-5
      gel2=0.0
      el2m=el2(1)

      do  l=1,ndim
         gel2=gel2+el2(l)**2
         el2m=min(el2(l),el2m)
      enddo

      gel2=sqrt(gel2)
      cutmx=0.0
      nfused=0
      call caches(lchrt,ntypes**2,'pottab',1)
      loff=0
      if(iffor.eq.0)loff=lenpot
      lp2=lenpot+loff
      i=0

      do j=1,ntypes ! loop over all pairs of particles
      do k=1,ntypes
      i=i+1
c jump over for self interactions of a solitary particle
      if(k.ne.j.or.icc(lcomp+j).gt.1) then

c     sigma and eps are the length and energy scales of potential
c     nbfun is the function number in potent
c     cutoff is length beyond which the potential is set to zero
      sg=cc(lsigma+i)
      eps=cc(leps+i)
      nf=icc(lnfun+i)
      cut=cc(lcutf+i)
      ch=cc(lchrg+j)*cc(lchrg+k)
c set up defaults for these quantiites
      if(eps.le.0.0) then
         nf=0
         eps=ch
         sg=1.0
      endif
      acut=min(gel2,abs(cut))
c cutoff must be the size of the box if this is a charge interaction
      if(ch.ne.0.0) acut=el2m
c default for sigma is one
      if(sg.le.0.0) sg=1.0

      chrt=0.0 ! multipiler for coulomb force
      if(ch.ne.0.0) chrt=(couple*ch*sqal)/eps

c now look at previous pairs to see if the same tables can be used
      do 300 ip=1,i-1
c are they the same function
      if(nf.ne.icc(lnfun+ip)) go to 300
c do they have the same cutoff
      dcutp=abs(cc(lcutf+ip)/cc(lsigma+ip))
      if(acut.eq.0.0) go to 301
      if(abs(acut/sg-dcutp).gt.1.e-5) go to 300
c do they have the same charge eps ratio
301   if(abs(chrt-cc(lchrt+ip)).gt.1.e-5) go to 300
c put them in the same table
      ll=icc(ltab+ip)
c ensure that interactions i and ip have the same dimensionless cutoff
      acut=sg*dcutp
      go to 12
300   continue

      call caches(ll,lp2,'pottab',1) ! set up a new table
      ll=ll+1

      nfused=nfused+1
      if(acut.eq.0.0)acut=el2m
      dcut=acut/sg
      csinv=dcut**2/(lenpot-1-small)
678   format(/5x,'number of tables set up in calpo',i6/
     +5x,'length of each table',i10,' iffor= ',i3)
      data qn1/6hpottab/
      if(chrt.ne.0) c0=chrt*(sqal*sg)**2
90    format(' function number ',i4,' dimensionless cutoff'
     +,f10.5,' potential and force there ',2e14.6)
c      loop over grid in r*r for this function

      do l=lenpot-1,0,-1
      if(l.gt.0) then

        r=sqrt(l*csinv)
        call potent(r,v,f,nf) !  get potential and -1/r*dv/dr for this function

        if(chrt.ne.0.0) then ! for charged systems add in the coulomb potential
          x=sg*sqal*r
          call potent(x,vc,fc,3)
          v=v+chrt*vc
          f=f+c0*fc
        endif

          if(l.eq.lenpot-1) then ! subtract out values at cutoffs
            vzero=v
            write (6,90) nf,r,v,f
           endif

          if(iffor.le.0)cc(ll+l)=v-vzero !    store away
          if(iffor.ge.0) cc(ll+l+loff)=f
      else
          if(iffor.le.0)cc(ll+l)=cc(ll+l+1) ! at zero use vales at 1
          if(iffor.ge.0) cc(ll+l+loff)=cc(ll+l+1+loff)
      endif
      enddo

12    continue

      cc(lsigma+i)=sg ! store away variables
      cc(leps+i)=eps
      icc(lnfun+i)=nf
      if(abs(cut).lt.sg*1.e-5) cut=acut
      cc(lcutf+i)=sign(acut,cut)
      cc(lchrt+i)=chrt
      icc(ltab+i)=ll
      cc(lcsi+i)=(lenpot-1-small)/acut**2
      cc(lepsf+i)=eps/sg**2
      cutmx=max(cutmx,acut)

      endif ! end of loops over itype and jtype
      enddo
      enddo

      write (6,678) nfused,lenpot,iffor
c compute tail corrections for potential energy
      call tails
      return
      end
