      subroutine ftgrad(label,x,grad,v,ifnew)
c computes potential in fourier space due to interaction of particle
c label at position x with other charges. ifnew equals zero, it uses
c cc(lrok+) for the collective coordinates and sets cc(lronew)=
c  cc(lrok)-cc(lplane) so that the next time if ifnew is nonzero
c cc(lronew)=cc(lronew)+cc(lplane) will be the collective coordinates
c  at the new position of x. the interaction energy is added to v.
c clamps programmed by d. ceperley at nrcc, 1978.
      implicit real*8 (a-h,o-z)
      include 'blank.cm'
      include 'syspec.cm'
      include 'cewald.cm'
      dimension grad(3)
      it=icc(ltype+label)
      charge=cc(lchrg+it)
c determine if charged
      if(charge.eq.0.0) return
c add portion of self interaction
      v=v+charge**2*selfen
c get plane waves at this point
      call plane(x,cc(lplane+1),charge)
      if(ifnew.ne.0) go to 30
c old point rok is correct
      do 10 k=1,nkvect
10    cc(lronew+k)=cc(lrok+k)-cc(lplane+k)
      lro=lrok
      go to 50
30    lro=lronew
      do 31 k=1,nkvect
31    cc(lro+k)=cc(lro+k)+cc(lplane+k)
50    kup=0
c compute potential now by summing over shells
      ind=0
      do 60 ks=1,nshlls
      kdn=kup+1
      kup=icc(lkmult+ks)
      do 60 k=kdn,kup
      w=cc(lro+k)*cc(lftpot+ks)
      v=v+w*cc(lplane+k)
      do 80 l=1,ndim
      ind=ind+1
c now compute force=-grad(l) of potential
      j=icc(ind+kpoint)
80    grad(l)=grad(l)+w*cc(kvects+ind)*cc(lplane+j)
60    continue
      return
      end
