      subroutine maxbol
      implicit real*8 (a-h,o-z)
      include 'blank.cm'
c velocity is chosen from a maxwell-boltzmann distribution
c  total momentum is set to zero
      include 'syspec.cm'
      dimension pzero(3)

      if(lvelo.le.0)return

c get ndim*natoms normally distributed random numbers
      call gauran(1.d0,cc(lvelo+1),kx)

c calculate total momentum and mass
      do  l=1,ndim
         pzero(l)=0.0d0
      enddo

      ind=0
      totmas=0.0d0
      do i=1,natoms
         am=cc(lmass+icc(ltype+i))
         c0=sqrt(am)
         totmas=totmas+am
         do l=1,ndim
            ind=ind+1
            pzero(l)=pzero(l)+c0*cc(lvelo+ind)
         enddo
      enddo

      do l=1,ndim
           pzero(l)=pzero(l)/(totmas*sqrt(beta))
      enddo

!      write (6,30) (pzero(l),l=1,ndim)
30    format('  c m velocity before it is zeroed in maxbol'/' ',3e15.8)
      write (*,*)' maxbol ', beta

      ind=0
      do i=1,natoms
         c0=1.d0/sqrt(beta*cc(lmass+icc(ltype+i)))
         do l=1,ndim
            ind=ind+1
            cc(lvelo+ind)=c0*cc(lvelo+ind)-pzero(l)
         enddo
      enddo
      return
      end
