      subroutine pickup(ipick,qid,iptape) ! reads file if desired to continue last run
      implicit real*8 (a-h,o-z)
      character qid*(*),date*26,qdt*8
      integer ipick,iptape

      include 'blank.cm'
      include 'syspec.cm'
      include 'caver.cm'
      include 'cpoly.cm'
      include 'cunits.cm'
      include 'syscon.cm'

c ipick=0 do not read tape
c ipick=1 read configurations 
c ipick=2 also read averages

      if(ipick.le.0) return

      read (iptape) qdt,date,ifpl,kxt,(cc(lxold+l),l=1,kxt)
      write (6,10) qdt,date
10    format(' reading  for coordinates'/
     +' identification of pickup ',a8,a26)
      write (6,11) kx,ifpl
11    format(' number of coordinates and ifply',2i10)
12    format(' xold ',6e10.3)

      if(kxt.ne.kx) then
        write (6,58) kxt
58    format(' run terminates because pickup file is incorrect kx=',i9)
        stop
       endif

      if(ifpl.ne.0) then
          read (iptape) nchain,(icc(lhead+l),icc(lchnad+l)
     .      ,icc(lenchn+l),l=1,nchain),spring,rzero
           write (6,13) nchain
13    format(' polymer descriptors also found for ',i10,'chains')
      endif

      if(ipick.le.1) return
c now get remainder of system information
c check id's for correct pickup
      if(qdt.eq.qid) go to 69
      write (6,68)
68    format(' type 2 pickup failed because ident of pickup tape'
     +,' does not match that on input cards')
      stop
69    continue
      read (iptape) nsets,ndone,ifmd,nblock

c for molecular dynamics also give next step
      if(ifmd.ne.0) read (iptape) chi,chiint,(cc(lvelo+l),l=1,kx)


c      write (6,30) qseed
c30    format(' random number seed in pickup set to ',f20.17)
c if ipick .gt.2 also get old system information
      if(ipick.gt.2) then
      write (6,95)
95    format(' picking up system and potential information since'
     1,'ipick.ge.3')
      read (iptape)
     1 ndim,natoms,ntypes,beta,ro,temp,nunits,(uname(l),l=1,nunits)
     2,(icc(lcomp+l),cc(lchrg+l),cc(lmass+l),cc(ldcnst+l)
     3,cc(laname+l),l=1,ntypes),nt2,(ell(l),l=1,ndim),(cc(leps+l)
     4,cc(lsigma+l),cc(lcutf+l),icc(lnfun+l),l=1,nt2)
       endif
      call load_rng(iptape)

      return
      end
