      subroutine prtpot(iffor,cutmx,dxpot)
c prints information about the potential function such as all the
c pair potentials. dxpot is the grid separation, if zero the
c tables of pair potentials will not be printed.
      implicit real*8 (a-h,o-z)
      include 'blank.cm'
c clamps programmed by d. ceperley at nrcc, 1978.
      include 'syspec.cm'
      include 'cewald.cm'
      include 'syscon.cm'
      include 'cunits.cm'
      dimension vtemp(10),iv(3)
      equivalence (vtemp(1),iv(1))
      ij=0
c set grid size for table printout
      do 63 itype=1,ntypes
      write (6,750) itype,cc(laname+itype),icc(lcomp+itype)
     +,cc(lmass+itype),cc(lchrg+itype),cc(ldcnst+itype)
750   format(1h1//'  potentials and force functions for particle ',
     +'type ',i2,2x,a4/' there are',i5,' particles of this type with'
     +/20x,'mass ',e12.5/20x,'charge',e12.5/20x,'diffusion constant'
     +,e12.5)
       trelax=cc(ldcnst+itype)*beta*cc(lmass+itype)
      write(6,720) trelax,uname(3)
720   format(20x,' relaxation time of langevin velocities ',
     +' = beta*mass*dcnst ',e12.5,2x,a4)
      write (6,755) (jtype,cc(laname+jtype),jtype=1,ntypes)
755   format(/10x,'interaction with other types of particles'/
     +20x,5(i6,4x,a4,7x))
      write (6,756) (icc(lnfun+ij+jtype),jtype=1,ntypes)
756   format(' potential function number',5(i5,15x))
      write (6,757) (cc(leps+ij+jtype),jtype=1,ntypes)
757   format(' epsilon of interaction',5e20.6)
      write (6,758) (cc(lsigma+ij+jtype),jtype=1,ntypes)
758   format(' sigma  of  interaction',5e20.6)
      write (6,759) (cc(lcutf+ij+jtype),jtype=1,ntypes)
759   format(' cutoff distance used  ',5e20.6)
      if(dxpot.le.0.0) go to 63
      npts=cutmx/dxpot
      write (6,760) (jtype,jtype=1,ntypes)
760   format('   distance   ',5(i1,'   v(r)     -1/r'
     +,'*dv/dr '))
      do 60 l=1,npts
      r=l*dxpot
      ib=0
      nt2=2*ntypes
      do 65 i=1,nt2
65    vtemp(i)=0.0
      ii=ij
      do 61 i=1,ntypes
      ii=ii+1
      ind=cc(lcsi+ii)*r*r
      if(ind.ge.lenpot) go to 61
      ib=ib+1
      ll=ind+icc(ltab+ii)
      if(iffor.le.0)vtemp(i+i-1)=cc(leps+ii)*cc(ll)
      if(iffor.ge.0)vtemp(i+i)=cc(lepsf+ii)*cc(ll+lenpot)
61    continue
      if(ib.eq.0) go to 63
      write (6,62) r,(vtemp(i),i=1,nt2)
62    format(2h  ,e12.4,8e13.5)
60    continue
63    ij=ij+ntypes
      if(ifchrg.eq.0) return
c write information concerning fourier space charge interaction
      write (6,700) (tpiell(l),l=1,ndim)
      write (6,890) selfen,sqal
      write (6,701) ckcut,nshlls,nkvect
700   format(' ewald sums used. lattice size in k-space',3e15.7)
701   format(' potential summed for abs(k).le. ',e15.7
     1,' this comprises ',i5,' shells with ',i6,' vectors'
     2//' shell    norm  cuml. no.    potential     vector')
890   format(' selfen and sqal ',2e15.7)
      do 710 k=1,nshlls
      ll=lkcomp+ndim*(icc(lkmult+k)-1)
      do 711 l=1,ndim
711   iv(l)=icc(ll+l)-lscos(l)
710   write (6,712) k,cc(lknorm+k),icc(lkmult+k),cc(lftpot+k)
     1,(iv(l),l=1,ndim)
712   format(4x,i5,e15.7,i5,e15.7,3i5)
      return
      end
