      subroutine setchg(nkcut,nshllse,nkvectse) 
! intializes tables necessary if charges are present 
      implicit real*8 (a-h,o-z)
      include 'syspec.cm'
      include 'cewald.cm'
      include 'syscon.cm'
      include 'blank.cm'
      integer nkcut,nshllse,nkvectse

      vol=1.0d0
c assume cutoff is half the smallest box size
      el2m=el2(1)
      tpi=2.d0*acos(-1.d0)
      do l=1,ndim
        vol=vol*ell(l)
        el2m=min(el2(l),el2m)
        tpiell(l)=tpi/ell(l)
      enddo
      el=vol**(1.d0/ndim)

      ckcut=tpiell(1)*nkcut
      sqal=sqrt((2*ckcut*el/tpi+1)/.3)/el
      write (6,500) nkcut,ckcut,sqal
500   format(' nkcut ckcut and sqal are ',i5,2e15.7)

c call shells to find out k-vectors we need
      call shells(ndim,tpiell,ckcut,nshlls,lkcomp,lknorm,lkmult,nkspan,
     .   nshllse,nkvectse)

      do l=1,ndim ! reserve memory for sin - cosine table
         np=2*nkspan(l)+1
         call caches(lscos(l),np,'setchg',1)
c note pointers are set to middle of table so sines will have
c negative addresses and cosines will have positive addreses
         lscos(l)=lscos(l)+nkspan(l)+1
      enddo

c nkvect is the total number of vectors found in shells
      nkvect=icc(lkmult+nshlls)
c if gradient is needed set up additional tables
      if(ifmd.ne.0.or.ifbd.ne.0) call setdrv(kvects,kpoint
     1,ksave,ndim,tpiell,nshlls,lkcomp,lkmult)
c now make integers vectors in lkcomp into pointers for lscos
      ind=lkcomp
      do k=1,nkvect
      do l=1,ndim
         ind=ind+1
         icc(ind)=icc(ind)+lscos(l)
      enddo
      enddo
c reserve space for plane waves, old and new collective coordinates
      call caches(lplane,nkvect,'plane',1)
      call caches(lrok,nkvect,'plane',1)
      call caches(lronew,nkvect,'plane',1)
c now set up fourier components of coulomb potential
      call setftp(lftpot,ndim,lknorm,el2m,vol,1.0d0,nshlls,sqal,selfen,
     . couple)
c note that r-space part will be set up in calpo
      return
      end
