      subroutine setftp(lftpot,ndim,lknorm,rcut,vol,ex,nshlls,sqal
     .   ,selfen,couple)
c computes fourier components of interaction 1./r**ex for the values
c of k given in cc(lknorm+k), k=1,nshlls . dimensions thespace and
c puts the components in cc(lftpot+k). rcut is the cutoff in rspace
c of the potential, vol is the volume of the simulation box, ndim
c is the dimensionality and sqal =sqrt of convergance parameter.
c selfen=portion of the self inteaction of a particle with its images.
      implicit real*8 (a-h,o-z)
      include 'blank.cm'

      call caches(lftpot,nshlls,'setftp',1)
      sqpi=sqrt(acos(-1.d0))
      diff=.5d0*(ndim-ex)
      ac=(sqal*rcut)**2
      call gammi(gx,.5d0*ex,ac,gx0)
      call gammi(gp,.5d0*ndim,ac,gp0)
      cnst=couple*sqpi**ndim/(vol*gx0*sqal**(ndim-ex))
      cc(lftpot+1)=-2.0d0*cnst/(ndim-ex)
c add tail corrections to zeroth element
      cc(lftpot+1)=cc(lftpot+1)*(1.0d0-gp/gp0
     .             +ex*gx*ac**diff/(gp0*ndim))

      do k=2,nshlls
          xk=cc(lknorm+k)/(2.0d0*sqal)
          xk2=xk**2
          call gammi(v,diff,xk2,g0)
          cc(lftpot+k)=cnst*v/(xk**(ndim-ex))
      enddo

c selfen=portion of the interaction of a charge with its own images
      selfen=-2.0d0*couple*sqal**ex/(ex*gx0)-gx/(gx0*rcut**ex)
      return
      end
