      subroutine setply
      implicit real*8 (a-h,o-z)
      include 'cpoly.cm'
      include 'blank.cm'
      include 'cunits.cm'
      include 'syscon.cm'
c clamps programmed by d. ceperley at nrcc, 1978.
      include 'syspec.cm'
      dimension ncht(10),mtype(10),length(10),icty(5)
      dimension ncatom(5)
      character*8 qm5
      read (5,1) ncards,spring,rzero
1     format(i10,2f10.5)
c*********************************************************************
c     this routine set up polymer data
c     ncards is the number of polymer data cards which follow
c       each one contains the number of chains, the chemical type
c       and the length of the chain
c     the bonding potential (see vchain)  is
c      -.5*spring*rzero**2*log(1-(r/rzero)**2)
c***********************************************************************
      if(rzero.le.0.0) rzero=1.e5*ell(1)
      if(spring.le.0.0) write (6,20)
20    format(' ***********unphysical value of spring constant')
      ncards=max(1,ncards)
      write (6,21) ncards,spring,rzero
21    format(//'  setting up polymer problem'
     +/'  number of different types of chains ',i5/
     +/'  bonding potential is -.5*spring*rzero**2*log(1-(r/rzero)**2'
     +/'  where spring= ',f10.5/7x,' rzero= ',f10.5)
      if(ncards.gt.10) go to 120
c  now read in polymer types
      nchain=0
c nchain will be the total number of polymer chains
      do 2 i=1,ncards
      read (5,22) length(i),ncht(i),mtype(i)
22    format(3i5)
      ncht(i)=max(ncht(i),1)
      mtype(i)=max(mtype(i),1)
      mtype(i)=min(mtype(i),ntypes)
      length(i)=max(length(i),2)
      nchain=nchain+ncht(i)
      write (6,23) i,length(i),ncht(i),mtype(i)
23    format('  card no ',i5,' length of chain ',i10,' number of chains'
     +,i6,'  chemical type ',i5)
2     continue
      call caches(lhead,nchain,'head location',2)
      call caches(lchnad,nchain,'chain state',2)
      call caches(letoe,nchain,'endtoend',1)
c now reserve space in averages for each type of chain
      call setav(jetoe,qm5,uname(2),ncards)
      call caches(lenchn,nchain,qm3,2)
      if(ifmc.eq.0) go to 3
c reserve additional memory if normal monte carlo is used
      call caches(lchnno,natoms,'chain no',2)
      do 4 i=1,natoms
4     icc(lchnno+i)=0
3     icount=0
c assign particle numbers to polymer chains and intialize arrays
      do 5 i=1,ntypes
      ncuml=ncuml+icc(lcomp+i)
      data ncuml/0/
      ncatom(i)=ncuml
5     icty(i)=0
      do 6 i=1,ncards
      nnow=icty(mtype(i))
      next=nnow+ncht(i)*length(i)
      if(next.gt.icc(lcomp+mtype(i))) go to 110
      ladd=ncatom(mtype(i))+nnow-icc(lcomp+mtype(i))
      kup=ncht(i)
      do 7 k=1,kup
      icount=icount+1
      icc(lhead+icount)=0
c intially heads are at the begining of a coordinate block
      icc(lchnad+icount)=ladd+1
      icc(letoe+icount)=jetoe+i-1
      ladd=ladd+length(i)
      icc(lenchn+icount)=length(i)
      if(ifmc.eq.0) go to 7
      l1=ladd-length(i)+1
      do 8 kk=l1,ladd
8     icc(lchnno+kk)=icount
7     continue
6     icty(mtype(i))=next
c****************************************************************
c  on exit caches has the following numbers
c  icc(lenchn+i)=length of the ith chain
c  icc(lhead+i)=head position of ith chain (an integer in the
c     range of 0 to length-1).there is no polymer bond between
c     head and head-1 mod(length)
c icc(lchnad+i)=first particle on the ith chain.the chain then
c     extends from here to icc(lchnad+i)+length-1
c icc(lchnno+j)=the chain number(1 to nchain) of the jth particle
c     zero if not a member of a chain
c icc(letoe+i)=bin in atemp or anorm to store square end to end distance
c*******************************************************************
c these are constants needed in rnbond
      rzi2=1./rzero**2
      sp2rz2=.5*spring*rzero**2
      bndnrm=-1.0e-3
      bndsig=1./(beta*spring)
      return
110   write (6,111) mtype(i)
111   format(' *********** error in polymer setup too many particles',
     +' of type ',i10)
      stop
120   write (6,121) ncards
121   format('  dimensions in setply are too small ',i20)
      stop
      end
