      subroutine setsys(dxpot)
c clamps programmed by d. ceperley at nrcc, 1978.
      implicit real*8 (a-h,o-z)
      include 'syspec.cm'
      include 'syscon.cm'
      dimension ncell(3)
      include 'blank.cm'
      include 'cunits.cm'
c***************************************************
c
c  ntypes = number of different types of particles dflt=1
c  ndim   = spacial dimensionality 1,2 or 3  dflt=3
c  ro     = number density of elementary particles
c  temp   = temperature
c  absmas = unit of mass
c  lenpot= number of words in table for potential and force
c    default is 1000
c
c***************************************************
c loop over different particle types
      write (6,500)
500   format(/' contents of input record 5'//' no prtcls'
     1,'   mass',7x,'charge     relax time   name')
      natoms=0
      do 1 itype=1,ntypes
      read (5,*) icc(lcomp+itype),cc(lmass+itype),cc(lchrg+itype)
     +,cc(ldcnst+itype),cc(laname+itype)
c      read (5,102) icc(lcomp+itype),cc(lmass+itype),cc(lchrg+itype)
c     +,cc(ldcnst+itype),cc(laname+itype)
102   format(i10,3e12.5,1x,a4)
      write (6,102) icc(lcomp+itype),cc(lmass+itype),cc(lchrg+itype)
     +,cc(ldcnst+itype),cc(laname+itype)
c*****************************************
c icc(lcomp+i) = number of particles of chemical type i
c cc(lmass+i) = mass of these particles. default =1
c     only used in molecular dynamics
c cc(lchrg+i) = atomic charge of this type
c cc(ldncst+i) = inverse friction coefficent for this species
c  diffusion constant will be set to this/(beta*mass). used
c in brownian dyanmics and langevin dynamics
c cc(laname+i) = hollerith name of this species
c****************************************************
      ii=(itype-1)*ntypes
      icc(lcomp+itype)=max(icc(lcomp+itype),1)
      natoms=natoms+icc(lcomp+itype)
      if(cc(lmass+itype).le.0) cc(lmass+itype)=1.
c multiply masses by absmas to get real masses
      cc(lmass+itype)=cc(lmass+itype)*absmas
c if charged set flag to do ewald sums
      if(cc(lchrg+itype).ne.0.0) ifchrg=1
c default for friction coefficent is mass
      if(cc(ldcnst+itype).le.0.0) cc(ldcnst+itype)=cc(lmass+itype)
c now make a real diffusion constant
      cc(ldcnst+itype)=cc(ldcnst+itype)/(beta*cc(lmass+itype))
c read itype potential parameters for pairwise interactions
c nbfun is the function number in potent. sigma and eps are the
c  length and energy constants for potential and cutoff is the
c  distance beyond which the potential is zero. if cutoff.lt.
c zero no tail corrections will be added to p and v.
      do 2 jtype=1,itype
      ii=ii+1
      read (5,*) icc(lnfun+ii),cc(lsigma+ii),cc(leps+ii),cc(lcutf+ii)
c      read (5,103) icc(lnfun+ii),cc(lsigma+ii),cc(leps+ii),cc(lcutf+ii)
103   format(i10,3f10.5)
      ij=itype+(jtype-1)*ntypes
c  make symmetric matrices
      icc(lnfun+ij)=icc(lnfun+ii)
      cc(lsigma+ij)=cc(lsigma+ii)
      cc(leps+ij)=cc(leps+ii)
      cc(lcutf+ij)=cc(lcutf+ii)
2     continue
1     continue
c***********************************************************
c
c  read input data to set up simulation box
c  nxtal is the crystal type desired 1=sc,2=bcc,3=hcp,4=fcc
c  if nxtal.le.0 it is set to the value for which there will
c   be the fewest vacancies.
c  ncell(3) are the number of unit crystal cells in each direction
c   if zero will be set to a cubic( or nearly cubic for hcp) box
c   such that the number of sites .ge. number of atoms
c************************************************************
      read (5,*) nxtal,(ncell(l),l=1,ndim)
c      read (5,20) nxtal,(ncell(l),l=1,ndim)
20    format(4i10)
c get crystal postions
      call sites(cc(lxold+1),natoms,ndim,nxtal,ro,ncell,ell)
      return
      end
