      subroutine sites(x,natoms,ndim,nxtalp,ro,ncell,ell)
      implicit real*8 (a-h,o-z)
      dimension x(2),ncell(3),b(3),ell(3),q(3,4),icount(3)
c******************************************************
c  sites computes natoms crystal sites and puts them in x
c  ndim is the spatial dimensionality
c  nxtal is the crystal type see 1,2,3,4 below
c      if zero will chose crystal type to minimize number of vacancies
c  ro is the density per unit volume-used to compute ell
c  ncell(3) are the number of unit cells in each direction
c    if product(ncell)*npuc.lt.natoms ncell is increased so that
c    there at least as many lattice sites as particles and for hcp
c    the box is roughly cubic
c ell(3) --computed--is the size of the simulation box =ncell*cell size
c*********************************************************************
      write (6,15) natoms,ndim,ro
15    format(/' computing ',i5,' lattice sites  dimensionality',i5
     +,'  density per unit volume ',e12.5)

      do  ii=1,12
            q(ii,1)=0.0d0
      enddo
      do  l=1,ndim
           b(l)=1.0d0
      enddo

      nxtal=nxtalp

      if(nxtal.le.0) then
c determine lattice type by minimizing 2**l*ncell**ndim-natoms
         nvac=natoms
         do l=1,ndim
            npuc=2**(l-1)
            nc=int( (float(natoms)/float(npuc))**(1./ndim)+1.0-small)
            nvact=npuc*nc**ndim-natoms
            if(nvact.lt.nvac) then
               nvac=nvact
               nxtal=npuc
            endif
         enddo
         write (6,461)
461      format(' crystal type chosen by default to minimize vacancies')
      endif

      npuc=nxtal
      go to (1,2,3,4) nxtal
1     write (6,11)
11    format('  simple cubic lattice')
      go to 10

2     write (6,12)
12    format('  body centered cubic lattice')
      do  l=1,ndim
            q(l,2)=.5d0
      enddo
      go to 10

3     write (6,13)
13    format('   hexagonal close packed lattice')
      npuc=4
      if(ndim.eq.2) npuc=2
      if(ndim.eq.2) b(1)=3.d0**(-0.25d0)
      if(ndim.eq.3) b(1)=1.d0/sqrt(2.d0)
      b(2)=b(1)*sqrt(3.d0)
      b(3)=b(2)*sqrt(2.d0)/1.5d0
      q(1,2)=0.5d0
      q(2,2)=0.5d0
      q(1,3)=.5d0
      q(2,3)=5.d0/6.d0
      q(3,3)=0.5d0
      q(1,4)=1.0d0
      q(2,4)=1.d0/3.d0
      q(3,4)=.5d0
c b is the size of the unit cell--volume of unit cell is one
c q(npuc,ndim)*b(ndim) are the vector dispacements of sites withincell
      go to 10

4     write (6,14)
14    format('  face-centered cubic lattice')
         do  ii=1,3
         do  l=1,3
            if(ii.ne.l) q(l,ii+1)=.5d0
         enddo
         enddo
10    continue

      npts=1
      do l=1,ndim
        npts=npts*ncell(l)
      enddo

      if(npts*npuc.lt.natoms) then
c recalculate ncell since there are too few lattice points
      xcell=(float(natoms)/float(npuc))**(1./float(ndim))
      npts=1
      do l=1,ndim
         ncell(l)=int(xcell/b(l)+1.0-small)
         npts=npts*ncell(l)
      enddo
      endif

      a=(float(natoms)/(ro*npts))**(1./ndim)
      do l=1,ndim
           icount(l)=0
          ell(l)=ncell(l)*a*b(l)
      enddo
      write (6,255) (ell(l),l=1,ndim)
255   format(' dimensions of simulation box.  ell= ',3e13.5)

      nvac=npts*npuc-natoms
      write (6,90) nvac
90    format(32h number of vacancies in crystal     ,i8)
      write (6,91) npuc
91    format(35h number of particles per unit cell ,i5)
c put in nvac vacancies by flags in x array
      kx=ndim*natoms
      data small/1.0d-7/
          do i=1,kx
              x(i)=0.d0
          enddo
      if (nvac.eq.0) go to 9

c compute index (multiple of 3) for skipping
      do i=1,nvac
        j=ndim*(int((natoms-1)*rng())+2)
c note that there will always be a particle at the origin
         x(j)=x(j)+1.
      enddo

9     continue

      i=0
c  the particles are confined abs(x(l)).le.el2(l)
      ellsq=ell(1)**2
      rnn=ellsq
      rn2=ellsq

      do j=1,npts ! loop over all the unit cells
      do 300 is=1,npuc ! loop over the points per unit cell

      if(x(ndim+i).ge.small) then ! skip over lattice site if vacant
          x(i+ndim)=x(i+ndim)-1.d0
          go to 300
      endif

      rsq=0.0
      do l=1,ndim
         i=i+1
         x(i)=a*b(l)*(icount(l)+q(l,is)-small)
         if(x(i).ge.0.5*ell(l)) x(i)=x(i)-ell(l)
         rsq=rsq+x(i)**2
      enddo

c find the nearest and next nearest distance from the origin
      if(rsq.lt.small*rnn) go to 300 ! exclude the origin
c is this point greater than previously found 2nd minima
      if(rsq-rn2.gt.-8*small*rnn) go to 300
      if(abs(rsq-rnn).lt.8*rnn*small) go to 300
c rnn and rsq must be first and second smallest distances.
      rn2=max(rsq,rnn)
      rnn=min(rsq,rnn)
300    continue

      do l=1,ndim
            icount(l)=icount(l)+1
            if(icount(l).lt.ncell(l)) go to 450
            icount(l)=0
      enddo
450   continue

      enddo
      rnn=sqrt(rnn)
      rn2=sqrt(rn2)
      write (6,100) rnn,rn2
100   format(' nearest and next nearest neighbor distance  ',2e12.5/)
      end
