      subroutine snake(isteps)
      implicit real*8 (a-h,o-z)
      include 'syscon.cm'
c clamps programmed by d. ceperley at nrcc, 1978.
      include 'syspec.cm'
      include 'caver.cm'
      include 'blank.cm'
      include 'cunits.cm'
      include 'cewald.cm'
      include 'cpoly.cm'
      dimension dx(3),xnew(3)
      character*8 qn1,qa2

c intialize bins for average acceptance ratio first time through
       if(nchain.le.0) return
      if(jsnar.eq.0) then
      data jsnar,qn1/0,'snk ar'/
      call setav(jsnar,qn1,ratio,1)
      endif

      if(ifbins.ne.0) call bining(cc(lxold+1))
      if(ifchrg.ne.0) call rok(cc(lxold+1),cc(lrok+1))

      do ipas=1,isteps
      do jpas=1,nchain
      ic=2+int(2*nchain*rng() ) ! pick a chain at rqndom
      ichain=ic/2
      ifhort=ic-2*ichain

      len=icc(ichain+lenchn) ! pick up length, head position and label of chain
      ihead=icc(lhead+ichain)
      lad=icc(lchnad+ichain)
c label is the particle being moved
      itail=ihead-1
      if(itail.lt.0) itail=len-1
      label=ihead
      if(ifhort.eq.0) label=itail
      isum=ihead+itail
      inext=isum-label
c imove is the particle being move
c inext is the proposed new end for imove
      imove=label+lad
      lind=lxold+ndim*(imove-1)
c get pairwise potential
      ibold=0
      call potofp(cc(lind+1),imove,vold,ibold,ipold,0,vb)
c sample a new point
      call rnbond(dx)
      lnext=lxold+ndim*(lad+inext-1)
c evaluate old end to end distance
      rsq=0.0d0
      do l=1,ndim
         r=cc(lind+l)-cc(lnext+l)
         r=abs(abs(r)-el2(l))-el2(l)
         rsq=rsq+r*r
      enddo
      k1=icc(letoe+ichain)
      avtemp(k1)=avtemp(k1)+rsq
      anorm(k1)=anorm(k1)+1.0
      do l=1,ndim
         r=cc(lnext+l)+dx(l)
         if(r.ge.el2(l)) r=r-ell(l)
         if(r.lt.-el2(l)) r=r+ell(l)
         xnew(l)=r
      enddo
c get potential at new postion
      ibnew=1
      call potofp(xnew,imove,vnew,ibnew,ipnew,0,vb)
      pexp=beta*(vold-vnew)
      prob=exp(min(0.0d0,max(-32.0d0,pexp)))
      if(prob.gt.rng()) then
         call accept(xnew,imove,ibold,ibnew,ipold)
         if(ifhort.ne.0) then
            ihead=ihead+1
            if(ihead.ge.len) ihead=ihead-len
         else
            ihead=ihead-1
            if(ihead.lt.0) ihead=ihead+len
         endif
         icc(lhead+ichain)=ihead
         avtemp(jsnar)=avtemp(jsnar)+1.
      endif

      enddo
      call averages
      enddo

      ins=isteps*nchain
      anorm(jsnar)=anorm(jsnar)+ins
      return
      end
