
c compile with f77 -o gofr gofr.f
c For this assignment, you will need to fill in these subroutines 
c  cgofr  - accumulate the a histogram
c  wgofr - normalize and write out output
c
c
c  The main program reads the .chk file to get essential system
c  information.  Then it asks for some user input.  It opens
c  the  .crd file (has the actual configurations) and calls
c   cgofr after each configuration has been read.
c  Finally it calls wgofr to normalize the histogram and write out g(r).


      program gofr
      implicit real*8 (a-h,o-z)
      parameter (nx=10000,mtypes=10,nk=100)
      parameter (mt2=mtypes**2)
      character qid*8,fs*14,uname(5)*8,name(mtypes)*8,tag*32
      character qdt*8,qdat*26
      real *8 x(3,nx),velo(nx),beta,ro,temp,chrg(mtypes),mass(mtypes)
     .  ,dcnst(mtypes),ell(3),eps(mt2),sigma(mt2),cutf(mt2)
      real*8 el2(3),sk(nk),kv(3,nk),tpi,klen(nk),sk2(nk)
      integer ndim,natoms,ntypes,nunits,comp(mtypes),nfun(mt2)
     .,type(nx),ikv(3)
      integer nkvec

      tpi = 8.d0*atan(1.d0)
!First we open the checkpoint file
      write (*,*) ' sofk : input run id (lt 8 characters)'
      read (*,'(a)') qid
      lpx=index(qid,' ')-1
      fs=qid(1:lpx)//'.chk'
      write (*,*) ' trying to open file ',fs
      open(1,file=fs,status='old',form='unformatted')

      read (1) qdt,qdat,ifply,kx,(x(l,1),l=1,kx)
c      read (1) ifply,kx,(x(l,1),l=1,kx)
c      write (6,10) qdt,qdat
10    format(' reading  for coordinates'/
     +' identification of pickup ',3a8)
      write (6,11) kx,ifply
11    format(' number of coordinates and ifply',2i10)

      if(ifply.ne.0) then
          stop
!         read (1) nchain,(icc(lhead+l),icc(lchnad+l)
!    .      ,icc(lenchn+l),l=1,nchain),spring,rzero
!          write (6,13) nchain
!3    format(' polymer descriptors also found for ',i10,'chains')
      endif

      read (1) nsets,ndone,ifmd,nblock
      print*,'nsets',nsets,'ndone',ndone

      if(ifmd.ne.0) read (1) chi,chiint,(velo(l),l=1,kx)

      print*,'ifmd',ifmd
      if (ifmd.ne.0) print*,'chi',chi

      read (1)
     1 ndim,natoms,ntypes,beta,ro,temp,nunits,(uname(l),l=1,nunits)
     2,(comp(l),chrg(l),mass(l),dcnst(l)
     3,name(l),l=1,ntypes)
     3,nt2,(ell(l),l=1,ndim),(eps(l)
     4,sigma(l),cutf(l),nfun(l),l=1,nt2)

       print*,'nunits',nunits
       print*,'ntypes',ntypes

       print*,'boxsize',ell(1),ell(2),ell(3)
       write (*,*)' ndim',ndim,'natoms=',natoms

       write (*,*)' input number to skip in beginning'
       read (*,*)nskip
c       write (*,*)'number of k vectors '
c       read (*,*) nkvec
c       write (*,*)'input table spacing '
c       read (*,*)dr
c       do i=1,nkvec
c          do l=1,ndim
c              kv(l,i) = 0.d0
c          enddo
c          kv(1,i) = real(i-1)*tpi/ell(1)
c          klen(i) = kv(1,i)
c          sk(i) = 0.d0
c       enddo
       open(20,file="kvectors")
       read(20,*) nkvec
       do i=1,nkvec
          read(20,*) (ikv(l),l=1,ndim)
          r =0.d0
          do l=1,ndim
             kv(l,i) = real(ikv(l))*tpi/ell(l)
             r = r + kv(l,i)**2
          enddo
          klen(i) = sqrt(r)
          sk(i) = 0.d0
          sk2(i) = 0.d0
       enddo

c      cutr=ell(1)
c      do l=1,ndim
c       el2(l)=0.5d0*ell(l)
c       cutr=min(cutr,el2(l))
c      enddo
cc      cutr2=cutr**2
c      if(dr.le.0.d0) dr=0.01d0*cutr
c      csi=1.d0/dr
c      nbins = csi*cutr
c      if(csi*cutr.gt.10000) then
c          write (*,*)' memory in cgofr too small '
c          stop
c      endif

!Now open .crd and read and analyze configurations
      fs=qid(1:lpx)//'.crd'
      write (*,*) ' trying to open file ',fs
      open(2,file=fs,status='old',form='formatted')
      read (2,'(a32)') tag
c      write (*,'(a32)') tag
      read (2,'(a32)') tag
      read (2,'(a32)') tag
      read (2,'(a32)') tag
c      write (*,'(a32)') tag
      nconfig=0
      do isteps=1,9999999
        do i=1,natoms
c         read (2,'(i1,3e13.5)',END=100) type(i),(x(l,i),l=1,ndim)
         read (2,'(3e13.5)',END=100) (x(l,i),l=1,ndim)
        enddo
         read (2,'(a32)',END=100) tag

        if(isteps.gt.nskip) then
         nconfig=nconfig+1
         call csofk(x,ndim,natoms,ell,nkvec,kv,sk,sk2) !ADD CONTRIBUTION to S(k)
        endif

      enddo
100   write (*,*)' number of configurations =',nconfig

         call wsofk(ndim,natoms,ell,nkvec,sk,sk2,klen,nconfig,qid) !  WRITE FILE

      end

c-----------------------------------------------------------------------

      subroutine csofk(x,ndim,natoms,ell,nkvec,kv,sk,sk2)
      implicit real*8 (a-h,o-z)
      real*8 x(3,natoms),ell(3),el2(3),sk(nkvec),kv(3,nkvec),sk2(nkvec)
      integer nbins,nkvec
      real*8 csum,ssum

c  x - contains the coordinates of the atoms
c  ndim - number of dimensions
c  ell - the size of the box
c  sk - S(k) accumulator
c  nkvec - # of k vectors
c  kv - k vectors

c  You will need to calculate distances from the coordinates in  x 
c  (don't forget periodic boundary conditions), and bin them, 
c  and accumulate the results in gofr.


      do j=1,nkvec
         csum = 0.d0
         ssum = 0.d0
         do i=1,natoms
            r = 0.d0
            do l=1,ndim
              r=r+kv(l,j)*x(l,i)
            enddo
            csum = csum + cos(r)
            ssum = ssum + sin(r)
        enddo
        sk(j) = sk(j) + csum**2 + ssum**2
        sk2(j) = sk2(j) + (csum**2 + ssum**2)**2
      enddo
      
      end

c-----------------------------------------------------------------------
      subroutine wsofk(ndim,natoms,ell,nkvec,sk,sk2,klen,nconfig,qid)
      implicit real*8 (a-h,o-z)
      real*8 ell(3),dr,sa(3),v,vlast,deltav,pi,constant,errsq
      real*8 sk(nkvec),klen(nkvec),sk2(nkvec)
      character qid*(*)
      integer ndim,natoms,nconfig,nkvec

c  ndim - number of dimensions
c  natoms - number of atoms
c  ell - size of box
c  nkvec - number of k vectors 
c  sk
c  klen - length of each k vector
c  nconfig - the number of configurations used in computing gofr
c             this will be the # of configurations in the .crd file minus
c              the number skipped at the beginning.
c  qid - the run id, used for openin the runid.gr file


      if(nconfig.le.0) return

      lpx=index(qid,' ')-1
      open(3,file=qid(1:lpx)//'.sk',status='unknown',form='formatted')
         
      do i=1,nkvec
         errsq = (-sk2(i) + sk(i)**2)/real(nconfig-1)
         write (3,'(3e15.5)') klen(i),sk(i)/(natoms*nconfig),
     >            sqrt(errsq)/(natoms*nconfig)
      enddo
       end
