      subroutine tails
c computes vtail  from cutoffs by assuming the density
c outside cutoff is constant.
c clamps programmed by d. ceperley at nrcc, 1978.
      implicit real*8 (a-h,o-z)
      include 'blank.cm'
      include 'syspec.cm'
      dimension sa(3)
      data sa(1),sa(2),sa(3)/2.0,3.1415926535,12.56637061/
      vtail=0.0d0
!     write (*,*) lcutf,lcomp,leps,lsigma,lnfun
      write (6,1)
1     format(/5x,'tail corrections with constant density outside cutoff'
     +/6x,'itype jtype    cutoff       v(interior)     v(exterior)')
      do 10 itype=1,ntypes
      do 10 jtype=1,itype
      vint=0.0
      vext=0.0
      ist=jtype+ntypes*(itype-1)
!     write (*,*) ist,natoms,ro
c no tails if cutoff .lt.0
      if(cc(lcutf+ist).gt.0.0) then
        ncp=icc(lcomp+itype)*icc(lcomp+jtype)
c no tails for interactions of solitary particles
      if(ncp.gt.1) then
        tnorm=(cc(leps+ist)*ro*ncp)/float(natoms**2)
c divide by two to account for double counting
        if(itype.eq.jtype) tnorm=0.5*tnorm
        volin=sa(ndim)*cc(lcutf+ist)**ndim/ndim
!       write (*,*)'volin',volin,icc(lnfun+ist),lnfun+ist
       x=cc(lcutf+ist)/cc(lsigma+ist)
       number=icc(lnfun+ist)
!      write (*,*) x,number
       call potent(x,vzero,ff,number)
!      write (*,*) 'after',vzero,ff,ndim,tnorm
c get integral of potential ouside cutoff
        vext=tnorm*cc(lsigma+ist)**ndim*vntgrl(x,ndim,number)
c for self interactions reduce interior volume to account for particle at orgin
        if(itype.eq.jtype) volin=volin-natoms/(ro*icc(lcomp+itype))
        vint=tnorm*volin*vzero
!       write (*,*)'vint',vint
      endif
      endif
      write (6,5) itype,jtype,cc(lcutf+ist),vint,vext
5     format(5x,2i6,3e15.7)
c now add to total tail corrections
      vtail=vtail+vint+vext
10    continue
      write (6,30) vtail
30    format(' tail correction per particle for potential =',e13.6)
      return
      end
