      subroutine units(p,na)
      implicit real*8 (a-h,o-z)
      include 'cunits.cm'
      include 'syspec.cm'
c units parses  an input record of nunits names which tell the
c  units for 1) energy 2)length 3) time 4) mass 5) temperature
c it then searches against known names and if their is a match
c  computes beta=1./kT in the right units and absmas which is
c the conversion from mass units to energy(time/length)**2 units
c  and calculates beta amass in correct units
c uname(nunits) contains the names

c n(i) = number of units of type i
c qt(6) = character description of type of unit
c dd(5,6) = character description of units of type i
c c(i,6) = number of si units per unit i
c dd(1,6) is always in si hence c(1,6)=1.0
      integer m(6),n(6)
      real*8 c(6,6)
      character*6 qt(6),dd(6,6)
      character p(na)*(*)

      secs='secs'
      ratio='ratio'
c  unit specifications
      data qt(1),n(1),dd(1,1),c(1,1),dd(2,1),c(2,1),dd(3,1)
     +/'ENERGY',6,'j',1.0,'erg',1.e-7,'K'/
      data c(3,1),dd(4,1),c(4,1),dd(5,1),c(5,1)/
     +1.380662e-23,'ev',1.6021892e-19,'kcal',4.1868e3/

      data dd(6,1),c(6,1)/'kcpm',6.9525e-21/
      data qt(2),n(2),dd(1,2),c(1,2),dd(2,2),c(2,2)
     +/'LENGTH',4,'m',1.0,'cm',1.0e-2/

      data dd(3,2),c(3,2),dd(4,2),c(4,2)/'a',1.e-10
     +,'bohr',5.2917706e-11/
      data qt(3),n(3),dd(1,3),c(1,3),dd(2,3),c(2,3),dd(3,3),c(3,3)
     +/'TIME',4,'s',1.0,'ps',1.e-12,'ns',1.e-9/

      data dd(4,3),c(4,3)/'fs',1.e-15/
      data qt(4),n(4),dd(1,4),c(1,4),dd(2,4),c(2,4),dd(3,4),c(3,4)
     +/'MASS',3,'kg',1.0,'g',1.e-3,'amu',1.6605655e-27/

      data qt(5),n(5),dd(1,5),c(1,5),dd(2,5),c(2,5)
     +/'TEMP',2,'K',1.0,'C',1.0/

      nunits=5
      do i=1,nunits ! default is null
        m(i)=0
        uname(i)='null'
      enddo

      l=1
      npairs=na/2
      do k=1,npairs

       itype=0
       do i=1,nunits
        if(p(l).eq.qt(i)) itype=i
       enddo

       if(itype.ne.0) then
         ivalue=0
         do i=1,n(itype)
          if(p(l+1).eq.dd(i,itype)) ivalue=i
         enddo
         m(itype)=ivalue
         if(ivalue.gt.0.and.ivalue.le.n(itype)) then
            uname(itype)=dd(ivalue,itype)
         else
            uname(itype)='null'
         endif
       endif

       l=l+2 ! on to next pair
      enddo

      do i=1,nunits
      write (6,4) qt(i),uname(i)
4     format(4x,a6,' will be in units of ',a4)
      enddo

c loop over type of units and locate matches
!      if(m(i).eq.0) write (6,5) uname(i),(dd(k,i),k=1,nup)
!     format(' no match for this type unit we read ',a4,
!    +' but we expected these ',6(1h.,a4,1h.))
 
c    calculate beta
      t0=temp
      if(m(5).eq.2) t0=t0+273.15
      if(t0.lt.0.0) write (6,55)
55    format(' danger temperature was less than absolute zero')
      beta=1./t0
      if(min(m(5),m(1)).gt.0) beta=beta*(c(m(1),1)/c(3,1))
      write (6,6) beta,uname(1)
6     format(4x,'beta = ',e13.6,' in units of inverse ',a4)

c  calculate absmas
      absmas=1.0
      if(min(m(1),m(2),m(3),m(4)).gt.0)absmas=(c(m(4),4)/c(m(1),1))*
     +(c(m(2),2)/c(m(3),3))**2
      write (6,70) absmas
70    format(5x,' conversion factor for masses into units of energy',
     +'*velocity**2',e12.5)

      return
      end
