c************************************************************************
c
c               monte carlo code version 9.2   smf 1/9/91
c
c************************************************************************
c
c       all commons should be defined here
c
      program monte9
c
c ** warning **
c    be sure that the parameter natmax (maximum number of atoms) is
c    set the same in all the subroutines
c
      include 'param.h'
      include 'implicit.h'
      include "common.h"
c
c  determine the initial timing values
c
      call initsec
      t1tot = seconds()
c
c  initialize random number generator
c
      call lranst(-1)
c      call lranst(7654321)
      do 10 i = 1,100
10    dummy = ranl()
c
c  read the parameters controlling output
c
      call rdprnt
c
c  determine which output files are desired and open them
c
      if (printf.ne.'stdout') 
     $  open(unit=6,file=printf)
      if (.not.(conff(1:4).eq.'none'.or.conff(1:4).eq.'NONE')) then
         iconf = 1
         open(unit=20,file=conff,form='UNFORMATTED')
       end if
      if (rstrtf(1:4).ne.'none'.and.rstrtf(1:4).ne.'NONE') then
         open(unit=21,file=rstrtf)
       endif
      if (avef(1:4).ne.'none'.and.avef(1:4).ne.'NONE') then
         open(unit=23,file=avef)
       endif
      ntmax = natmax
      nemax = neimax
c
c  print out the  real time for the beginning of the job
c
      call ltimdat('begin run:',10)
c
c  call dynamo to perform the computation
c
      call mcdriv
c
c  compute final timing information
c
      t2tot = seconds() - t1tot
      write(6,9010) t2tot
9010  format(1x,'timing:',7x,'total:',f15.3,' seconds')
      idays = t2tot/86400
      t2tot = t2tot - idays*86400
      ihours = t2tot/3600
      t2tot = t2tot - ihours*3600
      imin = t2tot/60
      asec = t2tot - imin*60
      write(6,9011) idays,ihours,imin,asec
 9011 format(20x,i2,' days',i3,' hours',i3,' minutes',f7.3,' seconds')
      call ltimdat('end of run:',10)
c
      stop
      end
c************************************************************************
c
c       this is the main routine
c
      subroutine mcdriv
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      dimension vel(3)
      logical rstart,genlat,sort
      dimension scale(3)
      data header /' '/
      data rstart/.false./
      data ndelte/0/,timmax/-1.e5/,timmin/1.e5/
c
      if(natmax.ne.ntmax)then
          write(6,9010)
9010      format(' *****mismatch: parameter natmax in mcdriv*****')
          call mcabort
      endif
c
      write(6,9100)
9100  format(' *******  mcdriv version 9.2(sparc)   1/9/91  *******')
c
c  read and print the descriptive header for this run
c
      call rdhead
      write(6,9110) header
9110  format(' ****************************************** ',//,
     11x,a80,//,
     1' ******************************************  ')
c
c describe the output control in effect
c
      write(6,9120)ipinter,ipatoms,ipitera
9120  format(/,/,'  print control:  ',/,
     1'    print interaction functions: ',i4,/,
     2'    print atom positions: ',i4,/,
     3'    print iteration info: ',i4)
c
c  print the units convention
c
      write(6,9130)
 9130 format(/,/,' explanation of units',/,' positions in angstroms',/,
     1' time in picoseconds',/,' velocities in angstroms/picosecond',/,
     2' energies in ev',/,' temperature in degrees kelvin',/,
     3' pressure in bars ',/,
     4' mass in ev-psec^2/angstroms^2',/,/)
c
c       set up interactions
c
      call inter
      call modint
c
c  determine how the program is to be initialized
c
      call rdinit(genlat,sort,scale)
c
c  read in the start-up file (22) from a previous run if available
c  initf of 'none' indicates that no restart file is available
c
      if (initf(1:4).ne.'none') then
         rstart = .true.
         open(unit=22,file=initf)
         write(6,9132) initf
9132     format(' initial configuration from file ',a8)
         call restart(rstart)
       end if
c
c  don't sort on a restart (unless overridden)
c
      if (rstart) sort=.false.
c
c  insure that by default a lattice is either
c  restarted or created
c
      if (.not.(rstart.or.genlat)) genlat = .true.
c
c  generate a lattice if requested
c    if lattice generation not requested, read in latcard and ignore
c    its contents
c
      if (genlat) then
         call latgen
       else
         call latdum
       end if
c
c  check that the number of atoms is not too large
c
      if (natoms.gt.natmax) then
         write(6,9160) natoms,natmax
         call mcabort
       end if
c
c  scale the lattice if requested
c
      if (scale(1).ne.1.0.or.scale(2).ne.1.0.or.scale(3).ne.1.0) 
     $   call scalem(scale)
c
c  sort lattice if requested
c
      if (sort) call sorter
c
      call modlat
c
c       read in defects
c
      call readef(ndef)
      write(6,9150)ndef
 9150 format('  finished reading in ',i5,' defects ')
c
c  delete vacancies
c
      call delvac
c
c  make sure natoms.le.natmax
c
      if(natoms.gt.natmax)then
         write(6,9160)natoms,natmax
 9160    format(' natoms=',i10,' is greater than natmax=',i10)
         call mcabort
      endif
c
      if (ndef.ne.0.and.sort) call sorter
c
c  read the namelist defining the neighbor finding method
c
      call rdnei
c
c  determine the cut-off information and, if using nmeth=2,
c  initialize the neighbor list
c
      rctsqn = (sqrt(rcutsq) + dradn)**2
      nup1 = 0
      nupall = 0
      if (nmeth.eq.2) call initgn2
      write(6,9165) nmeth,dradn
9165  format(1x,/,1x,'neighbor finding method information',/,
     1       3x,'nmeth:',i6,5x,'dradn:',g12.5)
      write(6,9167) rcutsq,rctsqn
9167  format(3x,'rcutsq:',g12.5,5x,'rctsqn:',g12.5,/,1x)
c
c  read and print the simulation comditions
c
      call rdsim
      write(6,9301) temp
9301  format(1x,/,1x,'********',/,1x,'temperature:',f12.5)
      write(6,9304) press
9304  format(1x,'external pressure:',g12.5)
      do 90 i = 1,ntypes
      write(6,9302) i,chmpot(i)
9302  format(1x,'chemical potential for type',i2,':',g12.5)
      dbrog3(i) = (31.655*amass(i)*temp)**(-1.5)
90    continue
      if (idbrog.ne.0) idbrog = 1
      if (idbrog.eq.1) then
         write(6,*) ' include DeBroglie wavelength contributions'
       else
         write(6,*) ' exclude DeBroglie wavelength contributions'
      endif
      write(6,9303) nstep,ioutput
9303  format(1x,'nstep:',i10,5x,'ioutput:',i10,/,' ********',/,1x)
c
c       calculate initial state
c
      call calce(etot1,chmtot1,1)
      erel1 = etot1 - chmtot1
      write(6,9205)etot1,chmtot1,erel1
 9205 format(' initial state energy: ',g18.10,/,
     1       ' initial sum of chemical potentials: ',g18.10,/,
     2       ' initial energy minus chemical potentials: ',g18.10)
      vol1 = perlen(1)*perlen(2)*perlen(3)
      write(6,9206) vol1
9206  format(1x,'initial volume:',g18.10)
      do 94 i = 1,ntypes
94    nattyp(i) = 0
      do 95 i = 1,natoms
      nattyp(itype(i)) = nattyp(itype(i)) + 1
95    continue
      do 96 i = 1,ntypes
      write(6,9207) i,nattyp(i)
9207  format(2x,'number of atoms of type',i2,':',i5)
96    continue
c
c       print out types, positions, electron densities,
c       and energies for each particle
c
      write(6,9170)natoms
 9170 format(/,/' ****** ',i5,' particles ')
      if(ipatoms.eq.1.or.ipatoms.eq.3)then
         write(6,9180)
 9180    format('   # ',t8,'type',t21,'position',t51,'el. den. ',
     1      t63,'energy ',/,
     2         ' -----',t8,'----',t21,'--------',t51,'--------',
     3      t63,'----- ',/)
         write(6,9190)(i,itype(i),(rv(j,i),j=1,3),rho(i),e(i),
     1      i=1,natoms)
 9190    format(1x,i6,1x,i3,2x,3f10.4,g12.4,1x,f10.5)
      endif
      write(6,9200)(perlen(i),i=1,3)
 9200 format(1x,'perlen:',3g15.7)
c
c  initiaze the averaging variables
c
      call initave
      write(6,*)'imptyp:',(imptyp(j),j=1,nelmax)
c
c  write the job parameters to the output file 20 for use by the
c  analysis programs
c
      if (iconf.eq.1) then
        write(20) header
        write(20) natoms
        write(20) (perub(i),i=1,3),(perlb(i),i=1,3)
       end if
c
c  call montec to perform the monte carlo simulation
c
      call atom1
      call atom2 
      call montec
c
c  print out the final positions as well as
c  the final energy
c
      if(ipatoms.ge.2)then
         write(6,9170)natoms
         write(6,9180)
         write(6,9190)(i,itype(i),(rv(j,i),j=1,3),rho(i),e(i),
     1     i=1,natoms)
      endif
      write(6,9200)(perlen(i),i=1,3)
      write(6,9210) temp
9210  format(1x,/,1x,'**temperature:',g12.5,/,1x)
      call calce(etotacc,dummy,0)
      call calce(etot2,chmtot2,1)
      erel2 = etot2 - chmtot2
      write(6,9240)etot2,chmtot2,erel2
 9240 format(' final state energy: ',g18.10,/,
     1       ' final sum of the chemical potentials: ',g18.10,/,
     2       ' final energy minus chemical potentials: ',g18.10,/,1x)
c
c  determine the changes in the energies
c
      detot=etot2-etot1
      dchmtot = chmtot2 - chmtot1
      derel = erel2 - erel1
      write(6,9245)detot,dchmtot,derel
 9245 format(' change in energy: ',g13.6,/,
     1       ' change in sum of the chemical potentials: ',g13.6,/,
     2       ' change in energy minus chemical potentials: ',g13.6)
      fracer = (etotacc-etot2)/etot2
      write(6,9246) fracer
9246  format(1x,'fractional error in accumulated energy: ',e10.3,/,1x)
      do 220 i = 1,ntypes
      write(6,9247) i,nattyp(i)
9247  format(1x,'final number of atoms of type',i2,':',i5)
220   continue
c
c  print out final volume information
c
      vol2 = perlen(1)*perlen(2)*perlen(3)
      dvol = vol2 - vol1
      write(6,9244) vol2,dvol
9244  format(1x,/,1x,'final volume:',g14.7,/,
     1       1x,' change in volume:',g14.7,/,1x)
c
c  compute and output the average values
c
      call outave
c
c  output the statistics on call to deltae
c
      write(6,9401) ndelte
9401  format(1x,'total number of calls to deltae:',i9)
      if (nmeth.eq.2) write(6,9405) nup1,nupall
9405  format(1x,'number of neighbor list updates:',i10,i10)
      prcnta = 100.0*float(nacept)/float(nstep)
      write(6,9402) nstep,prcnta
9402  format(1x,'number of monte carlo steps:',i9,/,
     1       2x,'percent of steps accepted:',f10.5)
c
      write(6,9403)
9403  format(5x,'jump type',6x,'attempts',7x,'accepts',8x,'percent')
      do 110 i = 1,10
      if (jtypav(i).le.0) goto 110
      percnt = 100.0*float(jtypac(i))/float(jtypav(i))
      write(6,9404) i,jtypav(i),jtypac(i),percnt
9404  format(12x,i2,5x,i9,5x,i9,8x,f7.3)
110   continue
c
c  create the restart file (21)
c
c       use format compatible with vax/creator capability
      if (rstrtf.ne.'none'.and.rstrtf.ne.'none') then
      rewind(21)
      write(21,9501) header
9501  format(a80)
      write(21,9502) natoms,ntypes
9502  format(2i10)
      write(21,9503) (perub(i),i=1,3),(perlb(i),i=1,3)
9503  format(3e25.16)
      write(21,9504) (amass(i),ielement(i),i=1,ntypes)
9504  format(e25.16,i10)
      vel(1) = 0.
      vel(2) = 0.
      vel(3) = 0.
      write(21,9505) ((rv(i,j),i=1,3),(vel(i),i=1,3),itype(j),
     1                j=1,natoms)
9505  format(3e25.16/3e25.16/i10)
      end if
c
c  create the average position restart file (23)
c
c       use format compatible with vax/creator capability
      if (avef.ne.'none'.and.avef.ne.'NONE') then
      write(23,9501) header
      write(23,9502) natoms,ntypes
      write(23,9503) (perub(i),i=1,3),(perlb(i),i=1,3)
      write(23,9504) (amass(i),ielement(i),i=1,ntypes)
      do 200 j = 1,natoms
  200    write(23,9515) (rave(i,j),i=1,3),(cmpave(j,k),k=1,ntypes)
 9515 format(1x,3e24.16,/,8f10.7)
      end if
      return
      end
c***********************************************************************
c
c  outave computes and prints the averages of the various physical
c  properties
c
      subroutine outave
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      data boltz/8.617e-5/
      data zero/0.0/
      if (nave.gt.0) then
c
c  compute the results for the overall averages
c
        avpe = avpe/nave
        avpe2 = avpe2/nave
        avpe2 = sqrt(max(zero,avpe2 - avpe**2))
c
        avvol = avvol/nave
        avvol2 = avvol2/nave
        avvol2 = sqrt(max(zero,avvol2 - avvol**2))
c
        avper(1) = avper(1)/nave
        avper2(1) = avper2(1)/nave
        avper2(1) = sqrt(max(zero,avper2(1) - avper(1)**2))
        avper(2) = avper(2)/nave
        avper2(2) = avper2(2)/nave
        avper2(2) = sqrt(max(zero,avper2(2) - avper(2)**2))
        avper(3) = avper(3)/nave
        avper2(3) = avper2(3)/nave
        avper2(3) = sqrt(max(zero,avper2(3) - avper(3)**2))
c
        avchm = 0.0
        do 100 i = 1,ntypes
        avntyp = float(ntypav(i))/float(nave)
        antyp2 = float(ntypa2(i))/float(nave)
        antyp2 = sqrt(max(zero,antyp2 - avntyp**2))
        avchm = avchm + avntyp*chmpot(i)
c
        write(6,9110) i,avntyp,antyp2
9110    format(1x,'average number of atoms of type',i2,':',f10.4,
     1         4x,'(',f10.4,')')
100     continue
        if (iclcvp.ne.0) then
          do 110 i = 1,3
          do 110 j = 1,3
          astress(i,j) = astress(i,j)/float(nave)
          astres2(i,j) = astres2(i,j)/float(nave)
          astres2(i,j) = sqrt(max(zero,astres2(i,j) - astress(i,j)**2))
110       continue
         endif
c
c  write out the results for the overall averages
c
        averel = avpe - avchm
        write(6,9120) avpe,avpe2,avchm,averel
9120    format(1x,'average energy: ',g14.7,4x,'(',g11.4,')',/,
     1         1x,'average sum of chemical potentials: ',g14.7,/,
     2         1x,'average energy minus chemical potentials: ',g14.7)
        write(6,9130) (i,avper(i),avper2(i),i=1,3)
9130    format(1x,'average periodic length ',i1,':',g14.7,4x,
     1         '(',g11.4,')')
        write(6,9140) avvol,avvol2
9140    format(1x,'average volume: ',g14.7,4x,'(',g11.4,')',/,1x)
        if (iclcvp.ne.0) write(6,9150)
     1      ((astress(i,j),astres2(i,j),i=1,3),j=1,3)
9150    format(1x,'average stress tensor from virial',/,
     1         3(3(g11.4,'(',g10.3,')',3x),/),/)
       end if
c
c  print out the results for the subaverages
c
c
c  first determine the actual number of subaverages that there
c  is data for
c
      ntmp = 0
      do 200 i = 1,nsubav
      if (nsconf(i).gt.0) ntmp = i
200   continue
      nsubav = ntmp
      if (nsubav.le.0) return
c
      write(6,9200) (nsconf(i),i=1,nsubav)
9200  format(1x,'number of mc steps in each subaverage:',10(10i7,/))
c
      write(6,9210)
9210  format(1x,'sub averages of the energy')
      sum1 = 0.0
      sum2 = 0.0
      do 210 i = 1,nsubav
      if (nsconf(i).le.0) goto 210
      ave = sae(i)/nsconf(i)
      ave2 = sae2(i)/nsconf(i)
      ave2 = sqrt(max(zero,ave2 - ave**2))
      write(6,9212) i,ave,ave2
9212  format(4x,i3,2x,g15.8,' (',g11.4,')')
      sum1 = sum1 + ave
      sum2 = sum2 + ave**2
210   continue
      sum1 = sum1/nsubav
      sum2 = sum2/nsubav
      sum2 = sqrt(max(zero,sum2 - sum1**2)/nsubav)
      write(6,9214) sum1,sum2
9214  format(1x,'average energy:',g16.8,' (',g11.4,')')
c
      write(6,9220)
9220  format(1x,'sub averages of the vol')
      sum1 = 0.0
      sum2 = 0.0
      do 220 i = 1,nsubav
      if (nsconf(i).le.0) goto 220
      ave = savol(i)/nsconf(i)
      ave2 = savol2(i)/nsconf(i)
      ave2 = sqrt(max(zero,ave2 - ave**2))
      write(6,9222) i,ave,ave2
9222  format(4x,i3,2x,g15.8,' (',g11.4,')')
      sum1 = sum1 + ave
      sum2 = sum2 + ave**2
220   continue
      sum1 = sum1/nsubav
      sum2 = sum2/nsubav
      sum2 = sqrt(max(zero,sum2 - sum1**2)/nsubav)
      write(6,9224) sum1,sum2
9224  format(1x,'average volume:',g16.8,' (',g11.4,')')
      write(6,9230)
9230  format(1x,'sub averages of the periodic lengths')
      sumx1 = 0.0
      sumy1 = 0.0
      sumz1 = 0.0
      sumx2 = 0.0
      sumy2 = 0.0
      sumz2 = 0.0
      do 230 i = 1,nsubav
      if (nsconf(i).le.0) goto 230
      avex = saper(1,i)/nsconf(i)
      avex2 = saper2(1,i)/nsconf(i)
      avex2 = sqrt(max(zero,avex2 - avex**2))
      avey = saper(2,i)/nsconf(i)
      avey2 = saper2(2,i)/nsconf(i)
      avey2 = sqrt(max(zero,avey2 - avey**2))
      avez = saper(3,i)/nsconf(i)
      avez2 = saper2(3,i)/nsconf(i)
      avez2 = sqrt(max(zero,avez2 - avez**2))
      write(6,9232) i,avex,avex2,avey,avey2,avez,avez2
9232  format(4x,i3,3(2x,f9.4,' (',f8.4,')'))
      sumx1 = sumx1 + avex
      sumy1 = sumy1 + avey
      sumz1 = sumz1 + avez
      sumx2 = sumx2 + avex**2
      sumy2 = sumy2 + avey**2
      sumz2 = sumz2 + avez**2
230   continue
      sumx1 = sumx1/nsubav
      sumy1 = sumy1/nsubav
      sumz1 = sumz1/nsubav
      sumx2 = sumx2/nsubav
      sumy2 = sumy2/nsubav
      sumz2 = sumz2/nsubav
      sumx2 = sqrt(max(zero,sumx2 - sumx1**2)/nsubav)
      sumy2 = sqrt(max(zero,sumy2 - sumy1**2)/nsubav)
      sumz2 = sqrt(max(zero,sumz2 - sumz1**2)/nsubav)
      write(6,9234) sumx1,sumx2,sumy1,sumy2,sumz1,sumz2
9234  format(1x,'ave. lengths:',3(f10.4,'(',f7.4,')'))
c
      do 240 j = 1,ntypes
      write(6,9240) j
9240  format(1x,'subaverage of number of atoms of type',i2)
      sum1 = 0.0
      sum2 = 0.0
      do 245 i = 1,nsubav
      if (nsconf(i).le.0) goto 245
      ave = float(nsant(j,i))/nsconf(i)
      ave2 = float(nsant2(j,i))/nsconf(i)
      ave2 = sqrt(max(zero,ave2 - ave**2))
      write(6,9242) i,ave,ave2
9242  format(4x,i3,2x,f12.4,' (',f10.4,')')
      sum1 = sum1 + ave
      sum2 = sum2 + ave**2
245   continue
      sum1 = sum1/nsubav
      sum2 = sum2/nsubav
      sum2 = sqrt(max(zero,sum2 - sum1**2)/nsubav)
      write(6,9244) j,sum1,sum2
9244  format(1x,'average number of type',i2,':',f12.5,' (',f10.5,')')
240   continue
c
      if (iclcvp.ne.0) then
         write(6,9250)
9250     format(1x,'sub averages of the virial pressure')
         sum1 = 0.0
         sum2 = 0.0
         do 250 i = 1,nsubav
            if (nsconf(i).le.0) goto 250
            avtmp = savp(i)/nsconf(i)
            avtmp2 = savp2(i)/nsconf(i)
            avtmp2 = sqrt(max(zero,avtmp2 - avtmp**2))
            write(6,9252) i,avtmp,avtmp2
9252        format(4x,i3,2x,g15.8,' (',g11.4,')')
            sum1 = sum1 + avtmp
            sum2 = sum2 + avtmp**2
250         continue
         sum1 = sum1/nsubav
         sum2 = sum2/nsubav
         sum2 = sqrt(max(zero,sum2 - sum1**2)/nsubav)
         write(6,9254) sum1,sum2
9254     format(1x,'average virial pressure:',g16.8,' (',g11.4,')')
       endif
c
c  if nave is zero, quit this routine here
c
      if (nave.le.0) return
c
c  compute the average positions and mean square displacements
c
      do 300 j = 1,ntypes
         do 305 i=1,natoms
  305       cmpave(i,j) = cmpave(i,j)/nave
  300       continue
      do 310 j = 1,3
         do 315 i = 1,natoms
            rave(j,i) = rave(j,i)/nave
            ravesq(j,i) =
     $        sqrt(max(zero,(ravesq(j,i)/nave)-rave(j,i)**2))
            rave(j,i) = rave(j,i) + r0ave(j,i)
  315       continue
  310       continue
c
c  compute the substitutional impurity free energy if requested
c
      if (iclimp.ne.0) then
         tempin = temp*boltz
         sum = 0.
         sum2 = 0.
         do 320 i = 1,natoms
            expsum(i) = eref(i) - tempin*log(expsum(i)/nave)
            sum = sum + expsum(i)
            sum2 = sum2 + expsum(i)**2
  320       continue
         sum = sum/natoms
         sum2 = sum2/natoms
         sum2 = sqrt(max(zero,sum2-sum**2))
         write(6,9321) sum,sum2
 9321    format(1x,'average impurity free energy:',g12.5,
     $     ' (',g10.3,')')
       endif
c
c  print out the average positions and impurity free energies as
c  requested by ipave and iclimp
c
      if (iclimp.eq.0) then
         if (ipave.ge.1) then
            write(6,9401)
 9401       format(1x,'average position and composition')
            if (ipave.ge.2) write(6,9402)
 9402       format(1x,'including standard deviations')
            do 400 i = 1,natoms
               write(6,9403) i,rave(1,i),rave(2,i),rave(3,i)
 9403          format(1x,i6,3f10.4)
               if (ipave.ge.2) write(6,9404) (ravesq(j,i),j=1,3)
 9404          format(7x,3(4x,f6.3))
               write(6,9405) (cmpave(i,j),j=1,ntypes)
 9405          format(16x,8f7.4)
  400          continue
          endif
       else
         write(6,9411)
 9411    format(1x,'average position, composition, and impurity f.e.')
         if (ipave.eq.2) write(6,9412)
 9412    format(1x,'including standard deviation of positions')
         do 410 i = 1,natoms
            write(6,9413) i,(rave(j,i),j=1,3)
 9413       format(1x,i6,3f10.4)
            if (ipave.eq.2) write(6,9414) (ravesq(j,i),j=1,3)
 9414       format(7x,3(4x,f6.3))
            write(6,9415) expsum(i),(cmpave(i,j),j=1,ntypes)
 9415       format(1x,f10.4,5x,8f7.4)
  410       continue
       endif
      return
      end
c************************************************************************
c
c  this routine outputs the current configuration to file 20
c  as well as the instantaneous values energy, volume, and number
c  of each type of atom
c
      subroutine output(icount)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      character*24 timestr
      dimension vel(3)
      data de/0.0/,eold/0.0/,ifirst/0/,ipcnt/0/
      data jchkpt/0/
      data boltz/8.617e-5/
c
      if(natmax.ne.ntmax)then
          write(6,9090)
9090      format(' *****mismatch: parameter natmax in output*****')
          call mcabort
      endif
c
c  compute the energy, temperature and pressure
c
      call calce(etot,chmtot,0)
c
c  print out step number, energy, volume and number of atoms of each type
c
      ipcnt = mod(ipcnt + 1,ipitera)
      if(ipcnt.eq.0)then
         volume = perlen(1)*perlen(2)*perlen(3)
         erel = etot - chmtot
         write(6,9001)icount,etot,erel,volume,(nattyp(i),i=1,ntypes)
 9001    format(' output:',i9,2x,3g13.6,10i5)
       end if
c
c  increment the average counters
c
      nskipd = nskipd + 1
      if (nskipd.gt.nequil) then
        nave = nave + 1
        nsub = 1 + (nskipd-nequil-1)/nsubst
        nsubav = nsub
        nsconf(nsub) = nsconf(nsub)+1
        avpe = avpe + etot
        avpe2 = avpe2 + etot**2
        sae(nsub) = sae(nsub) + etot
        sae2(nsub) = sae2(nsub) + etot**2
        vol = perlen(1)*perlen(2)*perlen(3)
        avvol = avvol + vol
        avvol2 = avvol2 + vol**2
        savol(nsub) = savol(nsub) + vol
        savol2(nsub) = savol2(nsub) + vol**2
        do 90 i = 1,3
        avper(i) = avper(i) + perlen(i)
        avper2(i) = avper2(i) + perlen(i)**2
        saper(i,nsub) = saper(i,nsub) + perlen(i)
        saper2(i,nsub) = saper2(i,nsub) + perlen(i)**2
90      continue
        do 100 i = 1,ntypes
        ntypav(i) = ntypav(i) + nattyp(i)
        ntypa2(i) = ntypa2(i) + nattyp(i)**2
        nsant(i,nsub) = nsant(i,nsub) + nattyp(i)
        nsant2(i,nsub) = nsant2(i,nsub) + nattyp(i)**2
100     continue
        if (iclcvp.ne.0) then
          call force
          savp(nsub) = savp(nsub) + pressi
          savp2(nsub) = savp2(nsub) + pressi**2
          do 110 i = 1,3
          do 110 j = 1,3
          astress(i,j) = astress(i,j) + stresst(i,j)
          astres2(i,j) = astres2(i,j) + stresst(i,j)**2
110       continue
         endif
        do 120 i = 1,natoms
           cmpave(i,itype(i)) = cmpave(i,itype(i)) + 1.0
           x = rv(1,i) - r0ave(1,i)
           if (x.gt.hperlen(1)) x = x - perlen(1)
           if (x.lt.-hperlen(1)) x = x + perlen(1)
           y = rv(2,i) - r0ave(2,i)
           if (y.gt.hperlen(2)) y = y - perlen(2)
           if (y.lt.-hperlen(2)) y = y + perlen(2)
           z = rv(3,i) - r0ave(3,i)
           if (z.gt.hperlen(3)) z = z - perlen(3)
           if (z.lt.-hperlen(3)) z = z + perlen(3)
           rave(1,i) = rave(1,i) + x
           rave(2,i) = rave(2,i) + y
           rave(3,i) = rave(3,i) + z
           ravesq(1,i) = ravesq(1,i) + x**2
           ravesq(2,i) = ravesq(2,i) + y**2
           ravesq(3,i) = ravesq(3,i) + z**2
  120      continue
        if (iclimp.ne.0) then
           tempin = boltz*temp
           do 130 i = 1,natoms
              esub = deimp(i)
              expsum(i) = expsum(i) + exp(-(esub-eref(i))/tempin)
  130         continue
         endif
      end if
c
c  write to file 20
c
      t = float(icount)
      if (iconf.eq.1.and.nskipd.gt.nequil) then
         write(20) t,temp,etot,(perlen(i),i=1,3),natoms
         write(20) ((rv(i,j),i=1,3),itype(j),j=1,natoms)
       end if
      jchkpt = mod(jchkpt+1,100)
      if (jchkpt.eq.0.and.rstrtf.ne.'none'.and.rstrtf.ne.'none') then
         rewind(21)
         call mytime(timestr)
CAC      encode(80,9500,header) icount,timestr
9500     format(' step:',i14,2x,a24,34x)
CAC      write(21,9501) header
9501     format(a80)
         write(21,9502) natoms,ntypes
9502     format(2i10)
         write(21,9503) (perub(i),i=1,3),(perlb(i),i=1,3)
9503     format(3e25.16)
         write(21,9504) (amass(i),ielement(i),i=1,ntypes)
9504     format(e25.16,i10)
         vel(1) = 0.
         vel(2) = 0.
         vel(3) = 0.
         write(21,9505) ((rv(i,j),i=1,3),(vel(i),i=1,3),itype(j),
     1                j=1,natoms)
9505     format(3e25.16/3e25.16/i10)
       endif
      return
      end
c**********************************************************************
c
c  this is the main monte carlo routine
c
      subroutine montec
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      logical accept,decide
      dimension imoved(nmovmx),rvnew(3,nmovmx),itynew(nmovmx)
      data boltz/8.617e-5/
c
      if (natmax.ne.ntmax) then
         write(6,*)'mismatch: parameter natmax in montec'
         call mcabort
       end if

      open (17, file='dlte')
c
c  convert the temperature and pressure into computational units
c
      tempin = boltz*temp
      presin = press/1.602e6
c
c  first initialize the energy and electron density at each atom
c
      if (nmeth.eq.2) call chkdis
      call inite
c
c  start the timing of the basic monte carlo loop
c
      time = 0.0
      timein = seconds()
      timtot = timein
c
c  insure that the do loop limits are acceptable and that nstep is a
c  multiple of the output frequency
c
      ioutput = min(ioutput,8000000)
      nloop = ((nstep-1)/ioutput) + 1
      nloop = min(nloop,8000000)
      nstep = nloop*ioutput
      write(6,9001) nstep,ioutput,nequil
9001  format(1x,/,' *** begin monte carlo loop ***',/,
     1       5x,'nstep:',i9,5x,'ioutput:',i7,5x,'nequil:',i7,/,1x)
c
c  call the user supplied routine initjmp to set up any information needed
c  by getjmp to determine the monte carlo steps
c  it is assumed that the user supplied routines will communicate
c  through internal commons
c
      call initjmp
c
c  clear jump type acceptance statistics arrays
c
      do 100 i = 1,10
      jtypac(i) = 0
      jtypav(i) = 0
100   continue
c
c  perform the basic monte carlo loop nstep times
c
      do 1000 iloop1 = 1,nloop
      do 1050 iloop2 = 1,ioutput
c
c  call the user supplied routine getjmp to determine which
c  particle is to be moved and its type
c
      call getjmp(imoved,rvnew,itynew,nmoved,jmptyp)
c
c  insure that the new position is inside the computational box
c
      if ((nmoved*neimax).gt.natoms) then
         isave = 1
       else
         isave = 0
       endif
      do 1100 j = 1,nmoved
      if (itynew(j).ne.0) then
         do 1110 i = 1,3
         if (rvnew(i,j).gt.perub(i))
     1         rvnew(i,j) = rvnew(i,j) - perlen(i)
         if (rvnew(i,j).lt.perlb(i))
     1         rvnew(i,j) = rvnew(i,j) + perlen(i)
1110     continue
       endif
      if (itynew(j).eq.0.or.imoved(j).eq.0) isave = 1
1100  continue
c
c  save the current configuration in case the jump is not accepted
c
      if (isave.eq.1) then
         do 1150 i = 1,natoms
         esv(i) = e(i)
         rhosv(i) = rho(i)
         embdsv(i) = embed(i)
         rvsv(1,i) = rv(1,i)
         rvsv(2,i) = rv(2,i)
         rvsv(3,i) = rv(3,i)
         itypsv(i) = itype(i)
1150     continue
       else
         nsaved = 0
ccdir$ novector
         do 1154 j = 1,nmoved
         rvsv(1,j) = rv(1,imoved(j))
         rvsv(2,j) = rv(2,imoved(j))
         rvsv(3,j) = rv(3,imoved(j))
         itypsv(j) = itype(imoved(j))
1154     continue
ccdir$ vector
       endif
      do 1160 i = 1,nelmax
1160  nattyps(i) = nattyp(i)
      natsav = natoms
      persav(1) = perlen(1)
      persav(2) = perlen(2)
      persav(3) = perlen(3)
      perubs(1) = perub(1)
      perubs(2) = perub(2)
      perubs(3) = perub(3)
c
c  now compute the change in energy due to the jumps
c
c
c  loop over the particles to be moved
c  updating the particle information each time.
c
      de = 0.0
      dpv = 0.0
      dchmpot = 0.0
      prefac = 1.0
      do 1200 loopmv = 1,nmoved
      de = de + deltae(imoved(loopmv),rvnew(1,loopmv),itynew(loopmv),
     1                  dchm,dvol,dpre)
      dchmpot = dchmpot + dchm
      dpv = dpv + presin*dvol
      prefac = prefac*dpre
c      write(17,*) ' itynew: ',itynew(loopmv)
1200  continue
c
c  finally call the user supplied routine modde to compute any
c  additional contributions to the energy
c
      call modde(de,imoved,rvnew,itynew,nmoved,jmptyp)
c
c  determine if the move should be accepted
c
       if (iflag.eq.1) then
        accept=.false.
        go to 1720
       end if

      accept = decide(de,dchmpot,dpv,prefac,tempin)

1720  continue

c      write(17,*) imoved(1), imoved(2), de, dchmpot, dpv, iflag, accept
c      write(17,*) '       '

c
c  call the user supplied routine advjmp with the decision about the
c  jump so that any internal data for the getjmp routine can be updated
c
      call advjmp(accept,imoved,rvnew,itynew,nmoved,jmptyp)
c
c  if the jump was accepted, increment the accept count and update the
c  particle position information
c  if the jump was not accepted,
c  restore the old particle position information
c
      jtypav(jmptyp) = jtypav(jmptyp) + 1
      if (accept) then
         nacept = nacept + 1
         jtypac(jmptyp) = jtypac(jmptyp) + 1
       else
         nattmp = natoms
         natoms = natsav
         if (isave.eq.1) then
            do 1500 i = 1,natoms
            e(i) = esv(i)
            rho(i) = rhosv(i)
            embed(i) = embdsv(i)
            rv(1,i) = rvsv(1,i)
            rv(2,i) = rvsv(2,i)
            rv(3,i) = rvsv(3,i)
            itype(i) = itypsv(i)
1500        continue
          else
            do 1502 j = nsaved,1,-1
            e(jsaved(j)) = esv(j)
            rho(jsaved(j)) = rhosv(j)
            embed(jsaved(j)) = embdsv(j)
1502        continue
ccdir$ novector
            do 1504 i = 1,nmoved
            rv(1,imoved(i)) = rvsv(1,i)
            rv(2,imoved(i)) = rvsv(2,i)
            rv(3,imoved(i)) = rvsv(3,i)
            itype(imoved(i)) = itypsv(i)
1504        continue
ccdir$ vector
          endif
         do 1510 i = 1,nelmax
1510     nattyp(i) = nattyps(i)
         perlen(1) = persav(1)
         perlen(2) = persav(2)
         perlen(3) = persav(3)
         perub(1) = perubs(1)
         perub(2) = perubs(2)
         perub(3) = perubs(3)
       end if
c
c  for nmeth=2, the neighbor lists may need to be corrected if
c  the step was accepted
c
      if (accept.and.ibadlst.ne.0.and.nmeth.eq.2) then
         do 1600 loopmv = 1,nmoved
         if (imoved(loopmv).gt.0) then
            if (itynew(loopmv).eq.0) then
               call dellst(imoved(loopmv))
             else
               call updlst(imoved(loopmv))
             endif
          else
            if (itynew(loopmv).gt.0) then
               natsav = natsav + 1
               call addlst(natsav)
             else
               call chkdis
             endif
          endif
1600     continue
         ibadlst = 0
       endif
      if (.not.accept) ibadlst=0
c
c  end of the basic monte carlo step
c

c
c   Call atom1 and atom2 subroutines
c   to update necessary information.
c
      call atom1
      call atom2 

1050  continue
c
c  now output the results periodically
c  note that the time used for output is excluded from the
c  cpu time attributed to the monte carlo steps
c
c output file ready
c
      time = time + seconds() - timein
      icount = iloop1*ioutput
      call output(icount)
      timein = seconds()
c
c  check that enough time remains for another ioutput monte carlo
c  steps.  if not, print a warning and leave the loop early
c
      tottim = timein - timtot
      dttim = tottim/iloop1
      dttim = 2.0*dttim + 60.0
      call trmain(timlft)
      if (timlft.lt.dttim) then
         nstep = iloop1*ioutput
         write(6,9201)
9201     format(1x,/,1x,'*** warning: ',
     $          'job terminated early due to time limit ***',/,1x)
         goto 2000
       endif
1000  continue
c
c  end of the monte carlo loop
2000  continue
      time = time + seconds() - timein
      timave = time/float(nstep)
      write(6,9101) time,timave
9101  format(1x,'total time for the monte carlo calculation:',f12.4,/,
     1       1x,'average time per monte carlo step:',g12.4)
      return
      end
c**********************************************************************
c
c  this function computes the change in energy for a one atom jump
c  by branching to the appropriate function
c
      function deltae(imoved,rvnew,itynew,dchm,dvol,dpre)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      dimension rvnew(3)
c
c  count the number of energy changes computed
c
      ndelte = ndelte + 1
c
      dchm = 0.0
      dvol = 0.0
      dpre = 1.0
c
c  branch to the appropriate routine
c
      if (imoved.gt.0) then
         if (itynew.gt.0) then
c
c move and possibly change type of an atom
c
            ityold = itype(imoved)
            if (ityold.ne.itynew) then
               if (idbrog.ne.0) then
                  dpre = dbrog3(ityold)/dbrog3(itynew)
                else
                  dpre = 1.
                endif
               nattyp(itynew) = nattyp(itynew) + 1
               nattyp(ityold) = nattyp(ityold) - 1
               dchm = chmpot(itynew) - chmpot(ityold)
             endif
            deltae = de1(imoved,rvnew,itynew)
          else
c
c  delete an atom
c
            ityold = itype(imoved)
            volume = (perlen(1)*perlen(2)*perlen(3))
            if (idbrog.ne.0) then
               dpre = dbrog3(ityold)*float(nattyp(ityold))/volume
             else
               dpre = float(nattyp(ityold))/volume
             endif
            dchm = -chmpot(ityold)
            nattyp(ityold) = nattyp(ityold) - 1
            deltae = de3(imoved)
          endif
       else if (itynew.gt.0) then
c
c  add an atom
c
            volume = (perlen(1)*perlen(2)*perlen(3))
            if (idbrog.ne.0) then
               dpre = volume/(float(nattyp(itynew)+1)*dbrog3(itynew))
             else
               dpre = volume/float(nattyp(itynew)+1)
             endif
            dchm = chmpot(itynew)
            nattyp(itynew) = nattyp(itynew) + 1
            deltae = de2(rvnew,itynew)
          else
c
c  change the periodic lengths
c
            vold = perlen(1)*perlen(2)*perlen(3)
            vnew = rvnew(1)*rvnew(2)*rvnew(3)
            dvol = vnew - vold
            dpre = (1.0 + (dvol/vold))**natoms
            deltae = de4(rvnew)
         endif
      return
      end
c**********************************************************************
c
c  modlat
c
      subroutine modlat
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      if(natmax.ne.ntmax)then
          write(6,9090)
9090      format(' *****mismatch: parameter natmax in modlat*****')
          call mcabort
      endif
      return
      end
      subroutine modint
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      if(natmax.ne.ntmax)then
          write(6,9090)
9090      format(' *****mismatch: parameter natmax in modint*****')
          call mcabort
      endif
      return
      end
      subroutine mcabort
c**********************************************************************
c
c  this subroutine prints and the final values, current averages and
c  creates a restart file in the case of an software controled abort
c  of the execution
c
c**********************************************************************
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      dimension vel(3)
      data zero/0.0/
c
c  print warning
c
      write(6,9001)
9001  format(1x,'****warning****',/,'****software abort****',//)
c
c  print out the final positions as well as
c  the final energy
c
      write(6,9170)natoms
 9170 format(/,/' ****** ',i5,' particles ')
      write(6,9180)
 9180    format('   # ',t8,'type',t21,'position',t51,'el. den. ',
     1      t63,'energy ',/,
     2         ' -----',t8,'----',t21,'--------',t51,'--------',
     3      t63,'----- ',/)
      write(6,9190)(i,itype(i),(rv(j,i),j=1,3),rho(i),e(i),
     1     i=1,natoms)
 9190    format(1x,i6,1x,i3,2x,3f10.4,g12.4,1x,f10.5)
      write(6,9200)(perlen(i),i=1,3)
 9200 format(1x,'perlen:',3g15.7)
      write(6,9210) temp
9210  format(1x,/,1x,'**temperature:',g12.5,/,1x)
      call calce(etot2,chmtot2,0)
      erel2 = etot2 - chmtot2
      write(6,9240)etot2,chmtot2,erel2
 9240 format(' final state energy: ',g18.10,/,
     1       ' final sum of the chemical potentials: ',g18.10,/,
     2       ' final energy minus chemical potentials: ',g18.10,/,1x)
      do 220 i = 1,ntypes
      write(6,9247) i,nattyp(i)
9247  format(1x,'final number of atoms of type',i2,':',i5)
220   continue
c
c  print out final volume information
c
      vol2 = perlen(1)*perlen(2)*perlen(3)
      write(6,9244) vol2
9244  format(1x,/,1x,'final volume:',g14.7)
c
c  compute and output the average values
c
      if (nave.gt.0) then
        avpe = avpe/nave
        avpe2 = avpe2/nave
        avpe2 = sqrt(max(zero,avpe2 - avpe**2))
        avvol = avvol/nave
        avvol2 = avvol2/nave
        avvol2 = sqrt(max(zero,avvol2 - avvol**2))
        avper(1) = avper(1)/nave
        avper2(1) = avper2(1)/nave
        avper2(1) = sqrt(max(zero,avper2(1) - avper(1)**2))
        avper(2) = avper(2)/nave
        avper2(2) = avper2(2)/nave
        avper2(2) = sqrt(max(zero,avper2(2) - avper(2)**2))
        avper(3) = avper(3)/nave
        avper2(3) = avper2(3)/nave
        avper2(3) = sqrt(max(zero,avper2(3) - avper(3)**2))
        avchm = 0.0
        do 310 i = 1,ntypes
        avntyp = float(ntypav(i))/float(nave)
        antyp2 = float(ntypa2(i))/float(nave)
        antyp2 = sqrt(max(zero,antyp2 - avntyp**2))
        avchm = avchm + avntyp*chmpot(i)
        write(6,9312) i,avntyp,antyp2
9312    format(1x,'average number of atoms of type',i2,':',f10.4,
     1         4x,'(',f10.4,')')
310     continue
        averel = avpe - avchm
        write(6,9310) avpe,avpe2,avchm,averel
9310    format(1x,'average energy: ',g14.7,4x,'(',g11.4,')',/,
     1         1x,'average sum of chemical potentials: ',g14.7,/,
     2         1x,'average energy minus chemical potentials: ',g14.7)
        write(6,9313) (i,avper(i),avper2(i),i=1,3)
9313    format(1x,'average periodic length ',i1,':',g14.7,4x,
     1         '(',g11.4,')')
        write(6,9311) avvol,avvol2
9311    format(1x,'average volume: ',g14.7,4x,'(',g11.4,')',/,1x)
       end if
c
c  output the statistics on call to deltae
c
      write(6,9401) ndelte
9401  format(1x,'total number of calls to deltae:',i9)
      if (nmeth.eq.2) write(6,9405) nup1,nupall
9405  format(1x,'number of neighbor list updates:',i10,i10)
      prcnta = 100.0*float(nacept)/float(nstep)
      write(6,9402) nstep,prcnta
9402  format(1x,'number of monte carlo steps:',i9,/,
     1       2x,'percent of steps accepted:',f10.5)
c
      write(6,9403)
9403  format(5x,'jump type',6x,'attempts',7x,'accepts',8x,'percent')
      do 110 i = 1,10
      if (jtypav(i).le.0) goto 110
      percnt = 100.0*float(jtypac(i))/float(jtypav(i))
      write(6,9404) i,jtypav(i),jtypac(i),percnt
9404  format(12x,i2,5x,i9,5x,i9,8x,f7.3)
110   continue
c
c  create the restart file (21)
c
c       use format compatible with vax/creator capability
      if (rstrtf.ne.'none'.and.rstrtf.ne.'none') then
         rewind(21)
         write(21,9501) header
9501     format(a80)
         write(21,9502) natoms,ntypes
9502     format(2i10)
         write(21,9503) (perub(i),i=1,3),(perlb(i),i=1,3)
9503     format(3e25.16)
         write(21,9504) (amass(i),ielement(i),i=1,ntypes)
9504     format(e25.16,i10)
         vel(1) = 0.
         vel(2) = 0.
         vel(3) = 0.
         write(21,9505) ((rv(i,j),i=1,3),(vel(i),i=1,3),itype(j),
     1                j=1,natoms)
9505     format(3e25.16/3e25.16/i10)
       end if
      write(6,9001)
      stop
      end
c***************************************************************
c
c  initave initializes all the values used in computing the averages
c
      subroutine initave
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      namelist /avecard/ nequil,nsubav,iclcvp,iclimp,imptyp
c
      nequil = 0
      nsubav = 10
      iclcvp = 0
      iclimp = 0
      do 2 i = 1,nelmax
    2    imptyp(i) = 0
      read(5,avecard)
c      write(6,avecard)
c      i1 = iclcvp
c      i2 = nequil
c      i3 = nsubav
c      i4 = iclimp
c      do 5 i = 1,nelmax
c         i5(i) = imptyp(i)
    5    continue
c
c  determine the number of mc steps per sub average
c
      nsubav = min(100,nsubav)
      nsubst = int(0.999+float((nstep/ioutput)-nequil)/float(nsubav))
      nsubst = max(1,nsubst)
c
c  zero all the different average variables
c
      nsubav = 0
      nave = 0
      nskipd = 0
      avpe = 0.
      avpe2 = 0.
      avvol = 0.
      avvol2 = 0.
      avper(1) = 0.
      avper2(1) = 0.
      avper(2) = 0.
      avper2(2) = 0.
      avper(3) = 0.
      avper2(3) = 0.
      do 10 i = 1,10
      ntypav(i) = 0
      ntypa2(i) = 0
      jtypav(i) = 0
      jtypac(i) = 0
10    continue
      do 20 i = 1,100
      savol(i) = 0.
      savol2(i) = 0.
      saper(1,i) = 0.
      saper(2,i) = 0.
      saper(3,i) = 0.
      saper2(1,i) = 0.
      saper2(2,i) = 0.
      saper2(3,i) = 0.
      savp(i) = 0.
      savp2(i) = 0.
      do 30 j = 1,nelmax
      nsant(j,i) = 0.
      nsant2(j,i) = 0.
30    continue
20    continue
      do 40 i = 1,3
      do 40 j = 1,3
      astress(i,j) = 0.
      astres2(i,j) = 0.
40    continue
c
c  init the variable for the vacancy formation free energy
c
      if (iclimp.ne.0) then
         do 100 i = 1,natoms
            eref(i) = deimp(i)
  100       expsum(i) = 0.
       endif
c
c  init the variable for computing the average positions
c
      do 200 j = 1,3
      do 200 i = 1,natmax
         r0ave(j,i) = rv(j,i)
         rave(j,i) = 0.
         ravesq(j,i) = 0.
  200    continue
      do 210 j = 1,nelmax
         do 210 i = 1,natmax
            cmpave(i,j) = 0.
  210       continue
      return
      end








