c************************************************************************
c
c  this routine   computes the instantaneous energy
c
      subroutine calce(pot,chm,iclfor)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      data boltz/8.617e-5/
c
      if(natmax.ne.ntmax)then
          write(6,9090)
9090      format(' *****mismatch: parameter natmax in calce*****')
          call mcabort
      endif
c
c  call inite to obtain the potential energy information if needed
c
      if (iclfor.eq.1) then
          if (nmeth.eq.2) call chkdis
          call inite
       endif
c
c  compute the potential energy sum of the chemical potentials
c
      pot=0.0
      chm = 0.0
      do 30 i=1,natoms
      chm = chm + chmpot(itype(i))
 30   pot=pot+e(i)
      return
      end
c************************************************************************
c
c  this subroutine computes the initial energy and electron densities at
c  each atom to start the monte carlo calculations with
c
      subroutine inite
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      logical onlyoi,twoi,threei,fouri
      common /images/ onlyoi,twoi,threei,fouri
      common /wrkspc/ rold(natmax),rnew(natmax),z2new(neimax),
     1 z2old(neimax),phi(neimax),
     2 rnewn(neimax),roldn(neimax),drhon(neimax),embn(neimax),
     3 embnn(neimax),rhon(neimax),delen(neimax),jnei(neimax)
c
      if(natmax.ne.ntmax)then
          write(6,9090)
9090      format(' *****mismatch: parameter natmax in inite*****')
          call mcabort
      endif
      if(neimax.ne.nemax)then
          write(6,9091)
9091      format(' *****mismatch: parameter neimax in inite*****')
          call mcabort
      endif
c
c       clear the arrays used for computing running totals
c
      do 200 i = 1,natoms
      e(i) = 0.
      rho(i) = 0.
200   continue
c
      rdr = 1.0/dr
      rdrho = 1.0/drho
c
c       calculate total density at each atom
c
      do 1000 i=1,natoms
c
c  obtain the information about the neighbors of atom i
c
      call gneigh(i,xnew,ynew,znew,1,0,0)
c
c     compute the contribution to rho(i) from particle j
c
c     compute the contribution to rho(j) from particle i
c
c        set up lagrange four-point interpolation
      ity = itype(i)
cdir$ ivdep
      do 1300 j=1,nnei
      roldn(j) = sqrt(roldn(j))
      p = roldn(j)*rdr
      k = p
      k = min0(k,nr)
      p = p - k
c       make sure that p is less than 2.0
c       then if r is out of range, p = 2.0 and rho = last value of rhor
      p = dmin1(p,1.0d0)
      jty = itype(jnei(j))
      rho(i) = rho(i) + rhor(k,jty)
     1       + p*rhorp(k,jty)
      rho(jnei(j)) = rho(jnei(j)) + rhor(k,ity)
     1       + p*rhorp(k,ity)
      z2old(j) = z2r(k,ity,jty)
     1      + p*z2rp(k,ity,jty)
      phi(j) = z2old(j)/roldn(j)
      e(i) = e(i) + 0.5*phi(j)
      e(jnei(j)) = e(jnei(j)) + 0.5*phi(j)
1300  continue
1000  continue
c
c     now find f for each particle
c
c       set up the lagrange four point interpolation coefficients for
c       the interpolation over density
c
      do 2000 i=1,natoms
      p = rho(i)*rdrho
      k = p
      k = min0(k,nrho)
      p = p - k
c       make sure that p is less than 2.0
c       then if r is out of range, p = 2.0 and f = last value of frho
      p = dmin1(p,1.0d0)
c
c       store fsubi in e(i)
c
      embed(i) = frho(k,itype(i))
     1         + p*frhop(k,itype(i))
      e(i) = e(i) + embed(i)
2000  continue
      return
      end
c**********************************************************************
c
c  this subroutine takes the new postion for the atom imoved
c  and determines the change in energy for that change
c
      function de1(imoved,rvnew,itynew)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /wrkspc/ rold(natmax),rnew(natmax),z2new(neimax),
     1 z2old(neimax),phi(neimax),
     2 rnewn(neimax),roldn(neimax),drhon(neimax),embn(neimax),
     3 embnn(neimax),rhon(neimax),delen(neimax),jnei(neimax)
      dimension rvnew(3,nmovmx)
      data sixth/0.1666666666666667/
c
c  compute the old and new distances to all the other particles in
c  the system from the particle being moved
c
      xnew = rvnew(1,1)
      ynew = rvnew(2,1)
      znew = rvnew(3,1)
      call gneigh(imoved,xnew,ynew,znew,1,1,1)
c
      rdr = 1.0/dr
      rdrho = 1.0/drho
c
c  the neighbor lists are now set up
c
c
c  compute the new contribution to the density at j due to
c  the moved particle
c
c  also convert rnewn from the square of the distance to the distance
c
c
c  compute the new density at the moved particle due to the others and
c  the j atom contribution to the pair interaction at the new separations
c
      ityold = itype(imoved)
      drhomv = 0
      do 2000 j = 1,nnei
      rnewn(j) = sqrt(rnewn(j))
      p = rnewn(j)*rdr
      k = p
      k = min0(k,nr)
      p = p - k
      p = dmin1(p,1.0d0)
      drhon(j) = rhor(k,itynew)
     1         + p*rhorp(k,itynew)
      jty = itype(jnei(j))
      drhomv = drhomv + rhor(k,jty)
     1       + p*rhorp(k,jty)
      z2new(j) = z2r(k,itynew,jty)
     1         + p*z2rp(k,itynew,jty)
      roldn(j) = sqrt(roldn(j))
      p = roldn(j)*rdr
      k = p
      k = min0(k,nr)
      p = p - k
      p = dmin1(p,1.0d0)
      drhon(j) = drhon(j) - rhor(k,ityold)
     1                    - p*rhorp(k,ityold)
      jty = itype(jnei(j))
      z2old(j) = z2r(k,ityold,jty)
     1         + p*z2rp(k,ityold,jty)
2000  continue
c
c  compute the new embedding energies for the unmoved neighbors
c
      do 2800 j = 1,nnei
      p = (rhon(j)+drhon(j))*rdrho
      k = p
c      k = min0(k,nrho)
      p = p - k
c      p = dmin1(p,1.0d0)
      jty = itype(jnei(j))
      embnn(j) = frho(k,jty)
     1         + p*frhop(k,jty)
2800  continue
ccdir$ vector
c
c  compute the new embedding energy of the moved atom
c
      pt = drhomv*rdrho
      kt = pt
      kt = min0(kt,nrho)
      pt = pt - kt
      pt = dmin1(pt,1.0d0)
      embmov = frho(kt,itynew)
     1       + pt*frhop(kt,itynew)
c
c  compute the change in the values of phi(imoved,j) and
c  the change in energy of the unmoved particles
c
      accuracy = 1.0E-5
      iflag=0

      do 3000 j = 1,nnei
cac
      if (abs(rnewn(j)).lt.accuracy.or.abs(roldn(j)).lt.accuracy) then
      iflag=1      
      go to 1717
      else
      go to 1718
      end if
cac
1718  phi(j) = (z2new(j)/rnewn(j) - z2old(j)/roldn(j))
      delen(j) = embnn(j) - embn(j) + 0.5*phi(j)
3000  continue
c
c  now compute the changes in the values of the energy and density
c
c  compute the change in the energy of the moved particle
c
      delei = embmov - embed(imoved)
      do 3200 j = 1,nnei
      delei = delei + 0.5*phi(j)
3200  continue
c
c  now compute the total change in energy
c
      de1 = delei
      do 3400 j = 1,nnei
3400  de1 = de1 + delen(j)
c
c  now update the density and energy of the affected particles
c  is only the data on affected particles is being saved by montec
c  then also save that info (for isave=0)
c
      if (isave.eq.0) then
         nsaved = nsaved + 1
         jsaved(nsaved) = imoved
         esv(nsaved) = e(imoved)
         rhosv(nsaved) = rho(imoved)
         embdsv(nsaved) = embed(imoved)
cdir$ ivdep
         do 4000 j = 1,nnei
         nsaved = nsaved + 1
         jsaved(nsaved) = jnei(j)
         esv(nsaved) = e(jnei(j))
         rhosv(nsaved) = rho(jnei(j))
         embdsv(nsaved) = embed(jnei(j))
         rho(jnei(j)) = rho(jnei(j)) + drhon(j)
         e(jnei(j)) = e(jnei(j)) + delen(j)
         embed(jnei(j)) = embnn(j)
4000     continue
       else
cdir$ ivdep
         do 4010 j = 1,nnei
         rho(jnei(j)) = rho(jnei(j)) + drhon(j)
         e(jnei(j)) = e(jnei(j)) + delen(j)
         embed(jnei(j)) = embnn(j)
4010     continue
       endif
      rho(imoved) = drhomv
      e(imoved) = e(imoved) + delei
      embed(imoved) = embmov
      rv(1,imoved) = rvnew(1,1)
      rv(2,imoved) = rvnew(2,1)
      rv(3,imoved) = rvnew(3,1)
      itype(imoved) = itynew
1717  continue
      return
      end
c**********************************************************************
c
c  this subroutine takes the new postion for the atom imoved
c  and determines the change in energy for that change
c
      function de1x(imoved,rvnew,itynew)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /wrkspc/ rold(natmax),rnew(natmax),z2new(neimax),
     1 z2old(neimax),phi(neimax),
     2 rnewn(neimax),roldn(neimax),drhon(neimax),embn(neimax),
     3 embnn(neimax),rhon(neimax),delen(neimax),jnei(neimax)
      dimension rvnew(3,nmovmx)
      data sixth/0.1666666666666667/
c
c  compute the old and new distances to all the other particles in
c  the system from the particle being moved
c
      xnew = rvnew(1,1)
      ynew = rvnew(2,1)
      znew = rvnew(3,1)
      call gneigh(imoved,xnew,ynew,znew,1,1,1)
c
      rdr = 1.0/dr
      rdrho = 1.0/drho
c
c  the neighbor lists are now set up
c
c
c  compute the new contribution to the density at j due to
c  the moved particle
c
c  also convert rnewn from the square of the distance to the distance
c
c
c  compute the new density at the moved particle due to the others and
c  the j atom contribution to the pair interaction at the new separations
c
      ityold = itype(imoved)
      drhomv = 0
      do 2000 j = 1,nnei
      rnewn(j) = sqrt(rnewn(j))
      p = rnewn(j)*rdr
      k = p
      k = min0(k,nr)
      p = p - k
      p = dmin1(p,1.0d0)
      drhon(j) = rhor(k,itynew)
     1         + p*rhorp(k,itynew)
      jty = itype(jnei(j))
      drhomv = drhomv + rhor(k,jty)
     1       + p*rhorp(k,jty)
      z2new(j) = z2r(k,itynew,jty)
     1         + p*z2rp(k,itynew,jty)
      roldn(j) = sqrt(roldn(j))
      p = roldn(j)*rdr
      k = p
      k = min0(k,nr)
      p = p - k
      p = dmin1(p,1.0d0)
      drhon(j) = drhon(j) - rhor(k,ityold)
     1                    - p*rhorp(k,ityold)
      jty = itype(jnei(j))
      z2old(j) = z2r(k,ityold,jty)
     1         + p*z2rp(k,ityold,jty)
2000  continue
c
c  compute the new embedding energies for the unmoved neighbors
c
      do 2800 j = 1,nnei
      p = (rhon(j)+drhon(j))*rdrho
      k = p
c      k = min0(k,nrho)
      p = p - k
c      p = dmin1(p,1.0d0)
      jty = itype(jnei(j))
      embnn(j) = frho(k,jty)
     1         + p*frhop(k,jty)
2800  continue
ccdir$ vector
c
c  compute the new embedding energy of the moved atom
c
      pt = drhomv*rdrho
      kt = pt
      kt = min0(kt,nrho)
      pt = pt - kt
      pt = dmin1(pt,1.0d0)
      embmov = frho(kt,itynew)
     1       + pt*frhop(kt,itynew)
c
c  compute the change in the values of phi(imoved,j) and
c  the change in energy of the unmoved particles
c
      accuracy = 1.0E-5
      iflag=0

      do 3000 j = 1,nnei
cac
      if (abs(rnewn(j)).lt.accuracy.or.abs(roldn(j)).lt.accuracy) then
      iflag=1      
      go to 1717
      else
      go to 1718
      end if
cac
1718  phi(j) = (z2new(j)/rnewn(j) - z2old(j)/roldn(j))
      delen(j) = embnn(j) - embn(j) + 0.5*phi(j)
3000  continue
c
c  now compute the changes in the values of the energy and density
c
c  compute the change in the energy of the moved particle
c
      delei = embmov - embed(imoved)
      do 3200 j = 1,nnei
      delei = delei + 0.5*phi(j)
3200  continue
c
c  now compute the total change in energy
c
      de1x = delei
      do 3400 j = 1,nnei
3400  de1x = de1x + delen(j)

1717  continue
      return
      end
c**********************************************************************
c
c  this subroutine computes the change in energy for adding an atom
c
      function de2(rvnew,itynew)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /wrkspc/ rold(natmax),rnew(natmax),z2new(neimax),
     1 z2old(neimax),phi(neimax),
     2 rnewn(neimax),roldn(neimax),drhon(neimax),embn(neimax),
     3 embnn(neimax),rhon(neimax),delen(neimax),jnei(neimax)
      dimension rvnew(3,nmovmx)
      data sixth/0.1666666666666667/
c
c  add the atom to the atom list
c
      natoms = natoms + 1
      if (natoms.gt.natmax) then
         write(6,9901)
9901     format(1x,'**** too many atoms (de2)')
         call mcabort
       endif
      imoved = natoms
      rv(1,imoved) = rvnew(1,1)
      rv(2,imoved) = rvnew(2,1)
      rv(3,imoved) = rvnew(3,1)
      rho(imoved) = 0.0
      e(imoved) = 0.0
      embed(imoved) = 0.0
      ibadlst = 1
c
c  compute the new distances to all the other particles in
c  the system from the particle being added
c
      xnew = rvnew(1,1)
      ynew = rvnew(2,1)
      znew = rvnew(3,1)
      call gneigh(imoved,xnew,ynew,znew,0,1,1)
c
      rdr = 1.0/dr
      rdrho = 1.0/drho
c
c  the neighbor lists are now set up
c
c
c  compute the new contribution to the density at j due to
c  the moved particle
c
c  also convert rnewn from the square of the distance to the distance
c
c  compute the new density at the moved particle due to the others and
c  the j atom contribution to the pair interaction at the new separations
c
      drhomv = 0
      do 2000 j = 1,nnei
      rnewn(j) = sqrt(rnewn(j))
      p = rnewn(j)*rdr
      k = p
      k = min0(k,nr)
      p = p - k
      p = dmin1(p,1.0d0)
      drhon(j) = rhor(k,itynew)
     1         + p*rhorp(k,itynew)
      jty = itype(jnei(j))
      drhomv = drhomv + rhor(k,jty)
     1       + p*rhorp(k,jty)
      z2new(j) = z2r(k,itynew,jty)
     1         + p*z2rp(k,itynew,jty)
2000  continue
c
c  compute the new embedding energies for the unmoved neighbors
c
      do 2800 j = 1,nnei
      p = (rhon(j)+drhon(j))*rdrho
      k = p
      k = min0(k,nrho)
      p = p - k
      p = dmin1(p,1.0d0)
      jty = itype(jnei(j))
      embnn(j) = frho(k,jty)
     1         + p*frhop(k,jty)
2800  continue
c
c  compute the new embedding energy of the moved atom
c
      pt = drhomv*rdrho
      kt = pt
      kt = min0(kt,nrho)
      pt = pt - kt
      pt = dmin1(pt,1.0d0)
      embmov = frho(kt,itynew)
     1       + pt*frhop(kt,itynew)
c
c  compute the change in the values of phi(imoved,j) and
c  the change in energy of the unmoved particles
c
      do 3000 j = 1,nnei
      phi(j) = (z2new(j)/rnewn(j))
      delen(j) = embnn(j) - embn(j) + 0.5*phi(j)
3000  continue
c
c  now compute the changes in the values of the energy and density
c
c  compute the change in the energy of the moved particle
c
      delei = embmov
      do 3200 j = 1,nnei
      delei = delei + 0.5*phi(j)
3200  continue
c
c  now compute the total change in energy
c
      de2 = delei
      do 3400 j = 1,nnei
3400  de2 = de2 + delen(j)
c
c  now update the density and energy of all the particles
c
      do 4000 j = 1,nnei
      jj = jnei(j)
      rho(jj) = rho(jj) + drhon(j)
      e(jj) = e(jj) + delen(j)
      embed(jj) = embnn(j)
4000  continue
      rho(imoved) = drhomv
      e(imoved) = e(imoved) + delei
      embed(imoved) = embmov
      rv(1,imoved) = rvnew(1,1)
      rv(2,imoved) = rvnew(2,1)
      rv(3,imoved) = rvnew(3,1)
      itype(imoved) = itynew
      return
      end
c**********************************************************************
c
c  this subroutine computes the energy change to delete an atom
c  and deletes it
c
      function de3(imoved)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /wrkspc/ rold(natmax),rnew(natmax),z2new(neimax),
     1 z2old(neimax),phi(neimax),
     2 rnewn(neimax),roldn(neimax),drhon(neimax),embn(neimax),
     3 embnn(neimax),rhon(neimax),delen(neimax),jnei(neimax)
      data sixth/0.1666666666666667/
c
c  compute the old and new distances to all the other particles in
c  the system from the particle being moved
c
      call gneigh(imoved,dummy,dummy,dummy,1,0,1)
c
      rdr = 1.0/dr
      rdrho = 1.0/drho
c
c  the neighbor lists are now set up
c
      ityold = itype(imoved)
c
c  now subtract out the old contribution to the density at j due
c  to the moved atom to obtain the change in the density
c  at atom j
c
c  also convert rold from the square of the distance to the distance
c
c
c  compute the j atom contribution to the pair interaction for the
c  old separations
c
      do 2200 j = 1,nnei
      roldn(j) = sqrt(roldn(j))
      p = roldn(j)*rdr
      k = p
      k = min0(k,nr)
      p = p - k
      p = dmin1(p,1.0d0)
      drhon(j) = - rhor(k,ityold)
     1           - p*rhorp(k,ityold)
      jty = itype(jnei(j))
      z2old(j) = z2r(k,ityold,jty)
     1         + p*z2rp(k,ityold,jty)
2200  continue
c
c  compute the new embedding energies for the unmoved neighbors
c
      do 2800 j = 1,nnei
      p = (rhon(j)+drhon(j))*rdrho
      k = p
      k = min0(k,nrho)
      p = p - k
      p = dmin1(p,1.0d0)
      jty = itype(jnei(j))
      embnn(j) = frho(k,jty)
     1         + p*frhop(k,jty)
2800  continue
c
c  compute the change in the values of phi(imoved,j) and
c  the change in energy of the unmoved particles
c
      do 3000 j = 1,nnei
      phi(j) = -(z2old(j)/roldn(j))
      delen(j) = embnn(j) - embn(j) + 0.5*phi(j)
3000  continue
c
c  now compute the changes in the values of the energy and density
c
c  compute the change in the energy of the moved particle
c
      delei = -embed(imoved)
      do 3200 j = 1,nnei
      delei = delei + 0.5*phi(j)
3200  continue
c
c  now compute the total change in energy
c
      de3 = delei
      do 3400 j = 1,nnei
3400  de3 = de3 + delen(j)
c
c  now update the density and energy of all the particles
c
      do 4000 j = 1,nnei
      jj = jnei(j)
      rho(jj) = rho(jj) + drhon(j)
      e(jj) = e(jj) + delen(j)
      embed(jj) = embnn(j)
4000  continue
c
c  finally remove the atom from the particle list
c
      natoms = natoms - 1
      do 4100 i = imoved,natoms
      rho(i) = rho(i+1)
      e(i) = e(i+1)
      embed(i) = embed(i+1)
      rv(1,i) = rv(1,i+1)
      rv(2,i) = rv(2,i+1)
      rv(3,i) = rv(3,i+1)
      itype(i) = itype(i+1)
4100  continue
      ibadlst = 1
      return
      end
 
c************************************************************************
c
c  this subroutine compute the change in energy for a change in the
c  periodicity of the sample
c
      function de4(pernew)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      dimension pernew(3)
c
c  compute the old energy
c
      eold = 0.0
      do 1000 i = 1,natoms
      eold = eold + e(i)
1000  continue
c
c  determine the scale factors for the expansion
c
      sc1 = pernew(1)/perlen(1)
      sc2 = pernew(2)/perlen(2)
      sc3 = pernew(3)/perlen(3)
c
c  update the particle positions
c
      do 2000 i = 1,natoms
      rv(1,i) = sc1*(rv(1,i)-perlb(1)) + perlb(1)
      rv(2,i) = sc2*(rv(2,i)-perlb(2)) + perlb(2)
      rv(3,i) = sc3*(rv(3,i)-perlb(3)) + perlb(3)
2000  continue
      perlen(1) = pernew(1)
      perub(1) = perlb(1) + perlen(1)
      perlen(2) = pernew(2)
      perub(2) = perlb(2) + perlen(2)
      perlen(3) = pernew(3)
      perub(3) = perlb(3) + perlen(3)
c
c  compute the new energy
c
      call inite
      enew = 0.0
      do 3000 i = 1,natoms
      enew = enew + e(i)
3000  continue
      de4 = enew - eold
      return
      end
c**********************************************************************
c
c  this subroutine computes the energy change for making an impurity
c
      function deimp(i)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
c
      itynew = imptyp(itype(i))
      if (itynew.eq.0) then
         deimp = de3nc(i)
       else
         deimp = de1nc(i,itynew)
       endif 
      return
      end
c**********************************************************************
c
c  this subroutine takes the new postion for the atom imoved
c  and determines the change in energy for that change
c
      function de1nc(imoved,itynew)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /wrkspc/ rold(natmax),rnew(natmax),z2new(neimax),
     1 z2old(neimax),phi(neimax),
     2 rnewn(neimax),roldn(neimax),drhon(neimax),embn(neimax),
     3 embnn(neimax),rhon(neimax),delen(neimax),jnei(neimax)
      data sixth/0.1666666666666667/
c
c  compute the old and new distances to all the other particles in
c  the system from the particle being moved
c
      xnew = rv(1,imoved)
      ynew = rv(2,imoved)
      znew = rv(3,imoved)
      call gneigh(imoved,xnew,ynew,znew,1,0,1)
c
      rdr = 1.0/dr
      rdrho = 1.0/drho
c
c  the neighbor lists are now set up
c
c
c  compute the new contribution to the density at j due to
c  the moved particle
c
c  also convert rnewn from the square of the distance to the distance
c
c
c  compute the new density at the moved particle due to the others and
c  the j atom contribution to the pair interaction at the new separations
c
      ityold = itype(imoved)
      drhomv = 0
      do 2000 j = 1,nnei
      roldn(j) = sqrt(roldn(j))
      rnewn(j) = roldn(j)
      p = rnewn(j)*rdr
      k = p
      k = min0(k,nr)
      p = p - k
      p = dmin1(p,1.0d0)
      drhon(j) = rhor(k,itynew)
     1         + p*rhorp(k,itynew)
      jty = itype(jnei(j))
      drhomv = drhomv + rhor(k,jty)
     1       + p*rhorp(k,jty)
      z2new(j) = z2r(k,itynew,jty)
     1         + p*z2rp(k,itynew,jty)
      p = roldn(j)*rdr
      k = p
      k = min0(k,nr)
      p = p - k
      p = dmin1(p,1.0d0)
      drhon(j) = drhon(j) - rhor(k,ityold)
     1                    - p*rhorp(k,ityold)
      jty = itype(jnei(j))
      z2old(j) = z2r(k,ityold,jty)
     1         + p*z2rp(k,ityold,jty)
2000  continue
c
c  compute the new embedding energies for the unmoved neighbors
c
      do 2800 j = 1,nnei
      p = (rhon(j)+drhon(j))*rdrho
      k = p
      k = min0(k,nrho)
      p = p - k
      p = dmin1(p,1.0d0)
      jty = itype(jnei(j))
      embnn(j) = frho(k,jty)
     1         + p*frhop(k,jty)
2800  continue
ccdir$ vector
c
c  compute the new embedding energy of the moved atom
c
      pt = drhomv*rdrho
      kt = pt
      kt = min0(kt,nrho)
      pt = pt - kt
      pt = dmin1(pt,1.0d0)
      embmov = frho(kt,itynew)
     1       + pt*frhop(kt,itynew)
c
c  compute the change in the values of phi(imoved,j) and
c  the change in energy of the unmoved particles
c
      accuracy = 1.0E-5   
      iflag=0

      do 3000 j = 1,nnei
cac
      if (abs(rnewn(j)).lt.accuracy.or.abs(roldn(j)).lt.accuracy) then
      iflag=1
      go to 1721 
      else  
      go to 1722
      end if
cac
1722   phi(j) = (z2new(j)/rnewn(j) - z2old(j)/roldn(j))
      delen(j) = embnn(j) - embn(j) + 0.5*phi(j)
3000  continue
c
c  now compute the changes in the values of the energy and density
c
c  compute the change in the energy of the moved particle
c
      delei = embmov - embed(imoved)
      do 3200 j = 1,nnei
      delei = delei + 0.5*phi(j)
3200  continue
c
c  now compute the total change in energy
c
      de1nc = delei
      do 3400 j = 1,nnei
3400  de1nc = de1nc + delen(j)
1721  continue
      return
      end
c**********************************************************************
c
c  this subroutine computes the energy change to delete an atom
c  without deleting it
c
      function de3nc(imoved)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /wrkspc/ rold(natmax),rnew(natmax),z2new(neimax),
     1 z2old(neimax),phi(neimax),
     2 rnewn(neimax),roldn(neimax),drhon(neimax),embn(neimax),
     3 embnn(neimax),rhon(neimax),delen(neimax),jnei(neimax)
      data sixth/0.1666666666666667/
c
c  compute the old and new distances to all the other particles in
c  the system from the particle being moved
c
      call gneigh(imoved,dummy,dummy,dummy,1,0,1)
c
      rdr = 1.0/dr
      rdrho = 1.0/drho
c
c  the neighbor lists are now set up
c
      ityold = itype(imoved)
c
c  now subtract out the old contribution to the density at j due
c  to the moved atom to obtain the change in the density
c  at atom j
c
c  also convert rold from the square of the distance to the distance
c
c
c  compute the j atom contribution to the pair interaction for the
c  old separations
c
      do 2200 j = 1,nnei
      roldn(j) = sqrt(roldn(j))
      p = roldn(j)*rdr
      k = p
      k = min0(k,nr)
      p = p - k
      p = dmin1(p,1.0d0)
      drhon(j) = - rhor(k,ityold)
     1           - p*rhorp(k,ityold)
      jty = itype(jnei(j))
      z2old(j) = z2r(k,ityold,jty)
     1         + p*z2rp(k,ityold,jty)
2200  continue
c
c  compute the new embedding energies for the unmoved neighbors
c
      do 2800 j = 1,nnei
      p = (rhon(j)+drhon(j))*rdrho
      k = p
      k = min0(k,nrho)
      p = p - k
      p = dmin1(p,1.0d0)
      jty = itype(jnei(j))
      embnn(j) = frho(k,jty)
     1         + p*frhop(k,jty)
2800  continue
c
c  compute the change in the values of phi(imoved,j) and
c  the change in energy of the unmoved particles
c
      do 3000 j = 1,nnei
      phi(j) = -(z2old(j)/roldn(j))
      delen(j) = embnn(j) - embn(j) + 0.5*phi(j)
3000  continue
c
c  now compute the changes in the values of the energy and density
c
c  compute the change in the energy of the moved particle
c
      delei = -embed(imoved)
      do 3200 j = 1,nnei
      delei = delei + 0.5*phi(j)
3200  continue
c
c  now compute the total change in energy
c
      de3nc = delei
      do 3400 j = 1,nnei
3400  de3nc = de3nc + delen(j)
      return
      end
c************************************************************************
c
c  this routine determines the neighbors of a given atom
c  the list of neighbors includes all the neighbors of either
c  the old position, the new position, or both.  lold and lnew
c  whether the old or new neighbors are wanted.   lall determines
c  whether the neighbor list is for atoms j<i or all j.
c
      subroutine gneigh(i,xnew,ynew,znew,lold,lnew,lall)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      logical onlyoi,twoi,threei,fouri
      common /images/ onlyoi,twoi,threei,fouri
      common /wrkspc/ rold(natmax),rnew(natmax),z2new(neimax),
     1 z2old(neimax),phi(neimax),
     2 rnewn(neimax),roldn(neimax),drhon(neimax),embn(neimax),
     3 embnn(neimax),rhon(neimax),delen(neimax),jnei(neimax)
      dimension rperlen(3),rmin(natmax)
      dimension postmp(3,natmax)
c
c  define the constants needed to find the nearest periodic image
c
      rperlen(1) = 1./perlen(1)
      rperlen(2) = 1./perlen(2)
      rperlen(3) = 1./perlen(3)
      hperlen(1) = 0.5*perlen(1)
      hperlen(2) = 0.5*perlen(2)
      hperlen(3) = 0.5*perlen(3)
c
c  branch to the appropriate neighbor finding method
c
      goto (1000,2000,90) nmeth
90    write(6,9991) nmeth
9991  format(1x,'undefined neighbor finding method, nmeth:',i3)
      call mcabort
1000  continue
c
c  nmeth = 1
c    this is the order n**2 method
c
c       first do off diagonal terms (i.ne.j)
c       fortran 77 convention: if i=1 then j=1,i-1 loop is skipped
c
      if (lall.eq.1) then
         jend = natoms
       else
         jend = i-1
       endif
c
c  compute the distance to the old coordinate if that is needed
c
      if (lold.ne.0.and.lnew.ne.0) then
         do 1100 j = 1,jend
c
c        compute the square of the distance to the closest periodic image
c
         dis1 = rv(1,i) - rv(1,j)
         if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
         if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
         dis2 = rv(2,i) - rv(2,j)
         if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
         if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
         dis3 = rv(3,i) - rv(3,j)
         if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
         if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
         rold(j) = dis1**2 + dis2**2 + dis3**2
         dis1 = xnew - rv(1,j)
         if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
         if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
         dis2 = ynew - rv(2,j)
         if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
         if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
         dis3 = znew - rv(3,j)
         if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
         if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
         rnew(j) = dis1**2 + dis2**2 + dis3**2
         rmin(j) = dmin1(rnew(j),rold(j))
1100     continue
       else if (lnew.ne.0) then
         do 1120 j = 1,jend
c
c        compute the square of the distance to the closest periodic image
c
         dis1 = xnew - rv(1,j)
         if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
         if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
         dis2 = ynew - rv(2,j)
         if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
         if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
         dis3 = znew - rv(3,j)
         if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
         if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
         rnew(j) = dis1**2 + dis2**2 + dis3**2
         rmin(j) = rnew(j)
1120     continue
       else
         do 1140 j = 1,jend
         dis1 = rv(1,i) - rv(1,j)
         if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
         if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
         dis2 = rv(2,i) - rv(2,j)
         if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
         if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
         dis3 = rv(3,i) - rv(3,j)
         if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
         if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
         rold(j) = dis1**2 + dis2**2 + dis3**2
         rmin(j) = rold(j)
1140     continue
       endif
c
c     determine which pairs are separated by less than rcut
c     and store the needed information about these pairs
c
      nnei = 0
      do 1200 j = 1,jend
      if (rmin(j).gt.rcutsq.or.j.eq.i) go to 1200
      nnei = nnei + 1
      rnewn(nnei) = rnew(j)
      roldn(nnei) = rold(j)
      rhon(nnei) = rho(j)
      embn(nnei) = embed(j)
      jnei(nnei) = j
1200  continue
      if(nnei.gt.neimax)then
          write(6,9012)nnei,neimax
9012      format(' number of neighbors',i5,' exceeds array bound ',i5)
          call mcabort
      endif
      return
2000  continue
c
c  nmeth = 2
c
c  this is the neighbor list method
c
c  first determine the list of potential old and new neighbors
c  (the list will be in neighbor list values)
c  to do this, first see if the current list will suffice by checking
c  the atom in question has moved too far from its last update position
      if (ibadlst.eq.1) goto 1000
      tst = (0.5*dradn)**2
      if (lold.eq.1) then
         dis1 = perlen(1)*posnn(1,nnmap(i)) + perlb(1) - rv(1,i)
         if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
         if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
         dis2 = perlen(2)*posnn(2,nnmap(i)) + perlb(2) - rv(2,i)
         if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
         if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
         dis3 = perlen(3)*posnn(3,nnmap(i)) + perlb(3) - rv(3,i)
         if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
         if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
         rsq = dis1**2 + dis2**2 + dis3**2
         if (rsq.gt.tst) then
            ibadlst = 1
            goto 1000
          endif
       endif
      if (lnew.eq.1) then
         dis1 = perlen(1)*posnn(1,nnmap(i)) + perlb(1) - xnew
         if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
         if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
         dis2 = perlen(2)*posnn(2,nnmap(i)) + perlb(2) - ynew
         if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
         if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
         dis3 = perlen(3)*posnn(3,nnmap(i)) + perlb(3) - znew
         if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
         if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
         rsq = dis1**2 + dis2**2 + dis3**2
         if (rsq.gt.tst) then
            ibadlst = 1
            goto 1000
          endif
       endif
c
c  the current list is okay for both the old and new position so
c  get it and use just it
c
      if (lall.ne.0) then
         jend = nnnum(nnmap(i))
         do 2100 j = 1,jend
         postmp(1,j) = rv(1,nnj(nnlist(j,nnmap(i))))
         postmp(2,j) = rv(2,nnj(nnlist(j,nnmap(i))))
         postmp(3,j) = rv(3,nnj(nnlist(j,nnmap(i))))
         jnei(j) = nnj(nnlist(j,nnmap(i)))
2100     continue
       else
         jend = 0
         do 2110 j = 1,nnnum(nnmap(i))
         jtmp = nnj(nnlist(j,nnmap(i)))
         if (jtmp.ge.i) goto 2110
         jend = jend + 1
         postmp(1,jend) = rv(1,jtmp)
         postmp(2,jend) = rv(2,jtmp)
         postmp(3,jend) = rv(3,jtmp)
         jnei(jend) = jtmp
2110     continue
       endif
c
c  check that jend is not too large
c
      if (jend.gt.neimax) then
         write (6,9901) jend
9901     format(1x,'too many neighbors jend=',i10)
         call mcabort
       endif
c
c  compute the square of the distance to the closest periodic image
c  for either the old, new or both set of positions
c
      if (lnew.ne.0.and.lold.ne.0) then
         do 2600 j = 1,jend
         dis1 = rv(1,i) - postmp(1,j)
         if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
         if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
         dis2 = rv(2,i) - postmp(2,j)
         if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
         if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
         dis3 = rv(3,i) - postmp(3,j)
         if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
         if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
         rold(j) = dis1**2 + dis2**2 + dis3**2
         dis1 = xnew - postmp(1,j)
         if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
         if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
         dis2 = ynew - postmp(2,j)
         if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
         if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
         dis3 = znew - postmp(3,j)
         if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
         if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
         rnew(j) = dis1**2 + dis2**2 + dis3**2
         rmin(j) = dmin1(rnew(j),rold(j))
2600     continue
       else if (lnew.ne.0) then
         do 2620 j = 1,jend
c
c        compute the square of the distance to the closest periodic image
c
         dis1 = xnew - postmp(1,j)
         if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
         if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
         dis2 = ynew - postmp(2,j)
         if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
         if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
         dis3 = znew - postmp(3,j)
         if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
         if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
         rnew(j) = dis1**2 + dis2**2 + dis3**2
         rmin(j) = rnew(j)
2620     continue
       else
         do 2640 j = 1,jend
         dis1 = rv(1,i) - postmp(1,j)
         if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
         if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
         dis2 = rv(2,i) - postmp(2,j)
         if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
         if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
         dis3 = rv(3,i) - postmp(3,j)
         if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
         if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
         rold(j) = dis1**2 + dis2**2 + dis3**2
         rmin(j) = rold(j)
2640     continue
       endif
c
c     determine which pairs are separated by less than rcut
c     and store the needed information about these pairs
c
      nnei = 0
      do 2700 j = 1,jend
      if (rmin(j).gt.rcutsq) go to 2700
      nnei = nnei + 1
      rnewn(nnei) = rnew(j)
      roldn(nnei) = rold(j)
      rhon(nnei) = rho(jnei(j))
      embn(nnei) = embed(jnei(j))
      jnei(nnei) = jnei(j)
2700  continue
      if(nnei.gt.neimax)then
          write(6,9212)nnei,neimax
9212      format(' number of neighbors',i5,' exceeds array bound ',i5)
          call mcabort
      endif
      return
      end
c**********************************************************************
c
c  subroutine initgn2 initializes the near neighbor lists used for
c  neighbor method 2.
c
      subroutine initgn2
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /wrkspc/ rold(natmax),rnew(natmax),z2new(neimax),
     1 z2old(neimax),phi(neimax),
     2 rnewn(neimax),roldn(neimax),drhon(neimax),embn(neimax),
     3 embnn(neimax),rhon(neimax),delen(neimax),jnei(neimax)
      dimension rperlen(3)
c
c reset the create new list flag and set the number of atoms
c in the neighbor list
c
      nupall = nupall + 1
      natnei = natoms
c
c  initialize the posnn array
c  set the initial positions for the neighbor lists
c
c  determine the periodicity data
c
      rperlen(1) = 1./perlen(1)
      rperlen(2) = 1./perlen(2)
      rperlen(3) = 1./perlen(3)
      hperlen(1) = 0.5*perlen(1)
      hperlen(2) = 0.5*perlen(2)
      hperlen(3) = 0.5*perlen(3)
c
      do 100 i=1,natoms
      posnn(1,i) = (rv(1,i)-perlb(1))*rperlen(1)
      posnn(2,i) = (rv(2,i)-perlb(2))*rperlen(2)
      posnn(3,i) = (rv(3,i)-perlb(3))*rperlen(3)
100   continue
c
c  initialize the pointer arrays for the neighbor lists
c
      do 110 i = 1,natmax
      nnmap(i) = i
      nnj(i) = i
      nnnum(i) = 0
110   continue
c
c  loop over all the atom pairs and store the close neighbors
c
      do 1000 j2 = 1,natoms
      do 1100 j1 = 1,j2-1
      dis1 = rv(1,j1) - rv(1,j2)
      if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
      if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
      dis2 = rv(2,j1) - rv(2,j2)
      if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
      if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
      dis3 = rv(3,j1) - rv(3,j2)
      if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
      if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
      p = dis1**2 + dis2**2 + dis3**2
      if (p.ge.rctsqn) goto 1100
      nnnum(j1) = nnnum(j1) + 1
      nnlist(nnnum(j1),j1) = j2
      nnnum(j2) = nnnum(j2) + 1
      nnlist(nnnum(j2),j2) = j1
1100  continue
1000  continue
c
c  check that there are not too many neighbors
c
      do 1300 j1 = 1,natoms
      if (nnnum(j1).gt.neimax) then
         write(6,9901)
9901     format(1x,'too many neighbors (initgn2)')
         call mcabort
       endif
1300  continue
      ibadlst = 0
      return
      end
c**********************************************************************
c
c  updlst updates the neighbor list of atom i and all of atom i's
c  neighbors
c
      subroutine updlst(i)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /wrkspc/ rold(natmax),rnew(natmax),z2new(neimax),
     1 z2old(neimax),phi(neimax),
     2 rnewn(neimax),roldn(neimax),drhon(neimax),embn(neimax),
     3 embnn(neimax),rhon(neimax),delen(neimax),jnei(neimax)
      dimension lstold(natmax),rperlen(3)
      nup1 = nup1 + 1
c
c  set periodicity information
c
      rperlen(1) = 1./perlen(1)
      rperlen(2) = 1./perlen(2)
      rperlen(3) = 1./perlen(3)
      hperlen(1) = 0.5*perlen(1)
      hperlen(2) = 0.5*perlen(2)
      hperlen(3) = 0.5*perlen(3)
c
c  determine the index for atom i in the neighbors list
c
      imap = nnmap(i)
c
c  reset the old position
c
      posnn(1,imap) = rperlen(1)*(rv(1,i)-perlb(1))
      posnn(2,imap) = rperlen(2)*(rv(2,i)-perlb(2))
      posnn(3,imap) = rperlen(3)*(rv(3,i)-perlb(3))
c
c store the old neighbor list for this atom
c
      do 1100 j = 1,nnnum(imap)
1100  lstold(j) = nnlist(j,imap)
      numold = nnnum(imap)
c
c  find the new set of neighbors
c
c
c  create the new list for this atom
c
      nnnum(imap) = 0
      do 1200 j = 1,natoms
      dis1 = perlen(1)*posnn(1,nnmap(j)) + perlb(1) - rv(1,i)
      if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
      if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
      dis2 = perlen(2)*posnn(2,nnmap(j)) + perlb(2) - rv(2,i)
      if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
      if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
      dis3 = perlen(3)*posnn(3,nnmap(j)) + perlb(3) - rv(3,i)
      if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
      if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
      p = dis1**2 + dis2**2 + dis3**2
      if (p.ge.rctsqn.or.j.eq.i) goto 1200
      nnnum(imap) = nnnum(imap) + 1
      nnlist(nnnum(imap),imap) = nnmap(j)
1200  continue
c
c  check that the number of neighbors has not exceeded neimax
c
      if (nnnum(imap).gt.neimax) then
         write(6,9901) nnnum(i),i
9901     format(1x,'number of neighbors,',i5,'for atom,',i5)
         call mcabort
       endif
c
c  now correct all the other lists
c
c  the algorithm uses the fact that both lists are in ascending order
c
      kold = 1
      knew = 1
      if (numold.eq.0.or.nnnum(imap).eq.0) goto 2040
2000  continue
      if (lstold(kold)-nnlist(knew,imap)) 2010,2020,2030
2010  continue
c
c nnlist(knew,imap) > lstold(kold)
c
      call nm2del(i,lstold(kold))
      kold = kold + 1
      if (kold.le.numold) goto 2000
      goto 2040
2020  continue
c
c nlist(knew,i) = lstold(kold)
c
      kold = kold + 1
      knew = knew + 1
      if (knew.le.nnnum(imap).and.kold.le.numold) goto 2000
      goto 2040
2030  continue
c
c  lstold(kold) > nnlist(knew,imap)
c
      call nm2add(i,nnlist(knew,imap))
      knew = knew + 1
      if (knew.le.nnnum(imap)) goto 2000
2040  continue
c
c  take care of the ends of the lists
c
      do 2050 kount = kold,numold
2050  call nm2del(i,lstold(kount))
      do 2060 kount = knew,nnnum(imap)
2060  call nm2add(i,nnlist(kount,imap))
      return
      end
c**********************************************************************
c
c  nm2add adds atom i to the neighbor list  j
c
      subroutine nm2add(i,jmap)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
c
c  increment the number of neighbors for list j
c
      nnnum(jmap) = nnnum(jmap) + 1
      if (nnnum(jmap).gt.neimax) then
         write(6,9901)
9901     format(1x,'too many neighbors (nm2add)')
         call mcabort
       endif
c
c  skip over the elements in the list before i
c
      k = 0
100   continue
      k = k + 1
      if (nnlist(k,jmap).lt.nnmap(i).and.k.lt.nnnum(jmap)) goto 100
c
c  shift the rest of the list up
c
      do 200 l = nnnum(jmap),k+1,-1
200   nnlist(l,jmap) = nnlist(l-1,jmap)
c
c  add the atom to the list
c
      nnlist(k,jmap) = nnmap(i)
      return
      end
c**********************************************************************
c
c  nm2del deletes atom i from the neighbor list for atom j
c
      subroutine nm2del(i,jmap)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
c
c  decrement the number of neighbors for atom j
c
      nnnum(jmap) = nnnum(jmap) - 1
c
c  skip over the elements in the list before i
c
      k = 0
100   continue
      k = k + 1
      if (nnlist(k,jmap).ne.nnmap(i)) goto 100
c
c  shift the rest of the list down
c
      do 200 l = k,nnnum(jmap)
200   nnlist(l,jmap) = nnlist(l+1,jmap)
      return
      end
c**********************************************************************
c
c  chkdis checks the displacement of each atom since the last
c  time its neighbor list was updated.  for each atom which has
c  moved more than dradn/2  the list is updated.
c
      subroutine chkdis
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      common /wrkspc/ rold(natmax),rnew(natmax),z2new(neimax),
     1 z2old(neimax),phi(neimax),
     2 rnewn(neimax),roldn(neimax),drhon(neimax),embn(neimax),
     3 embnn(neimax),rhon(neimax),delen(neimax),jnei(neimax)
      dimension rperlen(3)
c
c  determine the displacement of all of the particles from their
c  last update position
c
      rperlen(1) = 1./perlen(1)
      rperlen(2) = 1./perlen(2)
      rperlen(3) = 1./perlen(3)
      hperlen(1) = 0.5*perlen(1)
      hperlen(2) = 0.5*perlen(2)
      hperlen(3) = 0.5*perlen(3)
c
c  map the posnn values for each atom into the array dis
c
c
c  for each distance determine if the list for that atom
c  should be updated
c
      tst = (0.5*dradn)**2
      do 1000 i = 1,natoms
      dis1 = perlen(1)*posnn(1,nnmap(i)) + perlb(1) - rv(1,i)
      if (dis1.gt.hperlen(1)) dis1 = dis1 - perlen(1)
      if (dis1.lt.-hperlen(1)) dis1 = dis1 + perlen(1)
      dis2 = perlen(2)*posnn(2,nnmap(i)) + perlb(2) - rv(2,i)
      if (dis2.gt.hperlen(2)) dis2 = dis2 - perlen(2)
      if (dis2.lt.-hperlen(2)) dis2 = dis2 + perlen(2)
      dis3 = perlen(3)*posnn(3,nnmap(i)) + perlb(3) - rv(3,i)
      if (dis3.gt.hperlen(3)) dis3 = dis3 - perlen(3)
      if (dis3.lt.-hperlen(3)) dis3 = dis3 + perlen(3)
      p = dis1**2 + dis2**2 + dis3**2
      if (p.ge.tst) call updlst(i)
1000  continue
      ibadlst = 0
      return
      end
c**********************************************************************
c
c  addlst performs the list manipulations necessary if an atom is
c  created
c
      subroutine addlst(i)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
c
c  correct the values in the nnj pointer array to point back to the
c  new atom numbers
c
      do 100 j = 1,natmax
100   if (nnj(j).ge.i) nnj(j) = nnj(j) + 1
      natnei = natnei + 1
      imap = nnmap(natnei)
      nnj(imap) = i
      nnnum(imap) = 0
c
c  shift the nnmap pointer array and insert the atom back into
c  the list
c
      do 200 j = natnei,i+1,-1
200   nnmap(j) = nnmap(j-1)
      nnmap(i) = imap
c
c  update the list for atom i
c
      call updlst(i)
      return
      end
c**********************************************************************
c
c  dellst performs the list manipulations necessary if an atom is
c  destroyed
c
      subroutine dellst(i)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
c
c  eliminate the references to this atom in the other neighbor lists
c
      do 100 j = 1,nnnum(nnmap(i))
100   call nm2del(i,nnlist(j,nnmap(i)))
c
c  shift the nnmap and make the list space of the deleted atom
c  for the next atom added to the list
c
      imap = nnmap(i)
      natnei = natnei - 1
      do 200 j = i,natnei
      nnmap(j) = nnmap(j+1)
200   continue
      nnnum(imap) = 0
      nnmap(natnei+1) = imap
c
c  correct the values in the nnj pointer array to point back to the
c  new atom numbers
c
      nnj(imap) = 0
      do 300 j=1,natmax
300   if (nnj(j).ge.i) nnj(j) = nnj(j) - 1
      return
      end
c************************************************************************
c
c  this routine compute the forces acting on each of the particles
c  as well as the energy of each particle and the contribution of each
c  particle to the stress tensor.
c
      subroutine force
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      logical onlyoi,twoi,threei,fouri
      common /images/ onlyoi,twoi,threei,fouri
      common /wrkspc2/ fp(natmax),rn(neimax),dis(3,natmax),
     1  rhoip(neimax),rhojp(neimax),z2(neimax),z2p(neimax),
     2  fpn(neimax),dn(3,neimax),phi(neimax),phip(neimax),
     3  psip(neimax),p(natmax),k(natmax),jnei(neimax)
      data boltz/8.617e-5/
c
      if(natmax.ne.ntmax)then
          write(6,9090)
9090      format(' *****mismatch: parameter natmax in force*****')
          stop
      endif
      if(neimax.ne.nemax)then
          write(6,9091)
9091      format(' *****mismatch: parameter neimax in force*****')
          stop
      endif
c
c       clear the arrays used for computing running totals
c
      do 200 i = 1,natoms
      f(1,i) = 0.
      f(2,i) = 0.
      f(3,i) = 0.
200   continue
      stresst(1,1) = natoms*boltz*temp
      stresst(1,2) = 0.0
      stresst(1,3) = 0.0
      stresst(2,1) = 0.0
      stresst(2,2) = natoms*boltz*temp
      stresst(2,3) = 0.0
      stresst(3,1) = 0.0
      stresst(3,2) = 0.0
      stresst(3,3) = natoms*boltz*temp
c
c  compute the reciprocal of the grid spacings
c
      rdr = 1.0/dr
      rdrho = 1.0/drho
c
c     find f and fp for each particle
c
c       set up the interpolation over density
c
      do 2000 i=1,natoms
      p(i) = rho(i)*rdrho
      k(i) = p(i)
      k(i) = min0(k(i),nrho)
c      p(i) = p(i) - k(i)
2000  continue
c
c       store fsubi in e(i) and the derivative of fsubi in fp
c
      do 2100 i=1,natoms
      fp(i) = rdrho*frhop(k(i),itype(i))
2100  continue
c
c       add up energy and forces
c
      do 3000 i=1,natoms
c
c  obtain the information about the neighbors of the given atom
c
      call gnforc(i)
      do 3300 j=1,nnei
      rn(j) = sqrt(rn(j))
      p(j) = rn(j)*rdr
      k(j) = p(j)
      k(j) = min0(k(j),nr)
      p(j) = p(j) - k(j)
c       make sure that p is less than 1.0
c       then if r is out of range, p = 1.0 and rho = last value of rhor
      p(j) = dmin1(p(j),1.0d0)
3300  continue
c
c     find rhoip
c
      ity = itype(i)
      do 3400 j=1,nnei
      rhoip(j) = rdr*rhorp(k(j),ity)
3400  continue
c
c     find rhojp
c
c     find z**2, (z**2)-prime
c
ccdir$ novector
      do 3500 j=1,nnei
      jty = itype(jnei(j))
      z2(j) = z2r(k(j),ity,jty)
     1      + p(j)*z2rp(k(j),ity,jty)
      z2p(j) = rdr*z2rp(k(j),ity,jty)
      rhojp(j) = rdr*rhorp(k(j),jty)
      fpn(j) = fp(jnei(j))
3500  continue
ccdir$ vector
c
c     compute the contribution to the energy, pressure and forces at
c      particle i due to particle j
c
      do 3700 j=1,nnei
c       store 1/r in p
      p(j)=1.0/rn(j)
      dn(1,j) = dn(1,j)*p(j)
      dn(2,j) = dn(2,j)*p(j)
      dn(3,j) = dn(3,j)*p(j)
      phi(j) = z2(j) * p(j)
      phip(j) = z2p(j) * p(j) - phi(j) * p(j)
      psip(j) = fp(i)*rhojp(j) + fpn(j)*rhoip(j) + phip(j)
      f(1,i) = f(1,i) - psip(j) * dn(1,j)
      f(2,i) = f(2,i) - psip(j) * dn(2,j)
      f(3,i) = f(3,i) - psip(j) * dn(3,j)
3700  continue
c
c     compute the contribution to the energy, forces, and stress
c     tensor and forces at particle j due to particle i
c
c       do not include self-term
      do 3800 j=1,nnei
      f(1,jnei(j)) = f(1,jnei(j)) + psip(j) * dn(1,j)
      f(2,jnei(j)) = f(2,jnei(j)) + psip(j) * dn(2,j)
      f(3,jnei(j)) = f(3,jnei(j)) + psip(j) * dn(3,j)
3800  continue
c
c  compute the stress tensor
c
      do 3910 j = 1,nnei
      stresst(1,1) = stresst(1,1)
     1             - psip(j)*dn(1,j)*dn(1,j)*rn(j)
      stresst(1,2) = stresst(1,2)
     1             - psip(j)*dn(1,j)*dn(2,j)*rn(j)
      stresst(1,3) = stresst(1,3)
     1             - psip(j)*dn(1,j)*dn(3,j)*rn(j)
      stresst(2,2) = stresst(2,2)
     1             - psip(j)*dn(2,j)*dn(2,j)*rn(j)
      stresst(2,3) = stresst(2,3)
     1             - psip(j)*dn(2,j)*dn(3,j)*rn(j)
      stresst(3,3) = stresst(3,3)
     1             - psip(j)*dn(3,j)*dn(3,j)*rn(j)
3910  continue
      stresst(2,1) = stresst(1,2)
      stresst(3,1) = stresst(1,3)
      stresst(3,2) = stresst(2,3)
3000  continue
      pressi = 1.602e6*(stresst(1,1)+stresst(2,2)+stresst(3,3))/
     1         (3.0*perlen(1)*perlen(2)*perlen(3))
      return
      end
      subroutine gnforc(i)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      logical onlyoi,twoi,threei,fouri
      common /images/ onlyoi,twoi,threei,fouri
      common /wrkspc2/ fp(natmax),rn(neimax),dis(3,natmax),
     1  rhoip(neimax),rhojp(neimax),z2(neimax),z2p(neimax),
     2  fpn(neimax),dn(3,neimax),phi(neimax),phip(neimax),
     3  psip(neimax),p(natmax),k(natmax),jnei(neimax)
      dimension rperlen(3)
c
c  define the constants needed to find the nearest periodic image
c
      rperlen(1) = 1./perlen(1)
      rperlen(2) = 1./perlen(2)
      rperlen(3) = 1./perlen(3)
      hperlen(1) = 0.5*perlen(1)
      hperlen(2) = 0.5*perlen(2)
      hperlen(3) = 0.5*perlen(3)
c
c  branch to the appropriate neighbor finding method
c
      goto (1000,2000,90) nmeth
90    write(6,9991) nmeth
9991  format(1x,'undefined neighbor finding method, nmeth:',i3)
      call mcabort
1000  continue
c
c  nmeth = 1
c    this is the order n**2 method
c
c       first do off diagonal terms (i.ne.j)
c       fortran 77 convention: if i=1 then j=1,i-1 loop is skipped
c
      jend = i-1
c
c  compute the distance to the old coordinate if that is needed
c
      do 1100 j = 1,jend
c
c        compute the square of the distance to the closest periodic image
c
      dis(1,j) = rv(1,i) - rv(1,j)
      if (dis(1,j).gt.hperlen(1)) dis(1,j) = dis(1,j) - perlen(1)
      if (dis(1,j).lt.-hperlen(1)) dis(1,j) = dis(1,j) + perlen(1)
      dis(2,j) = rv(2,i) - rv(2,j)
      if (dis(2,j).gt.hperlen(2)) dis(2,j) = dis(2,j) - perlen(2)
      if (dis(2,j).lt.-hperlen(2)) dis(2,j) = dis(2,j) + perlen(2)
      dis(3,j) = rv(3,i) - rv(3,j)
      if (dis(3,j).gt.hperlen(3)) dis(3,j) = dis(3,j) - perlen(3)
      if (dis(3,j).gt.-hperlen(3)) dis(3,j) = dis(3,j) + perlen(3)
      p(j) = dis(1,j)**2 + dis(2,j)**2 + dis(3,j)**2
1100     continue
c
c     determine which pairs are separated by less than rcut
c     and store the needed information about these pairs
c
      nnei = 0
      do 1200 j = 1,jend
      if (p(j).gt.rcutsq.or.j.eq.i) go to 1200
      nnei = nnei + 1
      rn(nnei) = p(j)
      dn(1,nnei) = dis(1,j)
      dn(2,nnei) = dis(2,j)
      dn(3,nnei) = dis(3,j)
      jnei(nnei) = j
1200  continue
      if(nnei.gt.neimax)then
          write(6,9012)nnei,neimax
9012      format(' number of neighbors',i5,' exceeds array bound ',i5)
          call mcabort
      endif
      return
2000  continue
c
c  nmeth = 2
c
c  this is the neighbor list method
c
      jend = 0
      do 2110 j = 1,nnnum(nnmap(i))
      jtmp = nnj(nnlist(j,nnmap(i)))
      if (jtmp.ge.i) goto 2110
      jend = jend + 1
      dis(1,jend) = rv(1,jtmp)
      dis(2,jend) = rv(2,jtmp)
      dis(3,jend) = rv(3,jtmp)
      jnei(jend) = jtmp
2110  continue
c
c  check that jend is not too large
c
      if (jend.gt.neimax) then
         write (6,9901) jend
9901     format(1x,'too many neighbors jend=',i10)
         call mcabort
       endif
c
c  compute the square of the distance to the closest periodic image
c  for either the old, new or both set of positions
c
      do 2600 j = 1,jend
      dis(1,j) = rv(1,i) - dis(1,j)
      if (dis(1,j).gt.hperlen(1)) dis(1,j) = dis(1,j) - perlen(1)
      if (dis(1,j).lt.-hperlen(1)) dis(1,j) = dis(1,j) + perlen(1)
      dis(2,j) = rv(2,i) - dis(2,j)
      if (dis(2,j).gt.hperlen(2)) dis(2,j) = dis(2,j) - perlen(2)
      if (dis(2,j).lt.-hperlen(2)) dis(2,j) = dis(2,j) + perlen(2)
      dis(3,j) = rv(3,i) - dis(3,j)
      if (dis(3,j).gt.hperlen(3)) dis(3,j) = dis(3,j) - perlen(3)
      if (dis(3,j).lt.-hperlen(3)) dis(3,j) = dis(3,j) + perlen(3)
      p(j) = dis(1,j)**2 + dis(2,j)**2 + dis(3,j)**2
2600  continue
c
c     determine which pairs are separated by less than rcut
c     and store the needed information about these pairs
c
      nnei = 0
      do 2700 j = 1,jend
      if (p(j).gt.rcutsq) go to 2700
      nnei = nnei + 1
      rn(nnei) = p(j)
      dn(1,nnei) = dis(1,j)
      dn(2,nnei) = dis(2,j)
      dn(3,nnei) = dis(3,j)
      jnei(nnei) = jnei(j)
2700  continue
      if(nnei.gt.neimax)then
          write(6,9212)nnei,neimax
9212      format(' number of neighbors',i5,' exceeds array bound ',i5)
          call mcabort
      endif
      return
      end
