c****************************************************************************
c
c  this subroutine reads in the parameters required to restart
c  a run from fortran file 22
c
      subroutine restart(rstart)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      logical rstart
      dimension veldum(3)
      data veldum/3*0.0/
c
c  note that the old header is not passed to the rest of the
c  program
c
      if(natmax.ne.ntmax)then
          write(6,9090)
9090      format(' *****mismatch: parameter natmax in restart*****')
          call mcabort
      endif
      read(22,9501,end=8000) header
9501  format(a80)
      write(6,9001)header
9001  format(/,/'******  using restart  ',/,' previous header:',/,
     1       3x,a80,/)
      rstart=.true.
      read(22,9502) natoms,ntypes
c
c  check that the number of atoms is not too large
c
      if (natoms.gt.natmax) then
         write(6,9901) natoms,natmax
9901     format(1x,'natoms=',i6,' is greater than natmax=',i6)
         call mcabort
       end if
c
9502  format(2i10)
      write(6,9002)natoms,ntypes
9002  format(1x,i10,' atoms',i10,' particle types')
      read(22,9503) (perub(i),i=1,3),(perlb(i),i=1,3)
9503  format(3e25.16)
      read(22,9504) (amass(i),ielement(i),i=1,ntypes)
9504  format(e25.16,i10)
      read(22,9505) ((rv(i,j),i=1,3),(veldum(i),i=1,3),
     1               itype(j),j=1,natoms)
9505  format(3e25.16/3e25.16/i10)
c
c       print out types
c
      write(6,9100)
 9100 format('  restart uses these types: ')
      write(6,9102)
 9102 format('   type  element      amass  ',/,
     1       '   ----  -------    ---------')
      write(6,9103)(i,ielement(i),amass(i),i=1,ntypes)
 9103 format(1x,i4,i9,2x,g11.4)
c
c  compute perlen
c
      do 100 i = 1,3
100   perlen(i) = perub(i) - perlb(i)
      write(6,9031)
 9031 format('  periodicity   ',15x,'x',14x,'y',14x,'z')
      write(6,9032)perlb
 9032 format('  lower periodic bound  ',3g15.5)
      write(6,9033)perub
 9033 format('  upper periodic bound  ',3g15.5)
      write(6,9034)perlen
 9034 format('  length        ',8x,3g15.5)
c
 8000 return
      end
c***************************************************************
c
      subroutine storelat(latty,avec,bvec,cvec)
      include 'implicit.h'
      character*8 lstored(10),latty
      dimension avecs(3,10),bvecs(3,10),cvecs(3,10)
      dimension avec(3),bvec(3),cvec(3)
      data lstored/'fcc     ','bcc     ','sc      ',7*'        '/
      data avecs/1.,1.,0., 1.,1.,-1., 2.,0.,0., 21*0.0/
      data bvecs/0.,1.,1., -1.,1.,1., 0.,2.,0., 21*0.0/
      data cvecs/1.,0.,1., 1.,-1.,1., 0.,0.,2., 21*0.0/
c       primitive lattice vectors given in terms of half-lattice constants
      imatch = 0
      do 10 i=1,10
      if(latty.ne.lstored(i))go to 10
        imatch = 1
        do 5 j=1,3
        avec(j) = avecs(j,i)
        bvec(j) = bvecs(j,i)
        cvec(j) = cvecs(j,i)
 5      continue
 10   continue
      if(imatch.eq.1)return
      write(6,15)latty
 15   format('   could not find lattice type ',a8,
     1'. assume default type.')
c  assume default
      i = 1
      latty = lstored(i)
      do 20 j=1,3
      avec(j) = avecs(j,i)
      bvec(j) = bvecs(j,i)
      cvec(j) = cvecs(j,i)
 20   continue
      return
      end
c***************************************************************
c       deletes vacancies
c
      subroutine delvac
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
c
      if(natmax.ne.ntmax)then
          write(6,9090)
9090      format(' *****mismatch: parameter natmax in delvac*****')
          call mcabort
      endif
c
c       delete vacancies
      j = 0
      do 30 i=1,natoms
      if(itype(i).eq.0)go to 30
      j = j + 1
      itype(j) = itype(i)
      do 20 k=1,3
 20   rv(k,j) = rv(k,i)
 30   continue
      ndel = natoms - j
      natoms = j
      write(6,9000)ndel,natoms
9000  format(//' ****** deleted ',i10,' vacancies'/
     1,i10,' atoms left')
      return
      end
c***************************************************************
c       sorts atoms
c
      subroutine sorter
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      dimension idum1(natmax),idum2(natmax),dum1(natmax),
     .          idum3(natmax),dum(3,natmax)
      dimension rmult(3)
c
      if(natmax.ne.ntmax)then
          write(6,9090)
9090      format(' *****mismatch: parameter natmax in sorter*****')
          call mcabort
      endif
c
c       order according to non-periodic directions first
c
      ifail=0
      permax = dmax1(perlen(1),perlen(2),perlen(3))
      if(permax.ge.1000.)then
         call m01aaf(perlen,1,3,idum1,idum2,ifail)
         rmult(1) = 10**(4*idum1(1)-3)
         rmult(2) = 10**(4*idum1(2)-3)
         rmult(3) = 10**(4*idum1(3)-3)
         do 40 i=1,natoms
         dum1(i) = rmult(1)*(rv(1,i)-xbound(1)) +
     1      rmult(2)*(rv(2,i)-ybound(1)) + rmult(3)*(rv(3,i)-zbound(1))
 40      continue
      write(6,9010)idum1(1),idum1(2),idum1(3)
9010  format(//' ****** sorting according to following hierarchy:',
     1/'       x      y      z',
     2/1x,3i6)
      else
         do 45 i=1,natoms
         dum1(i) = rv(1,i)**2 + rv(2,i)**2 + rv(3,i)**2
 45      continue
      write(6,9015)
9015  format(//' ****** sorting according to distance from origin')
      endif
      call m01aaf(dum1,1,natoms,idum1,idum2,ifail)
      if(ifail.ne.0)write(6,9020)ifail
 9020 format('    trouble in sorting routine   ',i5)
      do 50 i=1,natoms
      j=idum1(i)
      idum3(j) = itype(i)
      do 50 k=1,3
 50   dum(k,j) = rv(k,i)
      do 60 i=1,natoms
      itype(i) = idum3(i)
      do 60 k=1,3
 60   rv(k,i) = dum(k,i)
      return
      end
c************************************************************************
c
c  this subroutine scales the lattice by an input scale factor
c
      subroutine scalem(scale)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      dimension scale(3)
      write(6,9001) scale
 9001 format(1x,'*******  scaling the input lattice  *******',/,
     $       1x,'scale factors:',3f20.16,/)
      xmid = 0.5*(perub(1)+perlb(1))
      ymid = 0.5*(perub(2)+perlb(2))
      zmid = 0.5*(perub(3)+perlb(3))
      perlen(1) = scale(1)*perlen(1)
      perlen(2) = scale(2)*perlen(2)
      perlen(3) = scale(3)*perlen(3)
      perlb(1) = xmid - 0.5*perlen(1)
      perlb(2) = ymid - 0.5*perlen(2)
      perlb(3) = zmid - 0.5*perlen(3)
      perub(1) = xmid + 0.5*perlen(1)
      perub(2) = ymid + 0.5*perlen(2)
      perub(3) = zmid + 0.5*perlen(3)
      do 100 i = 1,natoms
         rv(1,i) = xmid + scale(1)*(rv(1,i)-xmid)
         rv(2,i) = ymid + scale(2)*(rv(2,i)-ymid)
         rv(3,i) = zmid + scale(3)*(rv(3,i)-zmid)
  100 continue
      return
      end
c***************************************************************
c
c  this routine sets the parameters defining the interactions
c
      subroutine rdintr(s1,s2)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      character*80 funcfl(10),setfl
      character*80 s1(10),s2
      namelist /funccard/ funcfl,setfl
      do 10 i = 1,10
      funcfl(i) = 'none'
10    continue
      setfl = 'none'
      read(5,funccard)
      do 20 i = 1,10
      s1(i) = funcfl(i)
20    continue
      s2 = setfl
      return
      end
      subroutine inter
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      character*80 funcfl(10),setfl,iheader(nelmax)
      character*80 headst(3)
      character*8 lat(nelmax)
      dimension frhoin(ngrdin,nelmax),drhoin(nelmax),
     1  nrhoin(nelmax),rhorin(ngrdin,nelmax),zrin(ngrdin,nelmax),
     2  drin(nelmax),nrin(nelmax),z2rtmp(ngrdin,nelmax,nelmax)
      dimension rcut(nelmax),blat(nelmax)
      data conmas/1.0365e-4/
c  read in functions from disc files
c
c  the functions can be contained in either "funcfl" files or one "setfl"
c    file
c
c  "funcfl" files each contain one element
c  this version assumes that type 1 is on funcfl(1)
c                            type 2 is on funcfl(2)
c          and so forth
c  for these files, the geometric mean is assumed to be valid for
c  the pair interaction
c
c  "setfl" is a file describing a set of functions
c  for this set, the geometric mean can be violated
c
c  if setfl is specified, then the program ignores any funcfl files
c
      call rdintr(funcfl,setfl)
c
c  determine whether setfl or funcfl file is to be used
c
      if(setfl.eq.'none'.or.setfl.eq.'NONE') then
c
c  funcfl files here
c
        i = 0
 10     continue
        i = i + 1
        if (funcfl(i)(1:4).eq.'NONE'.or.
     $      funcfl(i)(1:4).eq.'none') goto 50
        if (i.gt.nelmax) then
          write(6,*)'number of elements greater than nelmax'
          call mcabort
         endif
        open(unit=10,file=funcfl(i))
        read(10,20) iheader(i)
 20     format(a80)
        read(10,30) ielement(i), amass(i), blat(i), lat(i)
 30     format(i5,2g15.5,a8)
        read(10,9901) nrhoin(i), drhoin(i), nrin(i), drin(i), rcut(i)
9901    format(i5,e24.16,i5,2e24.16)
c
c  assume that z(r) and rho(r) grids coincide
c
        read(10,9902) (frhoin(j,i),j=1,nrhoin(i))
        read(10,9902) (zrin(j,i),j=1,nrin(i))
        read(10,9902) (rhorin(j,i),j=1,nrin(i))
9902    format(5e24.16)
c
c close the interaction file
c
        close(10)
        go to 10
 50     continue
        ntypes = i - 1
c
c determine common grid spacings and number
c
        rmax = (nrin(1)-1)*drin(1)
        rhomax = (nrhoin(1)-1)*drhoin(1)
        do 80 i1=2,ntypes
        dr = dmax1(dr,drin(i1))
        drho = dmax1(drho,drhoin(i1))
        rmaxi = (nrin(i1)-1)*drin(i1)
        rhomaxi = (nrhoin(i1)-1)*drhoin(i1)
        rmax = dmax1(rmax,rmaxi)
        rhomax = dmax1(rhomax,rhomaxi)
80      continue
        nr = ngrid
        nrho = ngrid
c***********************************************************************
c  note that in this version the first element (i=1) corresponds to 
c  dr (drho) and not zero
c***********************************************************************
        dr = rmax/float(nr)
        drho = rhomax/float(nrho)
c
c set up the z(r) and rho(r) grids
c
        do 90 i1=1,ntypes
        do 85 j=1,nr
        r = (j)*dr
c
c  do four-point lagrange interpolation
c
        p = r/drin(i1) + 1.0
        k = p
        k = min0(k,nrin(i1)-2)
        k = max0(k,2)
        p = p - k
c       make sure that p is less than 2.0
c       then if r is out of range, p = 2.0 and rhor = last value of rhorin
        p = dmin1(p,2.0D0)
        cof1 = -0.166666667*p*(p-1.)*(p-2.)
        cof2 = 0.5*(p**2-1.)*(p-2.)
        cof3 = -0.5*p*(p+1.)*(p-2.)
        cof4 = 0.166666667*p*(p**2-1.)
        rhor(j,i1) = cof1*rhorin(k-1,i1)
     1      + cof2*rhorin(k,i1)
     2      + cof3*rhorin(k+1,i1)
     3      + cof4*rhorin(k+2,i1)
        z2r(j,i1,i1) = cof1*zrin(k-1,i1)
     1      + cof2*zrin(k,i1)
     2      + cof3*zrin(k+1,i1)
     3      + cof4*zrin(k+2,i1)
85      continue
90      continue
c
c  get the square of z
c
      do 91 i1 = 1,ntypes
      do 92 i2 = i1+1,ntypes
      do 93 j = 1,nr
      z2r(j,i1,i2) = 27.2*0.529*z2r(j,i1,i1)*z2r(j,i2,i2)
      z2r(j,i2,i1) = z2r(j,i1,i2)
93    continue
92    continue
      do 94 j = 1,nr
      z2r(j,i1,i1) = 27.2*0.529*z2r(j,i1,i1)**2
94    continue
91    continue
c
c set up the f(rho) grid
c
        do 100 i1=1,ntypes
        do 95 j=1,nrho
        r = (j)*drho
c
c  do four-point lagrange interpolation
c
        p = r/drhoin(i1) + 1.0
        k = p
        k = min0(k,nrhoin(i1)-2)
        k = max0(k,2)
        p = p - k
c       make sure that p is less than 2.0
c       then if r is out of range, p = 2.0 and rhor = last value of rhorin
        p = dmin1(p,2.0D0)
        cof1 = -0.166666667*p*(p-1.)*(p-2.)
        cof2 = 0.5*(p**2-1.)*(p-2.)
        cof3 = -0.5*p*(p+1.)*(p-2.)
        cof4 = 0.166666667*p*(p**2-1.)
        frho(j,i1) = cof1*frhoin(k-1,i1)
     1      + cof2*frhoin(k,i1)
     2      + cof3*frhoin(k+1,i1)
     3      + cof4*frhoin(k+2,i1)
95      continue
100     continue
c
c  get all the derivatives
c
      do 102 i1 = 1,ntypes
      do 104 j = 1,nr-1
      rhorp(j,i1) = rhor(j+1,i1) - rhor(j,i1)
104   continue
      rhorp(nr,i1) = 0.
      do 106 j = 1,nrho-1
      frhop(j,i1) = frho(j+1,i1) - frho(j,i1)
106   continue
      frhop(nrho,i1) = frhop(nrho-1,i1)
      do 108 i2 = 1,ntypes
      do 110 j = 1,nr-1
      z2rp(j,i1,i2) = z2r(j+1,i1,i2) - z2r(j,i1,i2)
110   continue
      z2rp(nr,i1,i2) = 0.
108   continue
102   continue
        rcutsq = 0.0
        do 120 i=1,ntypes
120     rcutsq = dmax1(rcutsq,rcut(i))
        if(rcutsq.eq.0.0)rcutsq = 5.0
c       print out types
        write(6,9000)
 9000   format(/,/' ******   interactions defined  ')
        write(6,9001)ntypes
 9001   format(1x,i5,' particle types')
        write(6,9002)
 9002   format('   type  element       amass              alat         ',
     1' lattype',/,
     2       '   ----  --------  --------------  ----------------    ',
     3'----------')
        write(6,9003)(i,ielement(i),amass(i),blat(i),lat(i),i=1,ntypes)
 9003   format(1x,i4,i9,g15.5,5x,g15.5,10x,a8)
      do 130 i=1,ntypes
c       print out header
      write(6,9004)
 9004 format('   type  file name  header',/,
     1       '   ----  ---------  ---------------')
      write(6,9005)i,funcfl(i),iheader(i)
 9005 format(1x,i4,5x,a8,3x,a80)
      write(6,9006)rcut(i)
 9006 format('   cut-off distance =',g15.5)
      if(ipinter.eq.1)then
         write(6,9007)
 9007 format('      r          z        rho              rho        f',/,
     1 '   --------  --------  ----------       --------  --------')
         do 140 j=1,nr
         jr = min0(j,nr)
         jrho = min0(j,nrho)
         r = (jr-1)*dr
         rhotmp = (jrho-1)*drho
         write(6,9008)r,z2r(jr,i,i),rhor(jr,i),rhotmp,frho(jrho,i)
 9008 format(1x,f10.5,g10.3,g12.5,f15.3,f10.3)
 140   continue
      endif
 130  continue
c
c  end of funcfl
c
      else
c
c  setfl file here
c
        open(unit=10,file=setfl)
        read(10,20) headst(1)
        read(10,20) headst(2)
        read(10,20) headst(3)
        read(10,150) ntypes
        if (ntypes.gt.nelmax) then
           write(6,*)'ntypes is greater than nelmax'
           call mcabort
         endif
 150    format(i5)
        read(10,9901) nrhost, drhost, nrst, drst, rcutall
        rcutsq = rcutall
        do 160 i=1,ntypes
        read(10,30) ielement(i),amass(i),blat(i),lat(i)
        read(10,9902) (frhoin(j,i),j=1,nrhost)
        read(10,9902) (rhorin(j,i),j=1,nrst)
 160    continue
        do 170 i1=1,ntypes
        do 170 i2=1,i1
170     read(10,9902) (z2rtmp(j,i1,i2),j=1,nrst)
        do 176 i1=1,ntypes
        do 175 i2=i1+1,ntypes
        do 174 j=1,nrst
        z2rtmp(j,i1,i2) = z2rtmp(j,i2,i1)
174     continue
175     continue
176     continue
        close(10)
        write(6,9000)
        write(6,9001)ntypes
        write(6,9002)
        write(6,9003)(i,ielement(i),amass(i),blat(i),lat(i),i=1,ntypes)
        write(6,9111)setfl
9111    format(1x,'    file name  ',a80)
c  print out header
        write(6,9112)
9112    format('   header',/,
     1         '   ________________')
        write(6,9115) (headst(i),i=1,3)
9115    format(4x,a80)
        write(6,9006)rcutsq
        if(ipinter.eq.1)then
           do 190 i=1,ntypes
           write(6,9116)i
9116       format(' type ',i5,/,
     1           ' _____________')
           write(6,9117)
9117       format('      r          rho              rho        f',/,
     1 '   --------  ----------       --------  --------')
           do 200 j=1,max0(nrst,nrhost)
           jr = min0(j,nrst)
           jrho = min0(j,nrhost)
           r = (jr-1)*drst
           rhotmp = (jrho-1)*drhost
           write(6,9118)r,rhorin(jr,i),rhotmp,frhoin(jrho,i)
9118       format(1x,f10.5,g10.3,g12.5,f15.3,f10.3)
200        continue
190        continue
           do 210 i1=1,ntypes
           do 210 i2=1,i1
           write(6,9126)i1,i2
9126        format(' types ',i5,i5,/,
     1            ' ______________________')
           write(6,9127)
9127       format('      r            z**2',/,
     1           '   _______      _____________')
           do 220 j=1,nrst
           r = (j-1)*drst
           write(6,9128)r,z2rtmp(j,i1,i2)
9128       format(1x,f10.5,g10.3)
220        continue
210        continue
        endif
c
c  convert the data to the fine grid
c
      rmax = (nrst-1)*drst
      nr = ngrid
c***********************************************************************
c  note that in this version the first element (i=1) corresponds to 
c  dr (drho) and not zero
c***********************************************************************
      dr = rmax/float(nr)
      rhomax = (nrhost-1)*drhost
      nrho = ngrid
      drho = rhomax/float(nrho)
        do 300 j=1,nr
        r = (j)*dr
c
c  do four-point lagrange interpolation
c
        p = r/drst + 1.0
        k = p
        k = min0(k,nrst-2)
        k = max0(k,2)
        p = p - k
c       make sure that p is less than 2.0
c       then if r is out of range, p = 2.0 and rhor = last value of rhorin
        p = dmin1(p,2.0D0)
        cof1 = -0.166666667*p*(p-1.)*(p-2.)
        cof2 = 0.5*(p**2-1.)*(p-2.)
        cof3 = -0.5*p*(p+1.)*(p-2.)
        cof4 = 0.166666667*p*(p**2-1.)
        do 310 i1=1,ntypes
        rhor(j,i1) = cof1*rhorin(k-1,i1)
     1      + cof2*rhorin(k,i1)
     2      + cof3*rhorin(k+1,i1)
     3      + cof4*rhorin(k+2,i1)
        do 320 i2 = 1,ntypes
        z2r(j,i1,i2) = cof1*z2rtmp(k-1,i1,i2)
     1      + cof2*z2rtmp(k,i1,i2)
     2      + cof3*z2rtmp(k+1,i1,i2)
     3      + cof4*z2rtmp(k+2,i1,i2)
320     continue
310     continue
300     continue
        do 330 j=1,nrho
        r = (j)*drho
c
c  do four-point lagrange interpolation
c
        p = r/drhost + 1.0
        k = p
        k = min0(k,nrhost-2)
        k = max0(k,2)
        p = p - k
c       make sure that p is less than 2.0
c       then if r is out of range, p = 2.0 and rhor = last value of rhorin
        p = dmin1(p,2.0D0)
        cof1 = -0.166666667*p*(p-1.)*(p-2.)
        cof2 = 0.5*(p**2-1.)*(p-2.)
        cof3 = -0.5*p*(p+1.)*(p-2.)
        cof4 = 0.166666667*p*(p**2-1.)
        do 340 i1=1,ntypes
        frho(j,i1) = cof1*frhoin(k-1,i1)
     1      + cof2*frhoin(k,i1)
     2      + cof3*frhoin(k+1,i1)
     3      + cof4*frhoin(k+2,i1)
340     continue
330     continue
c
c  get all the derivatives
c
      do 402 i1 = 1,ntypes
      do 404 j = 1,nr-1
      rhorp(j,i1) = rhor(j+1,i1) - rhor(j,i1)
404   continue
      rhorp(nr,i1) = 0.
      do 406 j = 1,nrho-1
      frhop(j,i1) = frho(j+1,i1) - frho(j,i1)
406   continue
      frhop(nrho,i1) = frhop(nrho-1,i1)
      do 408 i2 = 1,ntypes
      do 410 j = 1,nr-1
      z2rp(j,i1,i2) = z2r(j+1,i1,i2) - z2r(j,i1,i2)
410   continue
      z2rp(nr,i1,i2) = 0.
408   continue
402   continue
c
c  end of the setfl section
c
      endif
c
c       this is the only place where the mass is in amu
c       here we convert to eV-psec**2/angstrom**2
c       this is the unit used throughout the program
c       restart assumes this mass unit
c
      do 75 i=1,ntypes
75    amass(i) = conmas*amass(i)
      write(6,9009)rcutsq
 9009 format('  use this cut-off distance: ',g15.5)
      rcutsq = rcutsq**2
c
c       set the lattice constant to that for type 1 by default
      alat = blat(1)
      latty = lat(1)
      return
      end
c***************************************************************
c
      subroutine latgen
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      character*8 lattype
      dimension avec(3),bvec(3),cvec(3),xrot(3),yrot(3),zrot(3)
      dimension xold(3),yold(3),zold(3),avecp(3),bvecp(3),cvecp(3)
      dimension roter(3,3),aperub(3),aperlb(3)
      dimension axbnd(2),aybnd(2),azbnd(2)
      dimension rcell(3,10),ccell(nelmax,10)
      dimension perubl(3),perlbl(3)
      namelist /latcard/ lattype,avec,bvec,cvec,alat,xrot,yrot,zrot,
     1perub,perlb,xbound,ybound,zbound,aperub,aperlb,axbnd,aybnd,
     2azbnd,ncell,rcell,ccell
      data one/1.0/
c
c  default values for namelist
c
      alat = 3.52
      lattype = 'undefine'
      do 1 i = 1,3
      xrot(i) = 0.
      yrot(i) = 0.
      zrot(i) = 0.
      xold(i) = 0.
      yold(i) = 0.
      zold(i) = 0.
      avec(i) = 0.
      bvec(i) = 0.
      cvec(i) = 0.
      perub(i) = 9999.
      perlb(i) = -9999.
      aperlb(i) = -9999.
      aperub(i) = 9999.
    1 continue
      xold(1) = 1.
      yold(2) = 1.
      zold(3) = 1.
      xbound(1) = -9999.
      xbound(2) = 9999.
      ybound(1) = -9999.
      ybound(2) = 9999.
      zbound(1) = -9999.
      zbound(2) = 9999.
      axbnd(1) = -9999.
      axbnd(2) = 9999.
      aybnd(1) = -9999.
      aybnd(2) = 9999.
      azbnd(1) = -9999.
      azbnd(2) = 9999.
      ncell = 1
      do 2 j = 1,10
      rcell(1,j) = 0.
      rcell(2,j) = 0.
      rcell(3,j) = 0.
      do 2 i = 1,nelmax
    2    ccell(i,j) = 0.
      ccell(1,1) = 1.
c
      if(natmax.ne.ntmax)then
          write(6,9090)
9090      format(' *****mismatch: parameter natmax in latgen*****')
          call mcabort
      endif
c
c  read the lattice parameters
c
      read(5,latcard)
c      write(6,latcard)
      alatl = alat
      perubl(1) = perub(1)
      perubl(2) = perub(2)
      perubl(3) = perub(3)
      perlbl(1) = perlb(1)
      perlbl(2) = perlb(2)
      perlbl(3) = perlb(3)
c
c  if no periodic bounds set, assume a 4 period cube and scale the
c  periodic lengths from units of lattice constants to real units
c
      do 3 i = 1,3
      if (perlbl(i).le.-9998..and.aperlb(i).le.-9998.) aperlb(i) = -2.0
      if (perubl(i).ge.9998..and.aperub(i).ge.9998.) aperub(i) = 2.0
      if (perlbl(i).le.-9998.) perlbl(i) = alatl*aperlb(i)
      if (perubl(i).ge.9998.) perubl(i) = alatl*aperub(i)
3     continue
c
c  set the x,y,and z bounds to fill the periodic bounds if they have not
c  been set by the user
c
      if (axbnd(1).gt.-9998.) xbound(1) = alatl*axbnd(1)
      if (aybnd(1).gt.-9998.) ybound(1) = alatl*aybnd(1)
      if (azbnd(1).gt.-9998.) zbound(1) = alatl*azbnd(1)
      if (axbnd(2).lt.9998.) xbound(2) = alatl*axbnd(2)
      if (aybnd(2).lt.9998.) ybound(2) = alatl*aybnd(2)
      if (azbnd(2).lt.9998.) zbound(2) = alatl*azbnd(2)
      if (xbound(1).le.-9998.) xbound(1) = perlbl(1) + 0.01
      if (xbound(2).ge.9998.) xbound(2) = perubl(1) + 0.01
      if (ybound(1).le.-9998.) ybound(1) = perlbl(2) + 0.01
      if (ybound(2).ge.9998.) ybound(2) = perubl(2) + 0.01
      if (zbound(1).le.-9998.) zbound(1) = perlbl(3) + 0.01
      if (zbound(2).ge.9998.) zbound(2) = perubl(3) + 0.01
c
c  see if primitive lattice vectors have been defined
c  if not, find them using lattype
c      if lattype is not defined from namelist, then use latty of
c      first atom type
      primdef = (avec(1)**2 + avec(2)**2 + avec(3)**2)*
     1(bvec(1)**2 + bvec(2)**2 + bvec(3)**2)*
     2(cvec(1)**2 + cvec(2)**2 + cvec(3)**2)
      if(primdef.ne.0.0)then
         lattype = 'user'
      else
         if(lattype.eq.'undefine')lattype = latty
         call storelat(lattype,avec,bvec,cvec)
      endif
      write(6,9115)lattype
9115  format(//' ******  generating ',a8,' lattice ')
      write(6,9116)avec,bvec,cvec
9116  format(' primitive lattice vectors ',3f5.2,3x,3f5.2,3x,3f5.2)
      xnorm = anrm2(3,xrot,1)
      ynorm = anrm2(3,yrot,1)
      znorm = anrm2(3,zrot,1)
c
c       if two defined, find missing one from them
c
      if((xnorm.ne.0.0).and.(ynorm.ne.0.0).and.(znorm.eq.0.0))
     1      call cross(zrot,xrot,yrot)
      if((ynorm.ne.0.0).and.(znorm.ne.0.0).and.(xnorm.eq.0.0))
     1      call cross(xrot,yrot,zrot)
      if((znorm.ne.0.0).and.(xnorm.ne.0.0).and.(ynorm.eq.0.0))
     1      call cross(yrot,zrot,xrot)
c
c       if none or only one defined, set equal to no rotation
c
      if((xnorm*ynorm.eq.0.0).and.(xnorm*znorm.eq.0.0).
     1and.(ynorm*znorm.eq.0.0))then
            call acopy(3,xold,1,xrot,1)
            call acopy(3,yold,1,yrot,1)
            call acopy(3,zold,1,zrot,1)
      endif
c
c       normalize the unit vectors and define rotation matrix
c
      xnorm = anrm2(3,xrot,1)
      ynorm = anrm2(3,yrot,1)
      znorm = anrm2(3,zrot,1)
      do 5 i=1,3
      xrot(i) = xrot(i)/xnorm
      yrot(i) = yrot(i)/ynorm
      zrot(i) = zrot(i)/znorm
5     continue
      do 10 i=1,3
      do 10 j=1,3
      roter(i,j)= xold(i)*xrot(j) + yold(i)*yrot(j) + zold(i)*zrot(j)
10    continue
c
c       rotate avec,bvec,cvec
c
      do 20 i=1,3
      avecp(i)=0.0
      bvecp(i)=0.0
      cvecp(i)=0.0
      do 20 j=1,3
      avecp(i) = avecp(i) + roter(i,j)*avec(j)
      bvecp(i) = bvecp(i) + roter(i,j)*bvec(j)
 20   cvecp(i) = cvecp(i) + roter(i,j)*cvec(j)
      do 30 i=1,3
      avec(i) = avecp(i)
      bvec(i) = bvecp(i)
 30   cvec(i) = cvecp(i)
      write(6,9216)avec,bvec,cvec
9216  format(' rotated lattice vectors   ',3f5.2,3x,3f5.2,3x,3f5.2)
c
c  compute perlen
c
      do 50 i = 1,3
      perub(i) = perubl(i)
      perlb(i) = perlbl(i)
50     perlen(i) = perubl(i) - perlbl(i)
c
c       half-lattice constant (angstroms)
c
      ahlc = 0.5*alatl
      write(6,9030)ahlc
 9030 format(' half-lattice constant = ',g15.5)
      write(6,9031)
 9031 format('                ',15x,'x',14x,'y',14x,'z')
      write(6,9032)xbound(1),ybound(1),zbound(1)
 9032 format(' lower cell bound      ',3g15.5)
      write(6,9033)xbound(2),ybound(2),zbound(2)
 9033 format(' upper cell bound      ',3g15.5)
      write(6,9034)perlbl
 9034 format(' lower periodic bound  ',3g15.5)
      write(6,9035)perubl
 9035 format(' upper periodic bound  ',3g15.5)
      write(6,9036)perlen
 9036 format(' length        ',8x,3g15.5)
      xlen = max(abs(avec(1)),abs(bvec(1)),abs(cvec(1)))*ahlc
      ylen = max(abs(avec(2)),abs(bvec(2)),abs(cvec(2)))*ahlc
      zlen = max(abs(avec(3)),abs(bvec(3)),abs(cvec(3)))*ahlc
      nsidex = int((xbound(2)-xbound(1))/xlen) + 1
      nsidey = int((ybound(2)-ybound(1))/ylen) + 1
      nsidex = max(nsidex,nsidey)
      nsidez = int((zbound(2)-zbound(1))/zlen) + 1
      nsidex = max(nsidex,nsidez)
      nsidex = 2*nsidex
      ncentx = int(0.6 + float(nsidex)/2.)
      do 190 l = 1,ncell
      do 190 m = 2,ntypes
      ccell(m,l) = min(one,ccell(m-1,l) + ccell(m,l))
190   continue
      natoms = 0
      do 200 i=1,nsidex
      ii = i - ncentx
      do 201 j=1,nsidex
      jj = j - ncentx
      do 202 k=1,nsidex
      kk = k - ncentx
      xc = ahlc*(ii*avec(1) + jj*bvec(1) + kk*cvec(1))
      yc = ahlc*(ii*avec(2) + jj*bvec(2) + kk*cvec(2))
      zc = ahlc*(ii*avec(3) + jj*bvec(3) + kk*cvec(3))
      do 203 l = 1,ncell
      x = xc + rcell(1,l)
      y = yc + rcell(2,l)
      z = zc + rcell(3,l)
      if(x.ge.xbound(2))go to 203
      if(x.lt.xbound(1))go to 203
      if(y.ge.ybound(2))go to 203
      if(y.lt.ybound(1))go to 203
      if(z.ge.zbound(2))go to 203
      if(z.lt.zbound(1))go to 203
      tst = ranl()
      it = 0
      do 205 m=ntypes,1,-1
  205    if (tst.lt.ccell(m,l)) it = m
      natoms = natoms + 1
      if(natoms.gt.natmax)go to 300
      itype(natoms) = it
      rv(1,natoms) = x
      rv(2,natoms) = y
      rv(3,natoms) = z
  203 continue
  202 continue
  201 continue
 200  continue
      return
c
 300  write(6,9601)natmax
 9601 format('   number of atoms generated exceeds maximum dimension:'
     1 ,i10)
      return
      end
c*******************************************************************
c
c  dummy program to read the latcard namelist entry
c
      subroutine latdum
      include 'param.h'
      include 'implicit.h'
      character*8 lattype
      dimension avec(3),bvec(3),cvec(3),xrot(3),yrot(3),zrot(3)
      dimension perub(3),perlb(3),xbound(2),ybound(2),zbound(2)
      dimension aperub(3),aperlb(3),axbnd(2),aybnd(2),azbnd(2)
      dimension rcell(3,10),ccell(nelmax,10)
      namelist /latcard/ lattype,avec,bvec,cvec,alat,xrot,yrot,zrot,
     1perub,perlb,xbound,ybound,zbound,aperub,aperlb,axbnd,aybnd,
     2azbnd,ncell,rcell,ccell
c
c  read the namelist latcard.  note that the values are discarded.
c
      read(5,latcard)
      return
      end
c*****************************************************************************
c
c  the subroutine readef reads in the defcards
c
      subroutine readef(ndef)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      integer type,oldtype,newtype
      dimension num(2),pos(3),delpos(3)
      namelist /defcard/ num,type,oldtype,pos,delpos,newtype,
     1                   xmin,xmax,ymin,ymax,zmin,zmax
c
c  initialize the count of the number of real defcards
c
      ndef = 0
100   continue
c
c   set all the values of the namelist variables to their default values
c
      newtype = 99
      oldtype = 99
      type = 99
      num(1) = -1
      num(2) = -1
      do 10 i = 1,3
      pos(i) = 9999.
      delpos(i) = 0.
10    continue
      xmin = -9999.
      xmax = 9999.
      ymin = -9999.
      ymax = 9999
      zmin = -9999.
      zmax = 9999.
c
c  read in the next defcard and check to see if anyting is changed
c
      read(5,defcard)
      if (newtype.ne.99) type=newtype
      if (num(1).ne.-1) goto 1000
      if (num(2).ne.-1) goto 1000
      if (type.ne.99) goto 1000
      if (oldtype.ne.99) goto 1000
      if (xmin.ne.-9999..or.xmax.ne.9999.) goto 1000
      if (ymin.ne.-9999..or.ymax.ne.9999.) goto 1000
      if (zmin.ne.-9999..or.zmax.ne.9999.) goto 1000
      if (delpos(1).ne.0.) goto 1000
      if (delpos(2).ne.0.) goto 1000
      if (delpos(3).ne.0.) goto 1000
c
c  nothing changed so return
c
      return
c
1000  continue
c
c  there is a nontrivial defcard
c
      ndef = ndef + 1
      write(6,defcard)
c
c  branch depending on whether the defects are specified by number or position
c
      if (num(1).ne.-1) goto 1500
c
c  specified by position
c
      do 1100 i = 1,natoms
      if (rv(1,i).lt.xmin.or.rv(1,i).gt.xmax) goto 1100
      if (rv(2,i).lt.ymin.or.rv(2,i).gt.ymax) goto 1100
      if (rv(3,i).lt.zmin.or.rv(3,i).gt.zmax) goto 1100
      if (oldtype.ne.99.and.itype(i).ne.oldtype) goto 1100
      if (type.ne.99) itype(i) = type
      do 1110 j = 1,3
      if (pos(j).ne.9999.) then
         rv(j,i) = pos(j)
       else
         rv(j,i) = rv(j,i) + delpos(j)
       endif
1110  continue
1100  continue
      goto 100
c
c  specified by number
c
1500  continue
      if (num(2).eq.-1) num(2) = num(1)
c
c  creating a new atom
c
      if (num(1).eq.0) then
         natoms = natoms + 1
         n = natoms
         if (type.ne.99) then
            itype(n) = type
          else
            itype(n) = 1
          endif
         rv(1,n) = pos(1)
         rv(2,n) = pos(2)
         rv(3,n) = pos(3)
       else
c
c  modify existing atoms
c
         do 1600 i = num(1),num(2)
         if (oldtype.ne.99.and.itype(i).ne.oldtype) goto 1600
         if (type.ne.99) itype(i) = type
         do 1610 j = 1,3
         if (pos(j).ne.9999.) then
            rv(j,i) = pos(j)
          else
            rv(j,i) = rv(j,i) + delpos(j)
          endif
1610     continue
1600     continue
       endif
      goto 100
      end
c**********************************
c
c  routines to fix namelist problems
c
c**********************************
      subroutine rdprnt()
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      namelist /prntcard/ ipinter,ipatoms,ipave,ipitera,
     $                    printf,rstrtf,conff,avef
      ipinter = 0
      ipatoms = 3
      ipave = 0
      ipitera = -1
      iconf = 0
      printf = 'none'
      rstrtf = 'none'
      avef = 'none'
      conff = 'none'
      read(5,prntcard)
c      write(6,prntcard)
      return
      end
c
      subroutine rdhead()
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      namelist /headcard/ header
      read(5,headcard)
      return
      end
c
      subroutine rdinit(l1,l2,ascale)
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      logical genlat,sort
      logical l1,l2
      dimension ascale(3),scale(3)
      namelist /initcard/ genlat,sort,initf,scale
      initf = 'none'
      genlat = .false.
      sort = .true.
      scale(1) = -9999.
      scale(2) = -9999.
      scale(3) = -9999.
      read(5,initcard)
      l1 = genlat
      l2 = sort
      if (scale(1).lt.0.) then
         ascale(1) = 1.0
        else
         ascale(1) = scale(1)
        endif
      if (scale(2).lt.0.) then
         ascale(2) = ascale(1)
        else
         ascale(2) = scale(2)
        endif
      if (scale(3).lt.0.) then
         ascale(3) = ascale(2)
        else
         ascale(3) = scale(3)
        endif
      return
      end
c
      subroutine rdnei()
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      namelist /neicard/ nmeth,dradn
      nmeth = 2
      dradn = 0.75
      read(5,neicard)
c      write(6,neicard)
      return
      end
c
      subroutine rdsim
      include 'param.h'
      include 'implicit.h'
      include 'common.h'
      namelist /simcard/ nstep,temp,press,ioutput,chmpot,idbrog
      nstep = 1000
      ioutput = 100
      temp = 300.
      press = 0.
      do 10 i = 1,10
   10    chmpot(i) = 0.
      idbrog = 1
      read(5,simcard)
c      write(6,simcard)
      return
      end
