#include "header.h"

scalar determinant(Nvector A)
{
  if (A.nvecs != A.vecsize)
    die("Matrix not square in determinant!\n");

  if (A.nvecs == 1)
    return (A[0][0]);
  else if (A.nvecs == 2)
    return (A[0][0] * A[1][1] - A[1][0] * A[0][1]);
  else
    die ("n > 2.  Generalized determinant not yet implemented.\n");
}

Nvector inverse (Nvector A)
{
  if (A.nvecs != A.vecsize)
    die ("Matrix not square in inverse!\n");
  
  Nvector inv(A.nvecs, A.vecsize);
  
  if (A.nvecs == 1)
    inv[0][0] = 1.0 / A[0][0];
  else if (A.nvecs == 2)
    {
      scalar invdet = 1.0 / determinant (A);
      inv[0][0] = invdet * A[1][1];
      inv[0][1] = invdet * -A[0][1];      
      inv[1][0] = invdet * -A[1][0];
      inv[1][1] = invdet * A[0][0];
    }  
  else
    die("Inverse not implmented for N > 2. \n");
  return(inv);
}

namespace TNT
{
  
  Nvector multiply (Nvector &A, Nvector &B)
    {
      if (A.vecsize != B.nvecs)
	die ("Mismatch matrix dimensions in multiplication!\n");
      
      Nvector mult(A.nvecs, B.vecsize);
      
      if ( (A.nvecs == 1) && (A.vecsize == 1) )
	mult[0][0] = A[0][0] * B[0][0];
      else
	{
	  for (int i=0; i<A.nvecs; i++)
	    {
	      for (int k=0; k<B.vecsize; k++)
		{
		  scalar sum = 0;
		  for (int j=0; j<A.vecsize; j++)
		    {
		      sum = sum + A[i][j]*B[j][k];
		    }
		  mult[i][k] = sum;
		}
	    }
	}
      return(mult);
    }
 
}



Nvector MatrixDot(Nvector &A, Nvector &B)
{
  if ((A.vecsize != B.vecsize) || (A.nvecs != B.nvecs))
    die("Dimension mismatch in MatrixDot.\n");
  
  Nvector prod(A.nvecs, A.vecsize);
  
  for(int i=0; i<A.nvecs; i++)
    for(int j=0; j<A.vecsize; j++)
      prod[i][j] = A[i][j] * B[i][j];
  return(prod);
}

