#include "header.h"
#include <math.h>

const int Linear = 1;
const int Log = 2;

// Note that since we have a Coulomb interaction, there is no
// dependence on j, so that we have only k as a subscript.

class PairTable
{
 public:
  Nvector uk;
  int GridType;
  int NumqVals, NumOrder;

  scalar qmin, qmax, delta;

  inline int qindex(scalar q)
    {
      if (GridType == Linear)
	return((int) floor ((q - qmin) / delta));
      else
	die ("Non-linear grid spacing not implemented!\n");
    }
  
  inline scalar interp (scalar q, int order)
    {
      if (q >= qmax)
	{
	  printf ("qmax = %1.5f  q = %1.5f.\n", qmax, q);
	  die ("Outside table in PairTable.interp.\n");
	}
      
      if (GridType == Linear)
	{
	  int index = qindex(q);
	  scalar remainder = (q-qmin)/delta - index;

	  return (uk[index][order] + 
		  remainder * (uk[index+1][order] - uk[index][order]));
	}	  
    }        
  int read (char *filename);
};





class PairAction
{
 public:
  // First, some preliminaries.  We should keep track of the number of
  // electrons and ions.  We also need to store the value of tau for
  // this particlar action.

  scalar tau;

  int NumElecs, NumIons;
  int NumSpecies;  // Number of different ionic species, eg: H, Li, C, etc

  // First we need a table for the electron-electron terms;
  PairTable ee;

  // Now we need pair tables for the interaction of the electrons with
  // each of the electron-ion terms.  We will implement this as a
  // vector of PairTables.
  Vector<PairTable> eion;

  // We need to know which PairTable to associate with each of the
  // ions.  We will use a vector of integers for each ion to represent
  // this.  
  Vector<int> Species;

  // We may also need to calculate the semiclassical action if we are
  // ourside our PairTable.  In this case, we will need the charges of
  // the ions.
  Vector<scalar> Zions;

  // Finally, since we aren't going to be moving the ions around, we
  // might as well store the positions of the ions within the class.

  Nvector Rions;

  // Now let's define the work-horses of the class.  These will
  // calculate the potential part of the action and the kinetic part
  // of the action for a single link.

  scalar PotentialLinkAction(Nvector R, Nvector Rprime);
  scalar PrimitivePotentialLinkAction(Nvector R, Nvector Rprime);
  scalar KineticLinkAction(Nvector R, Nvector Rprime);

  void read (char *filename);
};





