

// Test Cholesky module  

#include <iostream>

#include "tnt.h"
#include "vec.h"
#include "cmat.h"
#include "cholesky.h"
#include "trislv.h"
#include "transv.h"         /* transpose views */

using namespace std;
using namespace TNT;

int main()
{
    Matrix<double> A;

    cin >> A;                   /* A should be symmetric positive definite */

    Subscript N = A.num_rows();
    assert(N == A.num_cols());

    Vector<double> b(N, 1.0);   // b= [1,1,1,...]
    Matrix<double> L(N, N);

    //cout.setf(ios_base::fixed, ios_base::floatfield);
    //cout.precision(4);
    //cout.width(5);

    cout << "A: " << A << endl;
    
    if (Cholesky_upper_factorization(A, L) !=0)
    {
        cout << "Cholesky did not work." << endl;
        exit(1);
    }
    

    cout << L << endl;

    // solve Ax =b, as L*L'x =b
    //
    //  let y=L'x, then
    //
    //
    //   solve L y = b;
    //   solve L'x = y;

    Vector<double> y = Lower_triangular_solve(L, b);
    Vector<double> x= Upper_triangular_solve(Transpose_view(L), y);

    //cout.setf(ios_base::scientific, ios_base::floatfield);
    //cout.precision(4);

    cout << "x: " << x << endl;
    cout << "Residual A*x-b: " << A*x-b << endl;

	return 0;
}
